/*
 * status.c
 *
 * process (and perhaps display) status messages
 * replace this with a logging function if you prefer
 * the messages to go elsewhere
 *
 */

#include <varargs.h>
#ifdef BOUNDS_CHECK
#include <bounds/fix-args.h>
#endif
#include "lwp.h"

void lwpStatus(va_alist)
	va_dcl
{
	va_list	ap;
	struct lwpProc *proc;
	char	*format;
	static	struct timeval startTime;
	struct	timeval tv;
	char	buf[1024];
	int	sec, msec;

	va_start(ap);
	proc = va_arg(ap, struct lwpProc *);
	format = va_arg(ap, char *);
	if (proc->flags & LWP_PRINT) {
		if (startTime.tv_sec == 0)
			gettimeofday(&startTime, 0);
		gettimeofday(&tv, 0);
		sec = tv.tv_sec - startTime.tv_sec;
		msec = (tv.tv_usec - startTime.tv_usec) / 1000;
		if (msec < 0) {
			sec++;
			msec += 1000;
		}
		vsprintf(buf, format, ap);
		printf("%d:%02d.%03d %17s[%d]: %s\n", sec/60, sec%60, msec/10,
			proc->name, proc->pri, buf);
	}
	va_end(ap);
}
