/*
 * init.c
 *
 * initialize global unit arrays to make sure they're self-consistent
 * Ken Stevens
 * July 1995
 */

#include "misc.h"
#include "var.h"
#include "ship.h"
#include "plane.h"

global_init()
{
	init_mchr();
	init_pchr();
	/* the same thing should be done for units... */
}

init_mchr()
{
	register struct mchrstr *mp;
	register int n;

	for (mp = mchr, n = 0; n < shp_maxno; n++, mp++) {
		if (mp->m_nxlight)
			mp->m_flags |= M_XLIGHT;
		if (mp->m_nchoppers)
			mp->m_flags |= M_CHOPPER;
		if (mp->m_nplanes && !(mp->m_flags & M_MSL || mp->m_flags & M_FLY))
			mp->m_flags |= M_MSL;
		if (mp->m_nland)
			mp->m_flags |= M_UNIT;
	}
}

init_pchr()
{
	register struct plchrstr *pp;
	int     pcount;

	for (pp = plchr, pcount = 0; pcount < pln_maxno; pcount++, pp++) {
		if (pp->pl_flags & P_M)
			pp->pl_flags |= P_V;
	}
}
