#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/dump.c,v 2.0 1995/01/25 19:23:25 empire Exp $";
#endif

/*
 * dump.c
 *
 * dump sector information (census, commodity, cutoff and level)
 *
 * Jeff Wallace (jeffw@scam.Berkeley.EDU) 02-23-89
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "path.h"
#include "file.h"


dump()
{
	struct	sctstr sect;
	s_char	dirstr[20];
	int	nsect;
	int	n;
	struct	nstr_sect nstr;
	int     del[I_MAX+1];
        int     dist[I_MAX+1];
        int     item[I_MAX+1];
	struct  natstr *np;

	if (!snxtsct(&nstr, player->argp[1]))
		return RET_SYN;
	prdate();
	(void) strcpy(dirstr, ".      $");
	n = 1;
	for (n = 1; n <= 6; n++)
		dirstr[n] = dirch[n];
	nsect = 0;
   	np = getnatp(player->cnum); 
	while (nxtsct(&nstr, &sect)) {
		if (!player->owner)
			continue;
		if (nsect++ == 0) {
			if (player->god)
				pr("   ");
			pr("DUMP SECTOR\n");
			if (player->god)
				pr("own ");
			pr("x y des sdes eff mob * off ");
			pr("min gold fert ocontent uran work avail terr ");
			pr("civ mil uw food shell gun pet iron ");
			pr("dust bar oil lcm hcm rad ");
			pr("u_del f_del s_del g_del p_del i_del ");
			pr("d_del b_del o_del l_del h_del r_del ");
			pr("u_cut f_cut s_cut g_cut p_cut i_cut ");
			pr("d_cut b_cut o_cut l_cut h_cut r_cut ");
			pr("dist_x dist_y ");
			pr("c_dist m_dist u_dist f_dist s_dist g_dist p_dist i_dist ");
			pr("d_dist b_dist o_dist l_dist h_dist r_dist\n");
		}
/* census */
		if (player->god)
			pr("%d ", sect.sct_own);
		getvec(VT_DEL, del, (s_char *)&sect, EF_SECTOR);
                getvec(VT_DIST, dist, (s_char *)&sect, EF_SECTOR);
                getvec(VT_ITEM, item, (s_char *)&sect, EF_SECTOR);
	 	if (player->god)
			pr("%d %d ", xrel(np,nstr.x), yrel(np,nstr.y));
		else 
			pr("%d %d ", xrel(np,nstr.x), yrel(np,nstr.y));

		pr("%c ", dchr[sect.sct_type].d_mnem);
		if (sect.sct_newtype != sect.sct_type)
			pr("%c ", dchr[sect.sct_newtype].d_mnem);
		else
			pr("_ ");
		pr("%d ", sect.sct_effic);
		pr("%d ", sect.sct_mobil);
		pr("%c ", sect.sct_own != sect.sct_oldown ? '*' : '.');
		pr("%d ", sect.sct_off);
		pr("%d ", sect.sct_min);
		pr("%d ", sect.sct_gmin);
		pr("%d ", sect.sct_fertil);
		pr("%d ", sect.sct_oil);
		pr("%d ", sect.sct_uran);
		pr("%d ", sect.sct_work);
		pr("%d ", sect.sct_avail);
	    	pr("%d ", sect.sct_terr);
		pr("%d ", item[I_CIVIL]);
		pr("%d ", item[I_MILIT]);
		pr("%d ", item[I_UW]);
		pr("%d ", item[I_FOOD]);
/* commodity */
		pr("%d ", item[I_SHELL]);
		pr("%d ", item[I_GUN]);
		pr("%d ", item[I_PETROL]);
		pr("%d ", item[I_IRON]);
		pr("%d ", item[I_DUST]);
		pr("%d ", item[I_BAR]);
		pr("%d ", item[I_OIL]);
		pr("%d ", item[I_LCM]);
		pr("%d ", item[I_HCM]);
		pr("%d ", item[I_RAD]);
/* cutoff */
                pr("%c ", dirstr[del[I_UW] & 0x7]);
                pr("%c ", dirstr[del[I_FOOD] & 0x7]);
                pr("%c ", dirstr[del[I_SHELL] & 0x7]);
                pr("%c ", dirstr[del[I_GUN] & 0x7]);
		pr("%c ", dirstr[del[I_PETROL] & 0x7]);
                pr("%c ", dirstr[del[I_IRON] & 0x7]);
                pr("%c ", dirstr[del[I_DUST] & 0x7]);
                pr("%c ", dirstr[del[I_BAR] & 0x7]);
                pr("%c ", dirstr[del[I_OIL] & 0x7]);
                pr("%c ", dirstr[del[I_LCM] & 0x7]);
                pr("%c ", dirstr[del[I_HCM] & 0x7]);
                pr("%c ", dirstr[del[I_RAD] & 0x7]);
                pr("%d ", del[I_UW] & ~0x7);
                pr("%d ", del[I_FOOD] & ~0x7);
                pr("%d ", del[I_SHELL] & ~0x7);
                pr("%d ", del[I_GUN] & ~0x7);
                pr("%d ", del[I_PETROL] & ~0x7);
                pr("%d ", del[I_IRON] & ~0x7);
                pr("%d ", del[I_DUST] & ~0x7);
                pr("%d ", del[I_BAR] & ~0x7);
                pr("%d ", del[I_OIL] & ~0x7);
                pr("%d ", del[I_LCM] & ~0x7);
                pr("%d ", del[I_HCM] & ~0x7);
                pr("%d ", del[I_RAD] & ~0x7);
/* level */
		pr("%d %d ", xrel(getnatp(player->cnum),sect.sct_dist_x),
			yrel(getnatp(player->cnum),sect.sct_dist_y));
                pr("%d ", dist[I_CIVIL]);
                pr("%d ", dist[I_MILIT]);
                pr("%d ", dist[I_UW]);
                pr("%d ", dist[I_FOOD]);
                pr("%d ", dist[I_SHELL]);
                pr("%d ", dist[I_GUN]);
                pr("%d ", dist[I_PETROL]);
                pr("%d ", dist[I_IRON]);
                pr("%d ", dist[I_DUST]);
                pr("%d ", dist[I_BAR]);
                pr("%d ", dist[I_OIL]);
                pr("%d ", dist[I_LCM]);
                pr("%d ", dist[I_HCM]);
                pr("%d", dist[I_RAD]);
		pr("\n");
	}
	if (nsect == 0) {
		if (player->argp[1])
			pr("%s: No sector(s)\n", player->argp[1]);
		else
			pr("%s: No sector(s)\n", "");
		return RET_FAIL;
	}else
		pr("%d sector%s\n", nsect, splur(nsect));
	return RET_OK;
}

