/*
 * combat.h
 *
 * things having to do with combat
 *
 * Ken Stevens, 1995
 */

#ifndef _COMBAT_H_
#define _COMBAT_H_

struct	combat {
	int	type;	/* EF_BAD, EF_SECTOR, EF_SHIP, or EF_PLANE */
	int	set;	/* Has the struct been initialized? */
	int	last;	/* The index of the last element in off array */
	coord	x, y;	/* location of attacking sector/ship/plane */
	natid	own;
	int	eff;
	int	mob;
	int	mobcost;
	int	mil;    /* mil in the sector/ship */
	int	troops; /* mil in the combat */
	int	plague;
	int	sct_type;
	int	shp_uid;
	struct	dchrstr *sct_dcp;
	struct	mchrstr *shp_mcp;
#ifdef SHIPNAMES
	s_char	shp_name[MAXSHPNAMLEN];
#endif
	int	relations_checked;
};

/* Types of combat for use by attack routines */
#define A_DEFEND        0
#define	A_ATTACK	1
#define	A_ASSAULT	2
#define	A_PARA		3
#define A_BOARD		4

extern double att_calcodds();
extern double att_asupport();
extern double att_dsupport();
extern double att_mine_dsupport();
extern double att_combat_eff();
extern double combat_mob;
extern s_char *att_mode[];

#endif /* _COMBAT_H_ */

