#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/subs/border.c,v 2.0 1995/01/25 19:58:54 empire Exp $";
#endif

/*
 * border.c
 *
 * create a border around a map
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "file.h"
#include "xy.h"

border(rp, prefstr, sep)
	struct	range *rp;
	s_char	*prefstr;	/* prefixes each line */
	s_char	*sep;		/* separates the numbers */
{
	register int posi;
	register int n;
	register int x;

#if (WORLD_X/2 > 100)
	if (rp->lx + rp->width > 99 || rp->hx - rp->width < -99) {
		/*
		 * hundreds
		 */
		pr(prefstr);
		for (x=rp->lx, n=0; n < rp->width; n++, x++) {
			if (x >= WORLD_X/2)
				x -= WORLD_X;
			pr(sep);
			if (x < 0 && x > -100) {
				pr("-");
			} else {
				posi = (x < 0 ? -x : x) / 100;
				pr("%d", posi % 10);
			}
		}
		pr("\n");
	}
#endif
	/*
	 * tens
	 */
	pr(prefstr);
	for (x=rp->lx, n=0; n < rp->width; n++, x++) {
		if (x >= WORLD_X/2)
			x -= WORLD_X;
		pr(sep);
		if (x < 0 && x > -10) {
			pr("-");
		} else {
			posi = (x < 0 ? -x : x) / 10;
			pr("%d", posi % 10);
		}
	}
	pr("\n");
	/*
	 * units...
	 */
	pr(prefstr);
	for (x=rp->lx, n=0; n < rp->width; n++, x++) {
		if (x >= WORLD_X/2)
			x -= WORLD_X;
		posi = (x < 0 ? -x : x);
		pr("%s%d", sep, posi % 10);
	}
	pr("\n");
}
