#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/zdon.c,v 2.1 1995/10/11 03:02:33 empire Exp $";
#endif /* not lint */

/*
 * zdon.c
 *
 * Quick update stuff.
 *
 * Syntax:
 *  Normal player:   zdone [Y|N|C]
 *  Deity        :   zdone [country_num [Y|N|C]]
 *
 *  Where:
 *         Y  = Yes, wants an update.
 *         N  = No, change status to not wanting an update.
 *         C  = Check (the default), check how many want an update.
 *
 * Sets/Unsets a nation flag.
 *
 * Only considers NORMAL, active countries.  No Deities or sanctuaries.
 *
 * After the change, send a message to the "tm" for it to check
 * if an update should occur.
 *
 * Doug Hay, Dec 2, 1990.
 */

#include <stdio.h>
#include "misc.h"
#include "player.h"
#ifdef	DEMANDUPDATE
#include "nat.h"
#include "file.h"
#include "deity.h"
#include "lwp.h"

zdon()
{
	extern	struct lwpSem *update_sem;
	natid	whichcnum;
	struct	natstr *natp;
	register s_char *p;

	int	update;
	int	checking;
	int	wantupd;
	int	totpop;
	int	totwant;
	int	dowant;
	s_char	buf[1024];

	whichcnum = player->cnum;
	p = NULL;
	if (player->god) {
		/* Deity syntax "country what" */
		whichcnum = onearg(player->argp[1], "Which country no.? ");
		if ((whichcnum > 0)  && (getnatp(whichcnum)))
			p = getstarg(player->argp[2], "Want update? [Yes|No|Check] ", buf);
	} else {
		p = getstarg(player->argp[1], "Want update? [Yes|No|Check] ", buf);
	}
	if (player->aborted)
		return RET_FAIL;

	if (!p) {
		/* Default response is checking only */
		checking = 1;
	} else {
		checking = 0;
		if (*p == 'n' || *p == 'N') {
			wantupd = 0;
		} else if (*p == 'y' || *p == 'Y') {
			wantupd = 1;
		} else {
			/* Default response is checking only */
			checking = 1;
		}
	}

	if (!checking) {
		if (!(natp = getnatp(whichcnum))) {
			pr("Unable to find country. %d\n", whichcnum);
			pr("Notify the Deity.\n");
			return RET_FAIL;
		}
		if (wantupd) {
			update = natp->nat_update | WUPD_WANT;
			natp->nat_missed = 0;
			pr("You (%d) now want an update.\n",
				whichcnum);
		} else {
			update = natp->nat_update & ~WUPD_WANT;
			pr("You (%d) now DON'T want an update.\n",
				whichcnum);
		}
		natp->nat_update = update;
		putnat(natp);
	}

	dowant = demand_update_want(&totwant, &totpop, whichcnum);
	if (checking) {
		if (dowant) {
			pr("You want an update.\n");
		} else
			pr("You DON'T want an update, yet.\n");
	}

	pr("%d of a total of %d lunatics want an update.\n", totwant, totpop);

	if (!checking && wantupd && demandupdatecheck()) {
		pr("Here goes...\n");
		lwpSignal(update_sem);
	}
	return RET_OK;
}
#endif	/* DEMANDUPDATE */
