#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/decl.c,v 2.5 1995/10/24 04:30:54 empire Exp $";
#endif /* not lint */

/*
 * decl.c
 *
 * declare war, neutrality or alliance.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "nat.h"
#include "news.h"
#include "file.h"
#include "deity.h"
#include "xy.h"
#include "nsc.h"

decl()
{
	struct	natstr	nat, *natp;
	int	rel;
	natid	n, who;
	struct	nstr_item ni;
	s_char *p;
	s_char	buf[1024];

	if (!(p = getstarg(player->argp[1], "alliance, friendly, neutrality, hostility, or war? ", buf)))
		return RET_SYN;
	switch (*p) {
	case 'a':
		rel = ALLIED;
		break;
	case 'f':
		rel = FRIENDLY;
		break;
	case 'n':
		rel = NEUTRAL;
		break;
	case 'h':
		rel = HOSTILE;
		break;
#ifdef SLOW_WAR
	case 'm':
		if (!player->god) return RET_SYN;
		rel = MOBILIZATION;
		break;
	case 's':
		if (!player->god) return RET_SYN;
		rel = SITZKRIEG;
		break;
#endif /* SLOW_WAR */
	case 'w':
		rel = AT_WAR;
		break;
	default:
		pr("That's no declaration!\n");
		return RET_SYN;
	}

	if (!snxtitem(&ni, EF_NATION, player->argp[2]))
		return RET_SYN;
	who = player->cnum;
	if (player->god){
		n = natarg(player->argp[3], "for which country? ");
		if (n < 0)
			who = player->cnum;
		else
			who = n;
	}

	natp = getnatp(who);
	while (nxtitem(&ni, (s_char *) &nat)) {
		if (!(nat.nat_stat & STAT_INUSE))
			continue;
		if (player->cnum == (natid)ni.cur)
			continue;
#ifdef	HIDDEN
		if (!player->god && !getcontact(natp, ni.cur)) {
			pr("You haven't contacted country #%d yet\n");
			continue;
		}
#endif	/* HIDDEN */
		if (getrel(natp, (natid)ni.cur) == rel)
			continue;
		setrel(who, (natid)ni.cur, rel);
	}
	return RET_OK;
}
