#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/boar.c,v 2.8 1995/10/01 22:35:19 empire Exp $";
#endif /* not lint */

/*
 * boar.c
 *
 * board an enemy ship
 *
 * Ken Stevens, 1995
 */

#include <math.h>
#include "misc.h"
#include "player.h"
#include "file.h"
#include "var.h"
#include "sect.h"
#include "path.h"
#include "news.h"
#include "treaty.h"
#include "nat.h"
#include "xy.h"
#include "land.h"
#include "nsc.h"
#include "mission.h"
#include "ship.h"
#include "combat.h"
#include "retreat.h"

boar() {
	struct	combat off[1];	/* boarding ship or sector */
	struct	combat def[1];	/* defending ship */
	int	fort_sup, ship_sup, land_sup, plane_sup;
	struct	qelem olist;	/* boarding units */
	struct	qelem dlist;	/* defending units */
	int	ototal;		/* total boarding strength */
	int	a_engineer = 0;	/* boarder engineers are present */
	int	a_spy = 0;	/* the best boarder scout */
	struct	shpstr	ship;	/* for retreating */
	s_char	*p;
	s_char	buf[1024];

	att_combat_init(def, EF_SHIP);
	/*
	 * Collect input from the boarder
	 */

	/* What are we boarding? */

	if (!(p = getstarg(player->argp[1], "Victim ship #?  ", buf)) ||
	    (def->shp_uid = atoi(p)) < 0)
		return RET_SYN;
	if (att_abort(A_BOARD, 0, def)) {
		pr("Board aborted\n");
		return RET_OK;
	}

	/*
	 * Ask the boarder what he wants to board with
	 */

	if (!(p = getstarg(player->argp[2], "Boarding party from? ", buf)))
		return RET_SYN;
	if (issector(p)) {
		att_combat_init(off, EF_SECTOR);
		if (!sarg_xy(p, &off->x, &off->y))
			return RET_SYN;
	} else {
		att_combat_init(off, EF_SHIP);
		if ((off->shp_uid = atoi(p)) < 0)
			return RET_SYN;
	}
	if (att_abort(A_BOARD, off, def)) {
		pr("Board aborted\n");
		return RET_OK;
	}

	/* Fire at the attacking ship */

	att_approach(off, def);
	if (att_abort(A_BOARD, off, def)) {
		pr("Board aborted\n");
		att_empty_attack(A_BOARD, 0, def);
		return RET_OK;
	}

	/* Show what we're boarding */

	att_show(def);

	/* Ask the player what he wants to board with */

	att_ask_offense(A_BOARD, off, def, &olist, &a_spy, &a_engineer);
	if (att_abort(A_BOARD, off, def)) {
		pr("Board aborted\n");
		att_empty_attack(A_BOARD, 0, def);
		return att_free_lists(&olist, 0);
	}

	/*
	 * Estimate the defense strength and give the player a chance to abort
	 */

	ototal = att_estimate_defense(A_BOARD, off, &olist, def, a_spy);
	if (att_abort(A_BOARD, off, def)) {
		pr("Board aborted\n");
		att_empty_attack(A_BOARD, 0, def);
		return att_free_lists(&olist, 0);
	}

	/*
	 * We have now got all the answers from the boarder.  From this point
	 * forward, we can assume that this battle is the _only_ thing
	 * happening in the game.
	 */

	/* Get the real defense */

	att_get_defense(&olist, def, &dlist, a_spy, ototal);

	/*
	 * Death, carnage, and destruction.
	 */

	if (!(att_fight(A_BOARD,off,&olist,1.0,def,&dlist,1.0))) {
		getship(def->shp_uid, &ship);
		if (ship.shp_rflags & RET_BOARDED) {
			retreat_ship(&ship, 'u');
			putship(def->shp_uid, &ship);
		}
	}

	return RET_OK;
}
