#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/assa.c,v 2.14 1995/10/22 21:19:29 empire Exp $";
#endif /* not lint */

/*
 * assa.c
 *
 * hit the beaches!
 *
 * Ken Stevens, 1995
 */

#include <math.h>
#include "misc.h"
#include "player.h"
#include "file.h"
#include "var.h"
#include "sect.h"
#include "path.h"
#include "news.h"
#include "treaty.h"
#include "nat.h"
#include "xy.h"
#include "land.h"
#include "nsc.h"
#include "mission.h"
#include "ship.h"
#include "combat.h"

assa() {
	struct	combat off[1];	/* assaulting ship */
	struct	combat def[1];	/* defending sector */
	int	fort_sup, ship_sup, land_sup, plane_sup;
	struct	qelem olist;	/* assaulting units */
	struct	qelem dlist;	/* defending units */
	int	ototal;		/* total assaulting strength */
	int	a_engineer = 0;	/* assaulter engineers are present */
	int	a_spy = 0;	/* the best assaulter scout */
	double	osupport = 1.0; /* assault support */
	double	dsupport = 1.0; /* defense support */
	s_char	*p;
	s_char	buf[1024];

	att_combat_init(off, EF_SHIP);
	att_combat_init(def, EF_SECTOR);
	/*
	 * Collect input from the assaulter
	 */

	/* What are we assaulting? */

	if (!(p = getstarg(player->argp[1], "Sector :  ", buf)))
		return RET_SYN;
	if (!sarg_xy(p, &def->x, &def->y))
		return RET_SYN;
	if (att_abort(A_ASSAULT, 0, def))
		return RET_FAIL;

	/*
	 * Ask the assaulter what he wants to assault with
	 */

	if ((off->shp_uid = onearg(player->argp[2], "Assault from ship #")) < 0) {
		pr("You may only assault from one ship!\n");
                return RET_FAIL;
        }
	if (att_abort(A_ASSAULT, off, def)) {
		pr("Assault aborted\n");
		return RET_OK;
	}

	/* Show what we're assaulting */

	att_show(def);

	/* Ask about offensive support */

	att_ask_support(3, &fort_sup, &ship_sup, &land_sup, &plane_sup);
	if (att_abort(A_ASSAULT, off, def)) {
		att_empty_attack(A_ASSAULT, 0, def);
		return RET_OK;
	}

	/* Ask the player what he wants to assault with */

	att_ask_offense(A_ASSAULT, off, def, &olist, &a_spy, &a_engineer);
	if (att_abort(A_ASSAULT, off, def)) {
		pr("Assault aborted\n");
		att_empty_attack(A_ASSAULT, 0, def);
		return att_free_lists(&olist, 0);
	}

	/* If we're assaulting our own sector, end here */
	if (def->own == player->cnum) {
		if (off->troops)
			pr("You reinforce %s with %d troops\n",
			   xyas(def->x, def->y, player->cnum), off->troops);
		if (off->troops || !QEMPTY(&olist))
			att_move_in_off(A_ASSAULT, off, &olist, def);
		return RET_OK;
	}

	/*
	 * Estimate the defense strength and give the player a chance to abort
	 */

	ototal = att_estimate_defense(A_ASSAULT, off, &olist, def, a_spy);
	if (att_abort(A_ASSAULT, off, def)) {
		pr("Assault aborted\n");
		att_empty_attack(A_ASSAULT, 0, def);
		return att_free_lists(&olist, 0);
	}

	/*
	 * We have now got all the answers from the assaulter.  From this point
	 * forward, we can assume that this battle is the _only_ thing
	 * happening in the game.
	 */

	/* Get the real defense */

	att_get_defense(&olist, def, &dlist, a_spy, ototal);

	/* Get assaulter and defender support */

	att_get_support(A_ASSAULT, fort_sup, ship_sup, land_sup, plane_sup,
			&olist, off, &dlist, def, &osupport, &dsupport,
			a_engineer);
	if (att_abort(A_ASSAULT, off, def)) {
		pr("Assault aborted\n");
		att_empty_attack(A_ASSAULT, 0, def);
		return att_free_lists(&olist, &dlist);
	}

	/*
	 * Death, carnage, and destruction.
	 */

	att_fight(A_ASSAULT,off,&olist,osupport,def,&dlist,dsupport);

	return RET_OK;
}
