#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/subs/nxtitem.c,v 2.0 1995/01/25 19:58:54 empire Exp $";
#endif

/*
 * nxtitem.c
 *
 * get next item from list.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "plane.h"
#include "ship.h"
#include "nuke.h"
#include "land.h"
#include "nsc.h"
#include "nat.h"
#include "file.h"
#include "genitem.h"

int
nxtitem(np, ptr)
	struct	nstr_item *np;
	caddr_t	ptr;
{
	struct	genitem *gp;
	int	selected;

	if (np->sel == NS_UNDEF)
		return 0;
	gp = (struct genitem *) ptr;
	do {
		if (np->sel == NS_LIST) {
			np->index++;
			if (np->index >= np->size)
				return 0;
			np->cur = np->list[np->index];
		} else {
			np->cur++;
		}
		if (!np->read(np->type, np->cur, ptr)) {
			/* if read fails, fatal */
			return 0;
		}
		selected = 1;
		switch (np->sel) {
		/*
		 * This one won't work unless you're running in emp_player
		 *
		 */
		case NS_LIST:
			if ((np->flags & EFF_OWNER) && !player->owner)
				selected = 0;
			break;
		case NS_ALL:
			/* XXX maybe combine NS_LIST and NS_ALL later */
			break;
		case NS_DIST:
			if (!xyinrange(gp->x, gp->y, &np->range)) {
				selected = 0;
				break;
			}
			np->curdist = mapdist((int)gp->x, (int)gp->y,
				(int)np->cx, (int)np->cy);
			if (np->curdist > np->dist)
				selected = 0;
			break;
		case NS_AREA:
			if (!xyinrange(gp->x, gp->y, &np->range))
				selected = 0;
			if (gp->x == np->range.hx || gp->y == np->range.hy)
				selected = 0;
			break;
		case NS_XY:
			if (xnorm(gp->x) != np->cx || ynorm(gp->y) != np->cy)
				selected = 0;
			break;
		case NS_GROUP:
			if (np->group != gp->group)
				selected = 0;
			break;
		default:
			logerror("nxtitem: bad selector %d\n", np->sel);
			return 0;
		}
		if (selected && np->ncond) {
			/* nstr_exec is expensive, so we do it last */
			if (!nstr_exec(np->cond, np->ncond, ptr, np->type))
				selected = 0;
		}
	} while (!selected);
	return 1;
}
