#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/common/sectdamage.c,v 2.11 1995/10/24 04:36:22 empire Exp $";
#endif

/*
 * damage.c
 *
 * damage a sector, ship, or plane.
 *
 * Should probably do this in some regular fashion, but
 * we don't yet have a list of fields we can iterate through
 * and find the "damageable" ones.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "land.h"
#include "plane.h"
#include "nuke.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "nat.h"
#include "optlist.h"
#include "damage.h"

void
sect_damage(sp, dam)
	struct sctstr *sp;
	int	dam;
{
	struct	lndstr land;
        struct	plnstr *pp;
        struct  plnstr p;
        int     mines;
	struct natstr *np;
        int     n,old=sp->sct_own;

	np = getnatp(old);

	if (dam <= 0)
		return;
	if (dam > 100)
		dam = 100;

	sp->sct_effic = damage((int)sp->sct_effic, dam);
	sp->sct_mobil = damage((int)sp->sct_mobil, dam);
	sp->sct_nv = vl_damage(dam,
			       sp->sct_vtype, sp->sct_vamt,
			       (int)sp->sct_nv);
	if (opt_EASY_BRIDGES == 0) {
		if (sp->sct_effic < 20 && sp->sct_type == SCT_BHEAD)
			bridgefall(sp);
	} /* else EASY_BRIDGES */
	else {
		if (sp->sct_effic < 20 && sp->sct_type == SCT_BSPAN){
			mpr(sp->sct_own, "Crumble... SCREEEECH!  Splash! Bridge falls at %s!\n",
			   xyas(sp->sct_x, sp->sct_y, sp->sct_own));
			sp->sct_type = SCT_WATER;
			sp->sct_newtype = SCT_WATER;
			sp->sct_own = 0;
			sp->sct_oldown = 0;
			for (n=0; ef_read(EF_LAND, n, (s_char *)&land); n++) {
				if(land.lnd_x != sp->sct_x || land.lnd_y != sp->sct_y)
					continue;
				if (np->nat_flags & NF_BEEP)
					mpr(old, "\07");
				mpr(old, "     AARGH! %s tumbles to its doom!\n",
				    prland(&land));
				land.lnd_own = 0;
				putland(n, &land);
			}
			pp = &p;
			for (n=0; ef_read(EF_PLANE, n, (s_char *)pp); n++) {
				if(pp->pln_x != sp->sct_x || pp->pln_y != sp->sct_y)
					continue;
				if (np->nat_flags & NF_BEEP)
					mpr(old, "\07");
				mpr(old, "     AARGH! %s tumbles to its doom!\n", prplane(pp));
				pp->pln_own = 0;
				putplane(n, pp);
			}
			/*
			 * save only the mines; zero the rest of the
			 * commodities.
			 */
			mines = getvar(V_MINE, (caddr_t)sp, EF_SECTOR);
			sp->sct_nv = 0;
			if (mines > 0)
				(void) putvar(V_MINE, mines, (caddr_t)sp, EF_SECTOR);
			(void) putsect(sp);
		}
	} /* EASY_BRIDGES */
}

void
sectdamage(sp, dam)
	struct sctstr *sp;
	int	dam;
{
	extern	double unit_damage;
	struct	nstr_item ni;
	struct	lndstr land;
	double	real_dam;

	/* Some sectors are harder/easier to kill..   */
	/* Average sector has a dstr of 2, so adjust  */
	/* the damage accordingly. Makes forts a pain */
	
	real_dam = (double)dam * (1.0/((((double)(dchr[sp->sct_type].d_dstr - 2))*(sp->sct_effic/100.0)) + 2.0));
	dam = ldround(real_dam,1);

	sect_damage(sp, PERCENT_DAMAGE(dam));

	/* Damage all the land units in the sector */
	/* Units don't take full damage */
	dam = ldround(DPERCENT_DAMAGE(dam * unit_damage), 1);
	if (dam <= 0)
		return;

	snxtitem_xy(&ni,EF_LAND,sp->sct_x,sp->sct_y);	
	while(nxtitem(&ni,(s_char *)&land)){
		if (!land.lnd_own)
			continue;
		landdamage(&land,dam);
		putland(land.lnd_uid,&land);
	}
}
