#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/mine.c,v 2.6 1995/10/24 04:43:24 empire Exp $";
#endif /* not lint */

/*
 * mine.c
 *
 * lay mines from ships or engineering units
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "ship.h"
#include "land.h"
#include "sect.h"
#include "nat.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"

/*
 * format: mine <SHIPS> <NUMBER MINES>
 */
mine()
{
	struct	shpstr ship;
	struct	sctstr sect;
	struct	mchrstr *mp;
	struct	nstr_item ni;
	int	mines;
	int	shells;
	int	mines_avail;
	int	mines_there;

	if (!snxtitem(&ni, EF_SHIP, player->argp[1]))
		return RET_SYN;
	mines = onearg(player->argp[2], "Drop how many mines from each ship?  ");
	if (mines <= 0)
		return RET_SYN;
	while (nxtitem(&ni, (s_char *)&ship)) {
		if (!player->owner)
			continue;
		mp = &mchr[ship.shp_type];
		if ((mp->m_flags & M_MINE) == 0)
			continue;
		if ((shells = getvar(V_SHELL, (s_char *)&ship, EF_SHIP)) == 0)
			continue;
		mines_avail = min(shells, mines);
		if (getsect(ship.shp_x, ship.shp_y, &sect) == 0 ||
		    (sect.sct_type != SCT_WATER &&
		    sect.sct_type != SCT_BSPAN)) {
			pr("You can't lay mines there!!\n");
			continue;
		}
		mines_there = getvar(V_MINE, (s_char *)&sect, EF_SECTOR);
		putvar(V_SHELL, shells - mines_avail, (s_char *)&ship, EF_SHIP);
		putvar(V_MINE, mines_avail + mines_there, (s_char *)&sect,
			EF_SECTOR);
		putsect(&sect);
		ship.shp_mission = 0;
		putship(ship.shp_uid, &ship);
		pr("Laying %d mines from %s\n", mines_avail, prship(&ship));
		if (mines_avail &&
		    map_set(player->cnum, sect.sct_x, sect.sct_y, 'X', 0))
			writemap(player->cnum);
	}
	return RET_OK;
}

/*
 * format: landmine <UNITS> <NUMBER MINES>
 */
landmine()
{
	struct	lndstr land;
	struct	sctstr sect;
	struct	lchrstr *lp;
	struct	nstr_item ni;
	int	shells;
	int	mines_there;
	int     mines_wanted;
	int     mines_laid;
	int     total_mines_laid;
	s_char	prompt[128];

	if (!snxtitem(&ni, EF_LAND, player->argp[1]))
		return RET_SYN;
	while (nxtitem(&ni, (s_char *)&land)) {
		if (!player->owner)
			continue;
		lp = &lchr[land.lnd_type];
		if (!(lp->l_flags & L_ENGINEER))
			continue;
		if (land.lnd_mobil < 1) {
			pr("%s is out of mobility\n");
			continue;
		}
		resupply_commod(&land,I_SHELL);
		if (!(shells = getvar(V_SHELL, (s_char *)&land, EF_LAND)))
			continue;
		shells = min(shells, land.lnd_mobil);
		if (!getsect(land.lnd_x, land.lnd_y, &sect) ||
		    sect.sct_type == SCT_WATER ||
		    sect.sct_type == SCT_BSPAN) {
			pr("You can't lay mines there!!\n");
			continue;
		}
		mines_there = getvar(V_MINE, (s_char *)&sect, EF_SECTOR);
		if (sect.sct_own == sect.sct_oldown)
			pr("There are currently %d mines in %s\n",
				mines_there,xyas(sect.sct_x,sect.sct_y,player->cnum));
		sprintf(prompt, "Drop how many mines from %s?  ",
			prland(&land));
		mines_wanted = onearg(player->argp[2], prompt);
		if (mines_wanted <= 0)
			continue;
		land.lnd_mission = 0;
		total_mines_laid = 0;
		while (shells > 0 && total_mines_laid < mines_wanted) {
			mines_laid = min(shells, mines_wanted - total_mines_laid);
			putvar(V_SHELL, shells - mines_laid, (s_char *)&land, EF_LAND);
			land.lnd_mobil -= mines_laid;
			putland(land.lnd_uid, &land);
			resupply_commod(&land, I_SHELL);
			putland(land.lnd_uid, &land);
			total_mines_laid += mines_laid;
			shells = getvar(V_SHELL, (s_char *)&land, EF_LAND);
			shells = min(shells, land.lnd_mobil);
		}
		getsect(sect.sct_x, sect.sct_y, &sect);
		putvar(V_MINE, total_mines_laid + mines_there, (s_char *)&sect,
		       EF_SECTOR);
		putsect(&sect);
		if (shells)
			pr("%s laid a total of %d mines in %s\n",
			   prland(&land), total_mines_laid,
			   xyas(sect.sct_x,sect.sct_y,land.lnd_own));
		else
			pr("%s ran out of %s before it could finish the job\nOnly %d mines were laid in %s\n",
			   prland(&land),
			   land.lnd_mobil > 0 ? "supply" : "mobility",
			   total_mines_laid,
			   xyas(sect.sct_x,sect.sct_y,land.lnd_own));
	}
	return RET_OK;
}
