#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/flash.c,v 2.10 1995/10/11 03:02:33 empire Exp $";
#endif

/*
 * flash.c
 *
 * Flash a message to another player
 *
 */

#ifdef Rel4
#include <time.h>
#else
#include <sys/time.h>
#endif /* Rel4 */
#include "misc.h"
#include "player.h"
#include "nat.h"
#include "file.h"

flash()
{
	struct	natstr *us;
	struct	natstr *to;
	s_char	buf[256];
	int	tocn;
	s_char *sp;

	us = getnatp(player->cnum);
	if ((tocn = natarg(player->argp[1], "to which country? ")) < 0)
		return RET_SYN;
	if (!(to = getnatp((natid)tocn))) {
		pr("Bad country number\n");
		return RET_SYN;
	}
	if (!player->god && getrel(to, player->cnum) < FRIENDLY) {
		pr("%s is not friendly with us\n", to->nat_cnam);
		return RET_SYN;
	}
	if (player->argp[2]) {
		for (sp = &player->combuf[0]; *sp && *sp != ' '; ++sp);
		for (++sp; *sp && *sp != ' '; ++sp);
		sprintf(buf, ":%s", sp);
		sendmessage(us, to, buf, 1);
	} else {
		sendmessage(us, to, "...", 1);
		while (getstring("> ", buf)) {
			if (*buf == '.')
				break;
			sendmessage(us, to, buf, 0);
		}
		sendmessage(us, to, "<EOT>", 0);
	}
	return RET_OK;
}

wall()
{
	struct	natstr *us;
	s_char	buf[256];
	s_char *sp;

	us = getnatp(player->cnum);
	if (player->argp[1]) {
		for (sp = &player->combuf[0]; *sp && *sp != ' '; ++sp);
		for (++sp; *sp && *sp != ' '; ++sp);
		sprintf(buf, ":%s", sp);
		sendmessage(us, 0, buf, 1);
	} else {
		sendmessage(us, 0, "...", 1);
		while (getstring("> ", buf)) {
			if (*buf == '.')
				break;
			sendmessage(us, 0, buf, 0);
		}
		sendmessage(us, 0, "<EOT>", 0);
	}
	return RET_OK;
}

int
sendmessage(us, to, message, oneshot)
	struct	natstr *us;
	struct	natstr *to;
	char	*message;
	int     oneshot;
{
	struct	player *other;	
	struct	tm *tm;
	char	*p;
	char	c;
	long	now;
	int	sent = 0;
	struct	natstr *wto;

	for (p = message; c = *p; p++) {
		if (!isprint(c))
			*p = '*';
	}
	if (strlen(message) > 60) {
		s_char c = message[60];
		message[60] = '\0';
		sendmessage(us, to, message, oneshot);
		message[60] = c;
		sendmessage(us, to, &message[60], 0);
		return 0;
	}
	time(&now);
	tm = localtime(&now);
	for (other = player_next(0); other != 0; other = player_next(other)) {
		if (to && other->cnum != to->nat_cnum)
			continue;
		if (!(wto = getnatp(other->cnum)))
			continue;
		if (!to && !player->god && getrel(wto, player->cnum) != ALLIED)
			continue;
		if (!player->god && !(wto->nat_flags & NF_FLASH))
			continue;
		if (player == other)
			continue;
		if (oneshot)
			if (to)
				pr_flash(other, "FLASH from %s (#%d) @ %02d:%02d%s\n",
					 us->nat_cnam, us->nat_cnum, tm->tm_hour,
					 tm->tm_min, message);
			else
				pr_flash(other, "BROADCAST from %s (#%d) @ %02d:%02d%s\n",
					 us->nat_cnam, us->nat_cnum, tm->tm_hour,
					 tm->tm_min, message);

		else 
			pr_flash(other, "%s (#%d): %s\n",
				us->nat_cnam, us->nat_cnum, message);
		player_wakeup(other);
		sent++;
	}
	if (player->god) {
		if (to)
			if (sent)
				pr("Flash sent to %s\n", to->nat_cnam);
			else
				pr("%s is not logged on\n", to->nat_cnam);
		else
			if (sent)
				pr("Broadcast sent to %d players\n", sent);
			else
				pr("No-one is logged in\n");
	}
	return 0;
}
