#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/deli.c,v 2.1 1995/08/05 06:38:40 empire Exp $";
#endif /* not lint */

/*
 * deli.c
 *
 *  Parse <THRESH> <DIR> or <DIR> <THRESH>.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "xy.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "file.h"
#include "path.h"
#include "nsc.h"
#include "nat.h"

int
deli()
{
	struct sctstr sect;
	register int dir, del;
	register struct ichrstr *ich;
	register int thresh = -1;
	int	i_del;
	int	sx, sy;
	struct nstr_sect nstr;
	s_char  buf[1024];
	s_char  prompt[128];
	s_char *p;

	if ((ich = whatitem(player->argp[1], "deliver what? ")) == 0)
		return RET_SYN;
	if (ich->i_vtype == V_CIVIL || ich->i_vtype == V_MILIT) {
		pr("You cannot deliver people!\n");
		return RET_FAIL;
	}
	if (!snxtsct(&nstr, player->argp[2]))
		return RET_SYN;
	i_del = V_DEL(ich-ichr);

	while (nxtsct(&nstr, &sect) > 0) {
		if (!player->owner)
			continue;
		sprintf(prompt, "%s %s 'query' or %s threshold? ",
			xyas(nstr.x, nstr.y, player->cnum),
			dchr[sect.sct_type].d_name,
			ich->i_name);
		if (!(p = getstarg(player->argp[3], prompt, buf)) || !*p)
			return RET_SYN;		
		del = getvar(i_del, (s_char *)&sect, EF_SECTOR);
		if (*p >= '0' && *p <= '9' || *p == '+') {
			thresh = atoi(p) & ~0x7;
			if (*p == '+' || !(p = getstarg(player->argp[4], "Direction? ", buf)) || !*p)
				dir = del & 0x7;
			else if ((dir = chkdir(*p, DIR_STOP, DIR_LAST)) < 0)
				return RET_SYN;
		} else if (*p != 'q')
			return RET_SYN;

		if (thresh >= 0) {
			del = thresh + dir;
			if (!putvar(i_del, del, (s_char *)&sect, EF_SECTOR)) {
				pr("No room for delivery path in %s\n",
				   xyas(sect.sct_x, sect.sct_y, player->cnum));
				return RET_SYS;
			} else
				putsect(&sect);
		}
		if (!del)
			continue;
		dir = del & 0x7;
		sx = diroff[dir][0] + sect.sct_x;
		sy = diroff[dir][1] + sect.sct_y;
		pr("Deliver %s from %s @ %s to %s",
		   ich->i_name,
		   dchr[sect.sct_type].d_name,
		   xyas(sect.sct_x, sect.sct_y, player->cnum),
		   xyas(sx, sy, player->cnum));
		if (!(del & ~0x7))
			pr("\n");
		else
			pr(" (cutoff %d)\n", del & ~0x7);
	}
	return RET_OK;
}
