static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/global/ship.c,v 2.9 1995/10/24 04:45:59 empire Exp $";

/*
 * ship.c
 *
 * marine characteristics -- ship capabilities descriptions
 * 
 * Note, that you should not set the flags M_XLIGHT, M_UNIT, or M_CHOPPER
 * here.  They will be automatically set by init_global() when the server
 * starts if the ship can carry a non-zero amount of those things.
 * Also note that if nplanes > 0 and M_FLY is not set, then M_MSL will
 * automatically be set.
 */

#include "misc.h"
#include "var.h"
#include "ship.h"

struct  mchrstr mchr[]  = {
/*          a   s   v  v   f       E  K   f  f       		    	      */
/*          r   p   i  r   r   g   |  |   u  u       		    	      */
/* l   h    m   e   s  n   n   l   x  V   e  e       		    	      */
/* c   c    o   e   i  g   g   i   p  p   l  l       		    	      */
/* m   m    r   d   b  e   e   m   l  l   c  u  name                tech  Cost*/

{  4,
    { V_CIVIL, V_MILIT, V_FOOD, V_UW },
    {     300,      10,    900,   15 },
25, 15,  10, 10, 15, 2,  0,  0,  0, 0,  0, 0, "fb1 fishing boat 1", 0,  180,
    M_FOOD,  0, 0,
},

{  4,
    { V_CIVIL, V_MILIT, V_FOOD, V_UW },
    {     300,      10,    900,   15 },
25, 15,  10, 25, 15, 2,  0,  0,  0, 0, 20, 1, "fb2 fishing boat 2", 40,  300,
    M_FOOD,  0, 0,
},

{  8,
    { V_CIVIL, V_MILIT, V_SHELL, V_GUN, V_FOOD, V_LCM, V_HCM, V_UW },
    {     600,      50,     300,    50,    900,  1400,   900,  250 },
60, 40,  20, 10, 35, 3,  0,  0,  1, 0,   0, 0, "cs1 cargo ship 1",   0,  300,
    M_SUPPLY,  0, 0,
},

{  8,
    { V_CIVIL, V_MILIT, V_SHELL, V_GUN, V_FOOD, V_LCM, V_HCM, V_UW },
    {     600,      50,     300,    50,    900,  1400,   900,  250 },
60, 40,  20, 25, 35, 3,  0,  0,  1,  0,  30, 1, "cs2 cargo ship 2", 40,  500,
    M_SUPPLY, 0, 2,
},

{  7,
    { V_CIVIL, V_MILIT, V_IRON, V_DUST, V_FOOD, V_UW, V_RAD },
    {      30,       5,    990,    990,    200,   45,   990 },
60, 40,  20, 10, 35, 3,  0,  0,  1,  0,   0, 0, "os1 ore ship 1",    0,  300,
    0,  0, 0,
},

{  7,
    { V_CIVIL, V_MILIT, V_IRON, V_DUST, V_FOOD, V_UW, V_RAD },
    {      30,       5,    990,    990,    200,   45,   990 },
60, 40,  20, 25, 35, 3,  0,  0,  1,  0,  30, 1, "os2 ore ship 2",   40,  500,
    0,  0, 0,
},

{  4,
    { V_CIVIL, V_MILIT, V_FOOD, V_UW },
    {      20,      80,    200, 1200 },
60, 40,  20, 10, 35, 3,  0,  0,  1,  0,   0, 0, "ss  slave ship",    0,  300,
    0,  0, 0,
},

#ifdef TRADESHIPS
{  3,
    { V_CIVIL, V_MILIT, V_FOOD },
    {      50,      50,    100 },
100, 50,  20, 10, 25, 2,  0,  0, 1, 0,   0, 0, "ts1 trade ship 1",  0, 1500,
    M_TRADE,  0, 0,
},

{  3,
    { V_CIVIL, V_MILIT, V_FOOD },
    {      50,      50,    100 },
200, 100,  20, 25, 35, 3,  0,  0, 1, 0,  30, 1, "ts2 trade ship 2", 40, 2500,
    M_TRADE,  0, 0,
},
#endif /* TRADESHIPS */

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      60,      10,     2,     60 },
30, 30,  50, 25, 25, 3,  1,  1,  1,  0,   0, 0, "frigate",           0,  600,
    M_SEMILAND,  0, 2,
},

{  4,
    { V_CIVIL, V_MILIT, V_FOOD, V_OIL },
    {      10,       5,    100,     1 },
25, 15,  10, 25, 15, 2,  0,  0,  0,  0,  20, 1, "oe  oil exploration boat", 40, 800,
    M_OIL,  0, 0,
},

{  5,
    { V_CIVIL, V_MILIT, V_FOOD, V_OIL, V_UW },
    {     500,      80,    300,   990,  500 },
60, 60,  40, 10, 65, 3,  0,  0,  2,  0,   0, 0, "od1 oil derrick 1", 40, 1000,
    M_OIL,  0, 0,
},

{  5,
    { V_CIVIL, V_MILIT, V_FOOD, V_OIL, V_UW },
    {     990,      80,   990,    990,  990 },
60, 60,  30, 15, 65, 3,  0,  0,  2,  0,   0, 0, "od2 oil derrick 2", 100, 1500,
    M_OIL,  0, 0,
},

{  4,
    { V_MILIT, V_GUN, V_SHELL, V_FOOD },
    {       2,     2,      12,      5 },
20, 10,  10, 40, 10, 2,  2,  1,  0,  0,   4, 1, "tb1 torpedo boat", 40, 300,
    M_TORP,  0, 0,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     100,      40,     5,    100 },
30, 40,  50, 30, 30, 5,  8,  3,  1,  0,  40, 1, "lc1 light cruiser 1", 40, 800,
    M_MINE,  0, 2,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     100,      40,     6,    100 },
30, 40,  60, 35, 30, 5, 10,  4,  1,  0,  40, 1, "lc2 light cruiser 2", 100, 900,
    M_MINE,  0, 2,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     120,     100,     6,    200 },
40, 50,  70, 30, 30, 5, 10,  4,  1,  0,  30, 1, "hc1 heavy cruiser 1",     40, 1100,
    0,  0, 4,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     120,     100,     8,    200 },
40, 50,  80, 35, 30, 5, 12,  5,  1,  0,  30, 1, "hc2 heavy cruiser 2",    100, 1200,
    0,  0, 4,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     120,      20,     4,    120 },
50, 50,  60, 20, 35, 3,  1,  2,  1,  0,   0, 0, "bb1 battleship 1",  0,  800,
    M_SEMILAND,  0, 2,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     200,     200,     8,    900 },
50, 70,  90, 25, 35, 6, 12,  5,  1,  0,  50, 2, "bb2 battleship 2", 40, 1500,
    0,  0, 2,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     200,     200,     8,    900 },
50, 70, 100, 30, 35, 6, 14,  6,  1,  0,  50, 2, "bb3 battleship 3", 100, 1600,
    0,  0, 2,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     200,     200,    10,    900 },
50, 70, 120, 35, 35, 6, 16,  7,  1,  0,  50, 2, "bb4 battleship 4", 150, 1800,
    0,  0, 2,
},
{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     180,     100,     8,    400 },
50, 60,  60, 35, 35, 6, 14,  6,  1,  0,  60, 2, "bbc battlecruiser",      100, 1500,
    0,  0, 2,
},

{  6,
    { V_CIVIL, V_MILIT, V_PETROL, V_FOOD, V_OIL, V_UW },
    {      30,       5,      990,    200,   990,   25 },
60, 40,  80, 25, 45, 3,  0,  0,  1,  0,  30, 1, "tk1 tanker",  40,  600,
    M_OILER|M_SUPPLY,  0, 0,
},

{  4, 
    { V_MILIT, V_FOOD, V_SHELL, V_GUN },
    {      10,     90,     100,   1  },
25, 15,  10, 25, 15, 2,  0,  0,  0,  0,  20, 1, "ms  minesweeper", 40,  400,
    M_MINE|M_SWEEP,  0, 0,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      40,      20,     4,     40 },
30, 30,  35, 40, 20, 3,  6,  2,  1,  0,  25, 1, "dd1 destroyer 1", 60,  500,
    M_TORP,  0, 0,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      60,      40,     4,     80 },
30, 30,  45, 35, 20, 4,  8,  2,  1,  0,  30, 1, "dd2 destroyer 2", 100,  600,
    M_MINE|M_DCH|M_SONAR,  0, 1,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {       5,      24,     4,     80 },
20, 30,  30, 25,  5, 2,  2,  2,  0,  0,  15, 1, "sb1 submarine 1",  60,  600,
    M_TORP|M_SUB,  0, 0,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      25,      24,     4,     80 },
30, 30,  35, 30,  4, 3,  4,  3,  0,  0,  25, 1, "sb2 submarine 2", 100,  700,
    M_TORP|M_SUB|M_MINE|M_SONAR,  0, 0,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      25,      36,     5,     80 },
30, 30,  35, 30,  3, 4,  5,  3,  0,  0,  30, 1, "sb3 submarine 3", 160,  700,
    M_TORP|M_SUB|M_MINE|M_SONAR,  0, 0,
},

{  8,
    { V_CIVIL, V_MILIT, V_SHELL, V_GUN, V_FOOD, V_LCM, V_HCM, V_PETROL },
    {       5,      10,     104,    20,    900,   500,   300,      100 },
40, 40,  50, 30,  2, 3,  0,  0,  0,  0,  50, 2, "sbc cargo submarine", 160, 1200,
    M_SUPPLY|M_OILER|M_SUB|M_SONAR,  0, 0,
},

{  5,
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {      50,     100,     4,      150,    180 },
60, 40,  40, 25, 40, 4,  2,  2,  2,  8, 40, 2, "cae escort carrier", 100, 1200,
    M_FLY,  8, 0,
},

{  5,
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     175,     250,     4,      300,    180 },
50, 60,  60, 30, 40, 5,  2,  2,  4, 20, 50, 2, "cal light carrier", 140, 2000,
    M_FLY, 20, 0,
},

{  5,
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     350,     500,     4,      500,    900 },
60, 70,  80, 35, 40, 7,  2,  2, 10, 40, 120, 3, "car aircraft carrier",   160, 3000,
    M_FLY, 40, 0,
},

{  5,
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     350,     999,     4,      999,    900 },
70, 80, 100, 45, 40, 9,  2,  2, 20,  4, 0, 0, "can nuc carrier",  320, 4000,
    M_OILER|M_FLY|M_SUPPLY, 60, 0,
},

{  4,
    { V_MILIT, V_FOOD , V_GUN , V_SHELL },
    {     400,    300 ,     1 ,      10 },
60, 40,  40, 30, 30, 2,  0,  0,  2,  0, 30, 1, "ls  landing ship", 160, 1000,
    M_LAND,  0, 6,
},

{  6,
    { V_CIVIL, V_MILIT, V_PETROL, V_FOOD, V_OIL, V_UW },
    {      30,       5,      990,    200,   990,   25 },
60, 40,  80, 35, 45, 3,  0,  0,  1,  0,  30, 1, "ft  fast tanker", 160,  700,
    M_OILER|M_SUPPLY,  0, 0,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      60,      60,     4,    120 },
40, 30,  50, 35, 30, 5,  2,  2,  4,  0, 40, 1, "af1 asw frigate 1", 220, 800,
    M_DCH|M_SONAR,  0, 0,
},

{  5,
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {      60,      60,     4,       20,    120 },
40, 30,  55, 35, 30, 7,  2,  2,  8,  1, 40, 1, "af2 asw frigate 2", 280, 1000,
    M_TORP|M_SUBT|M_DCH|M_SONAR,  0, 0,
},

{  5,
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {      60,      60,     4,       40,    120 },
40, 30,  55, 40, 30, 9,  2,  2, 10, 2, 50, 1, "af3 asw frigate 3", 310, 1200,
    M_TORP|M_SUBT|M_DCH|M_SONAR, 0, 0,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      25,      60,     6,    500 },
30, 40,  45, 40,  3, 6,  5,  3,  0,  0, 0, 0, "na1 nuc attack sub 1", 260, 1200,
    M_TORP|M_SUB|M_MINE|M_SONAR|M_SUBT,  0, 0,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      25,      90,     6,    500 },
30, 40,  50, 50,  1, 8,  5,  3,  0,  0,   0, 0, "na2 nuc attack sub 2", 310, 1500,
    M_TORP|M_SUB|M_MINE|M_SONAR|M_SUBT,  0, 0,
},

{  5,
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     100,      80,     6,       40,    500 },
40, 40,  60, 35, 35, 6,  8,  3, 10,  2,  80, 2, "ad1 asw destroyer 1", 240, 1500,
    M_DCH|M_SONAR,  0, 0,
},

{  5,
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     100,      80,     6,       80,    500 },
40, 40,  65, 35, 35, 8, 10,  4, 10,  4,  80, 2, "ad2 asw destroyer 2", 290, 1500,
    M_TORP|M_SUBT|M_DCH|M_SONAR,  0, 0,
},

{  4,
    { V_MILIT, V_SHELL, V_FOOD, V_GUN },
    {      25,     200,    500,     1  },
30, 40,  55, 35,  2, 6,  0,  0,  0,  0,   0, 0, "nm1 nuc miss sub 1", 280, 1500,
    M_SUB|M_SONAR, 20, 0,
},

{  4,
    { V_MILIT, V_SHELL, V_FOOD, V_GUN  },
    {      25,     400,    500,     1  },
30, 40,  60, 45,  1, 8,  0,  0,  0,  0,  0, 0, "nm2 nuc miss sub 2", 310, 1500,
    M_SUB|M_SONAR, 40, 0,
},

{  4,
    { V_MILIT, V_SHELL, V_FOOD, V_GUN  },
    {      25,     400,    500,     1  },
30, 40,  65, 50,  0,10,  0,  0,  0,  0,  0, 0, "nm3 nuc miss sub 3", 380, 1800,
    M_SUB|M_SONAR, 50, 0,
},

{  4,
    { V_MILIT, V_SHELL, V_FOOD, V_GUN },
    {      25,     100,    500,     1  },
30, 30,  35, 30,  3, 3,  0,  0,  0,  0, 30, 1, "msb missile sub",   240, 1200,
    M_SUB|M_SONAR, 10, 0,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {       5,     100,     3,    500 },
20, 20,  15, 40, 15, 3,  2,  2,  0,  0,  7, 1, "mb  missile boat", 280,  500,
    0, 10, 0,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {      60,     220,     4,    120 },
40, 30,  50, 35, 30, 5,  2,  2,  2,  0, 30, 1, "mf  missile frigate",    280, 1000,
    0, 20, 0,
},

{  5,
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     120,     500,     6,      160,    200 },
50, 50,  70, 35, 35, 8, 10,  6,  8,  8, 35, 1, "mc  missile cruiser",    290, 1500,
    M_ANTIMISSILE, 40, 0,
},

{  4,
    { V_MILIT, V_SHELL, V_GUN, V_FOOD },
    {     100,     100,    15,    200 },
50, 60,  80, 35, 30, 6,  1, 10,  1,  0, 60, 2, "aac aa cruiser", 150, 1500,
    M_ANTIMISSILE,  0, 4,
},

{  5,
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     200,     400,    25,       40,    900 },
50, 60,  80, 35, 30, 6,  1, 16, 30,  2,  0, 0, "agc aegis cruiser",    260, 4000,
    M_ANTIMISSILE, 32, 0,
},

{  5,
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     200,     400,     8,       40,    900 },
50, 50, 100, 45, 35, 6, 16,  7, 10,  2,  0, 0, "ncr nuc cruiser", 320, 1800,
    M_ANTIMISSILE, 20, 0,
},

{  5,
    { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
    {     200,     120,     6,      160,    500 },
50, 50,  80, 45, 35, 9, 12,  4, 25,  8,  0, 0, "nas nuc asw cruiser", 320, 1800,
    M_TORP|M_SUBT|M_DCH|M_SONAR,  0, 0,
},

{  8,
  { V_CIVIL, V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD, V_LCM, V_HCM },
  {      50,      50,     600,    50,     999,     999,  1500,   900  },
60, 40,  40, 45, 35, 6,  0,  0, 10, 2, 0, 0, "nsp nuc supply ship",  380, 1500,
    0,0,2,
},

{  0, 
    { 0 },
    { 0 },
 0,  0,   0,  0,  0, 0,  0,  0, 0, 0, 0, 0, "",                    0,    0,
    0, 0, 0,
}
};

int	shp_maxno = (sizeof(mchr) / sizeof(struct mchrstr)) - 1;
