#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/gen/signal.c,v 2.1 1995/10/11 02:55:05 empire Exp $";
#endif

/*
 * sig.c
 *
 * block and unblock signals for critical sections.
 *
 * Non-reentrant.
 */

#include "misc.h"
#include <signal.h>

u_int	mask;

blocksig()
{
	mask = sigsetmask(0xffffffff);
}

unblocksig()
{
	sigsetmask(mask);
}

#ifdef sys5
s_char	*sys_siglist[] = {
	"no signal",
	"interrupt",
	"quit",
	"illegal instruction",
	"trace trap",
	"IOT instruction",
	"system crash imminent",
	"floating point exception",
	"kill",
	"bus error",
	"segmentation violation",
	"bad argument to system call",
	"write on a pipe with no one to read it",
	"alarm clock",
	"software termination",
	"user defined signal 1",
	"user defined signal 2",
	"death of a child",
	"power-fail restart",
	"asychronous i/o",
	"PTY read/write",
	"I/O intervention required",
	"monitor mode granted",
	"monitor mode retracted",
	"sound ack",
	"data pending",
};
#else
#if (!defined linux) && (!defined FBSD)
/* linux declares sys_siglist in signal.h */
extern	s_char *sys_siglist[];
#endif /* linux */
#endif /* sys5 */

s_char * signame(sig)
	int	sig;
{
#ifdef POSIX_SIGNALS
	if (sig <= 0 || sig > _sys_nsig)
		return "bad signal";
	return _sys_siglist[sig];
#else /* POSIX_SIGNALS */
	if (sig <= 0 || sig > NSIG)
		return "bad signal";
	return sys_siglist[sig];
#endif /* POSIX_SIGNALS */
}
