#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/common/tfact.c,v 2.0 1995/07/09 21:34:58 empire Exp $";
#endif

/*
 * tfact.c
 *
 * return tech fact given multiplier
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "file.h"

double
tfact(cn, mult)
	natid	cn;
	double	mult;
{
	double	tlev;
	struct	natstr *np;

	np = getnatp(cn);
	tlev = np->nat_level[NAT_TLEV];
	tlev = (50.0 + tlev) / (200.0 + tlev);
	return mult * tlev;
}

double
techfact(level, mult)
	int	level;
	double	mult;
{
	return mult * ((50.0 + level) / (200.0 + level));
}

/*
 * figure out relative difference between two tech levels
 */
double
reltech(level1, level2, mult)
	int	level1;
	int	level2;
	double	mult;
{
	int	diff;

	diff = level1 - level2;
	return (1.0 + ((diff + 50.0) / (level1 + 50.0))) * mult;
}
