#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/work.c,v 2.4 1995/10/24 04:43:24 empire Exp $";
#endif /* not lint */

/*
 * work.c
 *
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "land.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"

work()
{
	int	nunits;
	struct	nstr_item ni;
	struct	sctstr sect;
	struct	lndstr land;
	int	work_amt, eff_amt, w;
	s_char	*p;
	extern	int land_mob_max;
	coord	donex = 0, doney = 1;
	s_char	buf[1024];

	if (!snxtitem(&ni, EF_LAND, player->argp[1]))
		return RET_SYN;
	p = getstarg(player->argp[2], "Amount: ", buf);
	if (p == 0 || *p == 0)
		return RET_SYN;
	work_amt = atoi(p);
	if ((work_amt<0) || (work_amt > land_mob_max)){
		pr("Mobility used must be from 0 to %d\n",land_mob_max);
		return RET_FAIL;
	}
	nunits = 0;
	while (nxtitem(&ni, (s_char *)&land)) {
		if (!player->owner || land.lnd_own == 0)
			continue;
		if (land.lnd_type < 0 || land.lnd_type > lnd_maxno) {
			pr("bad unit type %d (#%d)\n",
				land.lnd_type, ni.cur);
			continue;
		}
		if (!(lchr[land.lnd_type].l_flags & L_ENGINEER))
			continue;
		if (land.lnd_mobil <= 0){
			pr("%s has no mobility!\n",
			   prland(&land));
			continue;
		}
		getsect(land.lnd_x,land.lnd_y,&sect);
		if (sect.sct_effic >= 100
		    && sect.sct_type == sect.sct_newtype) {
			if (sect.sct_x != donex || sect.sct_y != doney)
				pr("%s is %d%% efficient\n",
				   xyas(sect.sct_x, sect.sct_y, player->cnum),
				   sect.sct_effic);
			/* not perfect, but it'll do -KHS */
			donex = sect.sct_x;
			doney = sect.sct_y;
			continue;
		}
		eff_amt= min(land.lnd_mobil,work_amt);
		w = ldround(((double)eff_amt * land.lnd_effic/600.0),1);
		if (w < 1) {
			pr("%s doesn't work enough to change efficiency (try increasing amount)\n",
			   prland(&land));
			continue;
		}
		nunits++;
		eff_amt = min(eff_amt, 6 * buildeff(&sect,w,&player->dolcost));
		land.lnd_mission = 0;
		land.lnd_mobil -= eff_amt;
		pr("%s %s efficiency at %s to %d\n",
		   prland(&land),
		   sect.sct_type == sect.sct_newtype ? "raised" : "lowered",
		   xyas(land.lnd_x,land.lnd_y,player->cnum),
		   (int)sect.sct_effic);
		putland(land.lnd_uid,&land);
		putsect(&sect);
	}
	if (nunits == 0) {
		if (player->argp[1])
			pr("%s: No unit(s)\n", player->argp[1]);
		else
			pr("%s: No unit(s)\n", "");
		return RET_FAIL;
	}else
		pr("%d unit%s\n", nunits, splur(nunits));
	return RET_OK;
}

buildeff(sp,work,money)
struct	sctstr *sp;
int	work;
double	*money;
{
	int	vec[I_MAX+1];
	register int work_cost;
	int	n, hcms, lcms;

	getvec(VT_ITEM, vec, (s_char *)sp, EF_SECTOR);

	work_cost = 0;
	if (sp->sct_type != sp->sct_newtype) {
		/*
		 * Tear down existing sector.
		 * Easier to destroy than to build.
		 */
		work_cost = (sp->sct_effic + 3) / 4;
		if (work_cost > work)
			work_cost = work;
		n = sp->sct_effic - work_cost * 4;
		if (n <= 0) {
			n = 0;
			sp->sct_type = sp->sct_newtype;
		}
		sp->sct_effic = n;
		work -= work_cost;
		*money += work_cost;
	}
	if (sp->sct_type == sp->sct_newtype) {
		work_cost = 100 - sp->sct_effic;
		if (work_cost > work)
			work_cost = work;

		if (dchr[sp->sct_type].d_lcms>0){
			lcms = vec[I_LCM];
			lcms /= dchr[sp->sct_type].d_lcms;
			if (work_cost > lcms)
				work_cost = lcms;
		}
		if (dchr[sp->sct_type].d_hcms>0){
			hcms = vec[I_HCM];
			hcms /= dchr[sp->sct_type].d_hcms;
			if (work_cost > hcms)
				work_cost = hcms;
		}

		sp->sct_effic += work_cost;
		*money += work_cost*dchr[sp->sct_type].d_build;

		if ((dchr[sp->sct_type].d_lcms>0) || 
			(dchr[sp->sct_type].d_hcms>0)){
			vec[I_LCM] -= work_cost * dchr[sp->sct_type].d_lcms;
			vec[I_HCM] -= work_cost * dchr[sp->sct_type].d_hcms;
		}
	}
	putvec(VT_ITEM, vec, (s_char *)sp, EF_SECTOR);
	return work_cost;
}
