#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/upda.c,v 2.3 1995/10/11 03:02:33 empire Exp $";
#endif /* not lint */

/*
 * upda.c
 *
 * Give the time of the next update
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include "misc.h"
#include "player.h"

#ifdef	UPDATESCHED
#include "keyword.h"
#include "wantupd.h"

extern int update_blitz();
/*
 * Tell what the update policy is, and when the next update
 * is likely to be.
 */
upda()
{
	extern int s_p_etu, etu_per_update;
	time_t now, next, delta;
	int pol, wpol;
	int min, absmin;
	s_char *p;
	s_char *ctime();

	if (updates_disabled())
		pr("UPDATES ARE DISABLED!\n");

	(void) time(&now);
	demand_update_info(&pol, &wpol, &min, &absmin);
	switch (pol) {
	case UDP_NORMAL:
		next_update_time(&now, &next, &delta);
		pr("\nUpdates occur at times specified by the ETU rates.\n\n");
		pr("The next update is at %19.19s.\n", ctime(&next));
		break;
	case UDP_TIMES:
		next_update_time(&now, &next, &delta);
		pr("\nUpdates occur at scheduled times.\n\n");
		pr("The next update is at %19.19s.\n", ctime(&next));
		break;
        case UDP_BLITZ:
                next_update_time(&now, &next, &delta);
                pr("\nBlitz Updates occur every %d minutes. \n\n",
			player->blitz_time);
                pr("The next update is at %19.19s.\n",ctime(&next));
		break;
	case UDP_NOREG:
		pr("There are no regularly scheduled updates.\n");
		break;
	default:
		pr("Update policy is inconsistent.\n");
	}
	pr("The current time is   %19.19s.\n\n", ctime(&now));

#ifdef	DEMANDUPDATE
	if (wpol != UDDEM_DISABLE) {
		switch (wpol) {
		case UDDEM_TMCHECK:
			next_update_check_time(&now, &next, &delta);
			pr("Demand updates occur at update CHECK times.\n");
			pr("The next update check is at %19.19s.\n",
			   ctime(&next));
			break;
		case UDDEM_COMSET:
			pr("Demand updates occur right after the demand is set.\n");
			break;
		default:
			pr("Update demand policy is inconsistent.\n");
		}
	}
#endif	/* DEMANDUPDATE */

	if ((pol == UDP_TIMES)
#ifdef	DEMANDUPDATE
				|| (wpol == UDDEM_TMCHECK)
#endif	/* DEMANDUPDATE */
				) {
		if (p=kw_find("update_times"))
			pr("The update schedule is: %s\n", p);
	}
#ifdef	DEMANDUPDATE
	if (wpol != UDDEM_DISABLE) {
		if (p=kw_find("update_demandtimes"))
			pr("Demand updates are allowed during: %s\n", p);
		if (min == 0) {
			pr("Demand updates are disabled by a mininum of 0\n");
		} else {
			if (min < absmin) min = absmin;
			pr("Demand updates require %d country(s) to want one.\n",min);
		}
	}
#endif	/* DEMANDUPDATE */
	if (p=kw_find("days"))
		pr("Game days are: %s\n", p);
	if (p=kw_find("hours"))
		pr("Game hours are: %s\n", p);

	return(0);
}

#else	/* UPDATESCHED */
#include <time.h>

upda()
{
	extern	int s_p_etu;
	extern	int etu_per_update;
	extern	int adj_update;
	time_t	now;
	time_t	upd_time;
	time_t	next_update;
	int	secs_per_update;
	int	delta;

	(void) time(&now);
	upd_time = now + adj_update;
	secs_per_update = etu_per_update * s_p_etu;
	delta = secs_per_update - (upd_time % secs_per_update);
	next_update = now + delta;
	pr("The next update is at %19.19s.\n",ctime(&next_update));
	pr("The current time is %19.19s.\n",ctime(&now));
	return 0;
}
#endif	/* UPDATESCHED */
