/*
 * swap.c
 *
 * Ken Stevens, 1995
 *
 * Swap two sectors on the map.
 */

#include <stdio.h>
#include <ctype.h>
#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "nsc.h"
#include "item.h"
#include "file.h"


/*
 * Syntax: swap <SECT> <SECT>
 */
swaps()
{
	struct	sctstr secta, sectb;
	coord	x,y;
	s_char	buf[1024];
	s_char	*p;

	if (!(p = getstarg(player->argp[1], "First sector : ", buf)) ||
	    !sarg_xy(p, &secta.sct_x, &secta.sct_y) ||
	    !getsect(secta.sct_x, secta.sct_y, &secta))
		return RET_SYN;
	print_res(&secta);
	if (!(p = getstarg(player->argp[2], "Second sector : ", buf)) ||
	    !sarg_xy(p, &sectb.sct_x, &sectb.sct_y) ||
	    !getsect(sectb.sct_x, sectb.sct_y, &sectb))
		return RET_SYN;
	print_res(&sectb);
	if (!confirm("Are you sure these are the two sectors you wish to swap? "))
		return RET_FAIL;
	/* save x and y from secta */
	x = secta.sct_x;
	y = secta.sct_y;
	/* change the location of secta to that of sectb */
	secta.sct_x = sectb.sct_x;
	secta.sct_y = sectb.sct_y;
	secta.sct_dist_x = sectb.sct_x;
	secta.sct_dist_y = sectb.sct_y;
	/* change the location of sectb to where secta was */
	sectb.sct_x = x;
	sectb.sct_y = y;
	sectb.sct_dist_x = x;
	sectb.sct_dist_y = y;
	putsect(&secta);
	putsect(&sectb);
	pr("done\n");
	return RET_OK;
}

print_res(sp)
	struct	sctstr	*sp;
{
	pr("own   sect        eff  min gold fert oil uran\n");

	pr("%3d ", sp->sct_own);

	prxy("%4d,%-4d", sp->sct_x, sp->sct_y, player->cnum);
	pr(" %c", dchr[sp->sct_type].d_mnem);
	if (sp->sct_newtype != sp->sct_type)
		pr("%c", dchr[sp->sct_newtype].d_mnem);
	else
		pr(" ");
	pr("%4d%%", sp->sct_effic);
	pr(" %4d", sp->sct_min);
	pr("%5d", sp->sct_gmin);
	pr("%5d", sp->sct_fertil);
	pr("%4d", sp->sct_oil);
	pr("%5d", sp->sct_uran);
	pr("\n");
}
