#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/surv.c,v 2.0 1995/01/25 19:23:25 empire Exp $";
#endif

/*
 * surv.c
 *
 * show sector survey div 10
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"
#include "nat.h"
#include "map.h"

static	s_char code_char();

/*
 * survey type <sarg> ?cond
 *
 */
surv()
{
	int     nsect;
	struct	nstr_sect nstr;
	int     y;
	long    coding;
	s_char	map[WORLD_Y][MAPWIDTH(1)];
	struct	natstr *np;
	struct	sctstr sect;
	struct	range range;
	s_char	*ptr;
	struct	nscstr cond[NS_NCOND];
	int	ncond;
	int	i;
	s_char	what[64];
	s_char	buf[1024];
	s_char	*str;

	nsect = 0;
	if ((ptr = getstarg(player->argp[1], "commodity or variable? ", buf)) == 0)
		return RET_SYN;
	if (!encode(ptr, &coding, EF_SECTOR))
		return RET_SYN;
	if(player->argp[2] == (s_char *) 0) {
		if ((str = getstring("(sects)? ", buf)) == 0)
			return RET_SYN;
	} else {
		str = player->argp[2];
	}
	if(*str == '*') {
		sprintf(what, "%d:%d,%d:%d",
			-WORLD_X/2, WORLD_X/2-1,
			-WORLD_Y/2, WORLD_Y/2-1);
		if (!snxtsct(&nstr, what))
			return RET_FAIL;
	}
	else
	if (!snxtsct(&nstr, str))
		return RET_SYN;
	ncond = nstr.ncond;
	bcopy((s_char *)nstr.cond, (s_char *)cond, sizeof(struct nscstr) * ncond);
	nstr.ncond = 0;
	np = getnatp(player->cnum);
	xyrelrange(np, &nstr.range, &range);
	border(&range, "     ", "");
	blankfill((s_char *)map, &nstr.range, 1);
	while (nxtsct(&nstr, &sect)) {
		if (!player->owner)
			continue;
		ptr = &map[nstr.dy][nstr.dx];
		if (nstr_exec(cond, ncond, (s_char *)&sect, EF_SECTOR)) {
			++nsect;
			*ptr = 0x80 | code_char(coding, &sect);
		} else {
			*ptr = dchr[sect.sct_type].d_mnem;
		}
	}
	for (y=nstr.range.ly, i=0; i < nstr.range.height; y++, i++) {
		int yval;

		yval = yrel(np, y);
		pr("%4d %s %4d\n", yval, map[i], yval);
		if (y >= WORLD_Y)
			y -= WORLD_Y;
	}
	border(&range, "     ", "");
	if (nsect > 0)
		pr("\n%d sector%s.\n", nsect, splur(nsect));
	return RET_OK;
}

static
s_char
code_char(coding, sp)
	long    coding;
	struct sctstr *sp;
{
	extern struct dchrstr dchr[];
	int     amt;
	int     n;

	if (!(coding & NSC_VAR))
		coding |= NSC_OFF;
	amt = decode(player->cnum, coding, (s_char *) sp, EF_SECTOR);
	n = 0;
	if ((coding & NSC_CMASK) == NSC_VAR) {
		if (amt != 0)
			n = (amt / 100) + 1;
	} else if (amt != 0)
		n = (amt / 10) + 1;
	if (n > 11)
		n = 11;
	if (n < 0)
		n = 0;
	return " 0123456789$"[n];
}
