#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/stre.c,v 2.8 1995/10/24 04:43:24 empire Exp $";
#endif /* not lint */

/*
 * stre.c
 *
 * calculate military strengths of sectors
 *
 * Ken Stevens 1995
 */

#include <math.h>
#include "misc.h"
#include "player.h"
#include "file.h"
#include "var.h"
#include "sect.h"
#include "path.h"
#include "news.h"
#include "treaty.h"
#include "nat.h"
#include "xy.h"
#include "land.h"
#include "nsc.h"
#include "mission.h"
#include "ship.h"
#include "combat.h"

static double units_in_sector();
static stre_hdr();

stre()
{
	struct	sctstr sect;
	int	nsect = 0;
	struct	nstr_sect nstr;
	double  dtotal, r_total, eff;
	struct	combat	def[1];
	int	dummy;
	int	mines;

	if (!snxtsct(&nstr, player->argp[1]))
		return RET_SYN;
	prdate();
	nsect = 0;
	att_combat_init(def, EF_SECTOR);
	while (nxtsct(&nstr, &sect)) {
		if (!player->owner)
			continue;
		if (nsect++ == 0)
			stre_hdr();
		if (player->god)
			pr("%3d ", sect.sct_own);
		prxy("%4d,%-4d", nstr.x, nstr.y, player->cnum);
		pr(" %c", dchr[sect.sct_type].d_mnem);
		pr("%4d%%", sect.sct_effic);
		def->x = nstr.x;
		def->y = nstr.y;
		def->set = 0;
		att_get_combat(def, 1);
		if (def->mil)
			pr("%5d", def->mil);
		else
			pr("%5s", "");
		dtotal = units_in_sector(def);
		if (dtotal > 0)
			pr("%7d", (int)dtotal);
		else
			pr("%7s", "");

		r_total = att_reacting_units(def, 0, 0, &dummy, 9999999);
		def->own = 0;
		eff = att_combat_eff(def);
		if (sect.sct_own == sect.sct_oldown) {
			mines = getvar(V_MINE, (s_char *)&sect, EF_SECTOR);
			if (mines > 0)
				pr("%7d", mines);
			else
				pr("%7s", "");
			eff *= (1.0 + min(mines,20) * 0.02);
		} else {
			pr("%7s", "?");
		}
		pr("%6.2f", eff);
		pr("%9d", (int)((dtotal + def->mil) * eff));
		if (r_total > 0)
			pr(" %9d", (int)(r_total * eff));
		else
			pr(" %9s", "");
		pr("%9d\n", (int)((dtotal + def->mil + r_total) * eff));
	}
	if (!nsect) {
		if (player->argp[1])
			pr("%s: No sector(s)\n", player->argp[1]);
		else
			pr("%s: No sector(s)\n", "");
		return RET_FAIL;
	} else
		pr("%d sector%s\n", nsect, splur(nsect));
	return 0;
}

static double
units_in_sector(def)
	struct	combat	*def;
{
	double d_unit;
	double dtotal = 0.0;
	struct	nstr_item ni;
	struct	lndstr land;

	snxtitem_xy(&ni,EF_LAND,def->x, def->y);
	while(nxtitem(&ni,(s_char *)&land)){
		if (land.lnd_own == 0)
			continue;
		if (land.lnd_own != def->own)
			continue;
		if (land.lnd_ship >= 0)
			continue;
		d_unit = defense_val(&land);
		if (!has_supply(&land))
			d_unit /= 2.0;
		dtotal += d_unit;
	}
	return dtotal;
}

static
stre_hdr()
{
	if (player->god)
		pr("    ");
	pr("DEFENSE STRENGTH               land  sect   sector  reacting    total\n");
	if (player->god)
		pr("own ");
	pr("  sect       eff  mil  units  mines  mult  defense     units  defense\n");
}

