#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/sate.c,v 2.1 1995/09/26 18:41:00 empire Exp $";
#endif

/*
 * sate.c
 *
 * do satellite maps/reports
 *
 * Edward M. Rynes Esq, 1988
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "plane.h"
#include "sect.h"
#include "nsc.h"
#include "file.h"
#include "nat.h"

sate()
{
	extern	int plane_mob_max;
	double	tech;
	int	pln_uid;
	struct	plnstr plane;
	int	type = EF_BAD;

	if (!player->argp[1] ||
	    !*player->argp[1] ||
	    !isdigit(*player->argp[1]) ||
	    (pln_uid = atoi(player->argp[1])) < 0)
		return RET_SYN;

	if (!getplane(pln_uid, &plane)) {
		pr("No such plane\n");
		return RET_FAIL;
	}

	if (plane.pln_own != player->cnum) {
		pr("You don't own plane #%d\n", pln_uid);
		return RET_FAIL;
	}
		
	if (!(plane.pln_flags & PLN_LAUNCHED)) {
		pr("%s isn't in orbit\n",
		   prplane(&plane));
		return RET_FAIL;
	}
	if (plane.pln_mobil < plane_mob_max) {
		pr("%s doesn't have enough mobility (needs %d)\n",
		   prplane(&plane),
		   plane_mob_max);
		return RET_FAIL;
	}
	if (player->argp[2]) {
		switch (*player->argp[2]) {
		case 'l':
			type = EF_LAND; break;
		case 's':
			if (*(player->argp[2] + 1) == 'e')
				type = EF_SECTOR;
			else
				type = EF_SHIP;
			break;
		default:
			return RET_SYN;
		}
	}
		
	if (plchr[plane.pln_type].pl_flags & P_S)
		pr("Satellite Spy Report:\n");
	else
		pr("Satellite Map Report:\n");
	pr("%s at ", prplane(&plane));
	tech = techfact(plane.pln_tech, 20.0);
	satmap(plane.pln_x, plane.pln_y, plane.pln_effic,
	       (int)tech, plchr[plane.pln_type].pl_flags, type);

	return RET_OK;
}
