#include <stdio.h>
#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/rout.c,v 2.0 1995/01/25 19:23:25 empire Exp $";
#endif

/*
 * rout.c
 *
 * Show empire delivery routes and (formerly) contracts
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "nat.h"
#include "nsc.h"
#include "sect.h"
#include "item.h"
#include "path.h"
#include "file.h"
#include "map.h"

int
rout()
{
	struct	ichrstr	*ip;
	struct	nstr_sect ns;
	struct	natstr	*natp;
	struct	sctstr	sect;
	struct	nscstr	cond[NS_NCOND];
	int	ncond;
	s_char	*p, buf[MAPWIDTH(3)+10];
	s_char	map[WORLD_Y][MAPWIDTH(3)];
	struct	range	relrange;
	int	row;
	int	y;
	int	ry;
	int     i_del;
	int	dir;
	s_char	what[64];
	s_char	*str;
	s_char	buf1[1024];

	if ((ip = whatitem(player->argp[1], "What item? ")) == 0)
		return RET_SYN;
	i_del = V_DEL(ip-ichr);
	if(player->argp[2] == (s_char *) 0) {
		if ((str = getstring("(sects)? ", buf1)) == 0)
			return RET_SYN;
	} else {
		str = player->argp[2];
	}
	if(*str == '*') {
		sprintf(what, "%d:%d,%d:%d",
			-WORLD_X/2, WORLD_X/2-1,
			-WORLD_Y/2, WORLD_Y/2-1);
		if (!snxtsct(&ns, what))
			return RET_FAIL;
	} else if (!snxtsct(&ns, str))
		return RET_FAIL;
	ncond = ns.ncond;
	bcopy((s_char *)ns.cond, (s_char *)cond, sizeof(struct nscstr) * ncond);
	ns.ncond = 0;

	natp = getnatp(player->cnum);
	xyrelrange(natp, &ns.range, &relrange);
	bzero(map,sizeof(map));
	blankfill((s_char *)map, &ns.range, 3);
	border(&relrange, "     ", " ");

	while (nxtsct(&ns, &sect)) {
		if (!player->owner)
			continue;
		p = &map[ns.dy][ns.dx*2];
		if ((dir = getvar(i_del, (s_char *)&sect, EF_SECTOR) & 0x7) &&
		    nstr_exec(cond, ncond, (s_char *)&sect, EF_SECTOR))
			bcopy(routech[dir][0], p, 3);
		p[1] = dchr[sect.sct_type].d_mnem;
	}
	for (row = 0, y = ns.range.ly; row < ns.range.height; y++,row++) {
		ry = yrel(natp, y);
		bzero(buf,sizeof(buf));
		sprintf(buf,"%4d ",ry);
		bcopy(map[row],buf+5,ns.range.width*2+1);
		sprintf(buf+5+ns.range.width*2+1," %-4d\n",ry);
		pr("%s", buf);
		if (y >= WORLD_Y)
			y -= WORLD_Y;
	}
	border(&relrange, "     ", " ");
	return RET_OK;
}
