#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/orig.c,v 2.0 1995/01/25 19:23:25 empire Exp $";
#endif

/*
 * orig.c
 *
 * move your origin
 *
 * Shelley Louie, 1988
 */

#include "misc.h"
#include "player.h"
#include "sect.h"
#include "xy.h"
#include "nat.h"
#include "file.h"
#include "edb.h"

orig()
{
	struct	sctstr sect;
	s_char	*p;
	coord	x, y;
	s_char	buf[1024];
	struct	natstr *np;

	if ((p = getstarg(player->argp[1], "New origin location : ", buf)) == 0) {
		return RET_SYN;
	}
	if (!sarg_xy(p, &x, &y))
		return RET_SYN;
	if (!getsect(x, y, &sect))
		return RET_SYN;
	pr("Origin at %s (old system) is now at 0,0 (new system).\n",
	       xyas(sect.sct_x, sect.sct_y, player->cnum));
	np = getnatp(player->cnum);
	np->nat_xorg = sect.sct_x;
	np->nat_yorg = sect.sct_y;
	putnat(np);
	prsync(np->nat_cnum, np, EDV_ALL);
	return RET_OK;
}
