#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/nati.c,v 2.2 1995/08/16 05:50:05 empire Exp $";
#endif /* not lint */

/*
 * nati.c
 *
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "nat.h"
#include "sect.h"
#include "file.h"
#include "xy.h"
#include "optlist.h"
#include "edb.h"

int
nati()
{
	extern	int etu_per_update;
	extern	double obrate, uwbrate;
	struct	natstr *natp;
	struct	sctstr sect;
	float	hap;
	int	mil;
	int	civ;
	int	poplimit, safepop, uwpop;
	double pfac;

	if ((natp = getnatp(player->cnum)) == 0) {
		pr("Bad country number %d\n", player->cnum);
		return RET_SYN;
	}
	pr("\n(#%i) %s Nation Report\t", player->cnum, cname(player->cnum));
	prdate();
	pr("Nation status is %s", natstate(natp));
	pr("     Bureaucratic Time Units: %d\n", natp->nat_btu);
	if (natp->nat_stat & STAT_INUSE) {
		getsect(natp->nat_xcap, natp->nat_ycap, &sect);
		if (!player->owner || (sect.sct_type != SCT_CAPIT &&
		    sect.sct_type != SCT_MOUNT &&
		    sect.sct_type != SCT_SANCT))
			pr("No capital. (was at %s)\n",
				xyas(sect.sct_x, sect.sct_y, player->cnum));
		else {
			civ = getvar(V_CIVIL, (s_char *)&sect, EF_SECTOR);
			mil = getvar(V_MILIT, (s_char *)&sect, EF_SECTOR);
			pr("%d%% eff %s at %s has %d civilian%s & %d military\n",
			       sect.sct_effic,
			       (sect.sct_type == SCT_CAPIT ? "capital" : "mountain capital"),
			       xyas(sect.sct_x, sect.sct_y, player->cnum), civ,
			       splur(civ), mil);
		}
	}
	pr(" The treasury has $%.2f", (double) natp->nat_money);
	pr("     Military reserves: %d\n", natp->nat_reserve);
	pr("Education..........%6.2f       Happiness.......%6.2f\n",
		(double) natp->nat_level[NAT_ELEV],
		(double) natp->nat_level[NAT_HLEV]);
	pr("Technology.........%6.2f       Research........%6.2f\n",
		(double) natp->nat_level[NAT_TLEV],
		(double) natp->nat_level[NAT_RLEV]);
	pr("Technology factor :%6.2f%%", tfact(player->cnum, 100.));

	if (opt_NO_PLAGUE) 
		pfac = 0.0;
	else 
		pfac = ((double) natp->nat_level[NAT_TLEV] + 100.) /
			((double) natp->nat_level[NAT_RLEV] + 100.);
	pr("     Plague factor : %6.2f%%\n", pfac);
	pr("\n");

	poplimit = 999;
	if (opt_RES_POP)
		poplimit = max_pop(natp->nat_level[NAT_RLEV], 0);
	pr("Max population : %d\n", poplimit);

	safepop = (int)((double)poplimit/(1.0 + obrate*(double)etu_per_update));
	uwpop = (int)((double)poplimit/(1.0 + uwbrate*(double)etu_per_update));
	safepop++;
	if (((double)safepop*(1.0 + obrate*(double)etu_per_update)) > ((double)poplimit+0.0000001))
		safepop--;
	uwpop++;
	if (((double)uwpop*(1.0 + uwbrate*(double)etu_per_update)) > ((double)poplimit+0.0000001))
		uwpop--;

	pr("Max safe population for civs/uws: %d/%d\n",safepop,uwpop);

	hap = ((natp->nat_level[NAT_TLEV]-40)/40.0 +
			natp->nat_level[NAT_ELEV]/3.0);

	if (hap > 0.0)
		pr("Happiness needed is %f\n",hap);
	else
		pr("No happiness needed\n");

	prsync(natp->nat_cnum, natp, EDV_ALL);

	return RET_OK;
}
