#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/coll.c,v 2.2 1995/10/24 04:43:24 empire Exp $";
#endif /* not lint */

/*
 * coll.c
 *
 * collect on loan
 *
 * from PSL Empire, 1985
 */

#include <math.h>
#include "misc.h"
#include "player.h"
#include "var.h"
#include "file.h"
#include "sect.h"
#include "item.h"
#include "loan.h"
#include "news.h"
#include "nat.h"
#include "xy.h"

coll()
{
	register int arg;
	register int i;
	register int val;
	time_t	now;
	s_char	*p;
	struct	lonstr loan;
	struct	sctstr sect;
	coord	x, y;
	long	due;
	long	last;
	long	rdur;
	long	xdur;
	double	rate;
	double	owed;
	double	pay;
	s_char	buf[1024];

	if ((arg = onearg(player->argp[1], "Collect on loan #")) < 0)
		return RET_SYN;
	if (!getloan(arg, &loan) || loan.l_loner != player->cnum || loan.l_ldur == 0) {
		pr("You aren't owed anything on that loan...\n");
		return RET_FAIL;
	}
	(void) time(&now);
	due = loan.l_duedate;
	if (now <= due && loan.l_status == LS_SIGNED) {
		pr("There has been no default on loan %d\n", arg);
		return RET_FAIL;
	}
	last = loan.l_lastpay;
	if (last < due && due < now) {
		rdur = due - last;
		xdur = now - due;
	} else if (due < last) {
		rdur = 0;
		xdur = now - last;
	}
	rate = loan.l_irate / (loan.l_ldur * 8.64e6);

/* changed following to avoid overflow 3/27/89 bailey@math-cs.kent.edu
	owed = ((rdur * rate) + (xdur * rate * 2.0) + 1.0) * loan.l_amtdue;
   Begin overflow fix */
	owed = ((rdur * rate) + (xdur * rate * 2.0) + 1.0);
	if (((1 << 30) / owed) < loan.l_amtdue)
		owed = (1 << 30);
	else
		owed *= loan.l_amtdue;
/* End overflow fix */
	pr("You are owed $%.2f on that loan.\n", owed);
	if (!(p = getstarg(player->argp[2], "What sector do you wish to confiscate? ", buf)))
		return RET_SYN;
	if (!sarg_xy(p, &x, &y) || !getsect(x, y, &sect))
		return RET_SYN;
	if (!neigh(x, y, player->cnum)) {
		pr("You are not adjacent to %s\n", xyas(x, y, player->cnum));
		return RET_FAIL;
	}
	if (sect.sct_own != loan.l_lonee) {
		pr("%s is not owned by %s.\n",
			xyas(x, y, player->cnum),  cname(loan.l_lonee));
		return RET_FAIL;
	}
	pay = dchr[sect.sct_type].d_value * ((float)sect.sct_effic + 100.0);
	for (i = 0; ichr[i].i_name; i++) {
		if (ichr[i].i_value == 0 || ichr[i].i_vtype == 0)
			continue;
		val = getvar(ichr[i].i_vtype, (s_char *)&sect, EF_SECTOR);
		pay += val * ichr[i].i_value;
	}
	pr("That sector (and its contents) is valued at $%.2f\n", pay);
	if (pay > owed * 1.2) {
		pr("That is more than is owed!\n");
		return RET_FAIL;
	}
	if (sect.sct_type == SCT_CAPIT || sect.sct_type == SCT_MOUNT)
		caploss(&sect, sect.sct_own, "that was %s's capital!\n");
	putvar(V_MILIT, 0, (s_char *)&sect, EF_SECTOR);
	(void) takeover(&sect, player->cnum);
	putsect(&sect);
	nreport(player->cnum, N_SEIZE_SECT, loan.l_lonee, 1);
	if (pay >= owed) {
		loan.l_ldur = 0;
		nreport(loan.l_lonee, N_REPAY_LOAN, player->cnum, 1);
		wu(0, loan.l_lonee,
			"%s seized %s to satisfy loan #%d\n",
				cname(player->cnum),
				xyas(sect.sct_x, sect.sct_y, loan.l_lonee),
				arg);
		pr("That loan is now considered repaid.\n");
	} else {
		(void) time(&loan.l_lastpay);
		owed -= pay;
		loan.l_amtdue = (long) owed;
		pay += loan.l_amtpaid;
		loan.l_amtpaid = pay;
		wu(0, loan.l_lonee, 
			"%s seized %s in partial payment of loan %d.\n",
			cname(player->cnum),
			xyas(sect.sct_x, sect.sct_y, loan.l_lonee), arg);
		pr("You are still owed $%.2f on loan %d.\n", owed, arg);
	}
	putloan(arg, &loan);
	return RET_OK;
}
