#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/arm.c,v 2.5 1995/10/01 21:55:12 empire Exp $";
#endif /* not lint */

/*
 * arm.c
 *
 * arm planes (missiles) with nuclear devices
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "nuke.h"
#include "plane.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "nat.h"

int
arm()
{
	struct	nchrstr *ncp;
	struct	plchrstr *plc;
	struct	plnstr pl;
	struct	nukstr nuke;
	s_char	*p;
	int	i;
	int	pno;
	int	nuketype;
	int	nukenum;
	int	len;
	struct	nstr_item ni;
	s_char	buf[1024];
	int	disarm = **player->argp=='d';
	s_char	*prompt = disarm?"Disarm plane: ":"Arm plane: ";

	if (!(p = getstarg(player->argp[1], prompt, buf)) || !*p)
		return RET_SYN;
	pno = atoi(p);
	if (pno < 0 || !getplane(pno, &pl) || pl.pln_own != player->cnum)
		return RET_FAIL;
	plc = &plchr[pl.pln_type];
	if ((plc->pl_flags & (P_O | P_M)) == (P_O | P_M)) {
		pr("A %s cannot carry nuclear devices!\n",plc->pl_name);
		return RET_FAIL;
	}
	if (pl.pln_nuketype == -1) {
		if (disarm) {
			pr("%s is not carrying any nuclear devices\n",
			   prplane(&pl));
			return RET_FAIL;
		}
		if ((p = getstarg(player->argp[2], "Device type: ", buf)) == 0)
			return RET_SYN;
		len = strlen(p);
		for (i=0, ncp = nchr; i<N_MAXNUKE; i++, ncp++) {
			if (strncmp(ncp->n_name, p, len) == 0)
				break;
		}
		if (i >= N_MAXNUKE) {
			pr("No such nuke type!\n");
			return RET_SYN;
		}
		nuketype = i;
		nukenum = -1;
		snxtitem_all(&ni, EF_NUKE);
		while (nxtitem(&ni, (s_char *)&nuke)) {
			if (nuke.nuk_own != player->cnum)
				continue;
			if (nuke.nuk_x != pl.pln_x || nuke.nuk_y != pl.pln_y)
				continue;
			nukenum = ni.cur;
			break;
		}
		if (nukenum < 0) {
			pr("You don't own any nukes in that sector.\n");
			return RET_FAIL;
		}
		if (nuke.nuk_types[nuketype] == 0) {
			pr("No nukes of that type in that sector.\n");
			return RET_FAIL;
		}
		if (plc->pl_load < ncp->n_weight) {
			pr("A %s cannot carry %s devices!\n", plc->pl_name,ncp->n_name);
			return RET_FAIL;
		}
		pl.pln_nuketype = nuketype;
		nuk_delete(&nuke, nuketype, 1);
	}
	if (disarm) {
		pr("%s warhead removed from %s and added to %s\n",
		   nchr[pl.pln_nuketype].n_name,
		   prplane(&pl),
		   xyas(pl.pln_x, pl.pln_y, player->cnum));
		nuk_add(pl.pln_x, pl.pln_y, pl.pln_nuketype, 1);
		pl.pln_nuketype = -1;
		pl.pln_flags &= ~PLN_AIRBURST;
	} else {
		pr("%s armed with a %s warhead.\n", prplane(&pl),
		   nchr[pl.pln_nuketype].n_name);
		if ((p = getstarg(player->argp[3], "Airburst [n]? ", buf)) &&
		    (*p == 'y' || *p == 'Y'))
			pl.pln_flags |= PLN_AIRBURST;
		else
			pl.pln_flags &= ~PLN_AIRBURST;
	
		pr("Warhead on %s is programmed to %s\n",
		   prplane(&pl),
		   pl.pln_flags & PLN_AIRBURST?
		   "airburst":"groundburst");
	}
		
	putplane(pno, &pl);
	return RET_OK;
}
