/*
 * file.h
 *
 * Describes Empire files and their contents.
 *
 * $Revision: 2.3 $ $Date: 1995/09/13 05:52:38 $
 */

#ifndef _FILE_H_
#define _FILE_H_

struct empfile {
	s_char *name;		/* file name (e.g., "treaty") */
	s_char *file;		/* file path */
	int flags;		/* misc stuff */
	int mode;		/* O_flags */
	int size;		/* size of object */
	int (*init)();          /* call this when object is created */
	int (*postread)();	/* specific massage routines for items */
	int (*prewrite)();
	int varoffs[3];		/* struct offs for nv, vtype, vamt */
	int maxvars;		/* max # vars for type */
	int fd;			/* file descriptor */
	int baseid;		/* starting item in cache */
	int cids;		/* # ids in cache */
	int csize;		/* size of cache in bytes */
	caddr_t cache;		/* pointer to cache */
	int fids;		/* # of ids in file */
	struct castr *cadef;	/* ca defs selection list */
};

#define EFF_COM		bit(0)	/* item has commodities attached */
#define EFF_XY		bit(1)	/* has location */
#define EFF_MEM		bit(2)	/* stored entirely in-memory */
#define EFF_OWNER	bit(3)	/* has concept of owner */
#define EFF_GROUP	bit(4)	/* has concept of group */

#define EF_BAD		-1	/* illegal file type */
#define EF_SECTOR	0
#define EF_SHIP		1
#define EF_PLANE	2
#define	EF_LAND		3
#define EF_NUKE		4
#define EF_NEWS		5
#define EF_TREATY	6
#define EF_TRADE	7
#define EF_POWER	8
#define EF_NATION	9
#define EF_LOAN		10
#define	EF_MAP		11
#define EF_BMAP		12
#define EF_MAX		13

struct fileinit {
	int (*init)();
	int (*postread)();
	int (*prewrite)();
	struct castr *cadef;
};

extern	struct castr *ef_cadef();
extern	int ef_read();
extern	int ef_nbread();
extern	s_char *ef_ptr();
extern	s_char *ef_nameof();
extern	time_t ef_mtime();
extern	struct empfile empfile[];

#endif /* _FILE_H_ */
