#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/subs/RCS/cnumb.c,v 1.3 89/09/10 19:11:30 mr-frog Exp $";
#endif

/*
 * cnumb.c
 *
 * return country # given country name or
 * unambiguous country name match
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "nat.h"
#include "file.h"

int
cnumb(cntry)
	s_char	*cntry;
{
	register s_char *ncp;
	register s_char *cp;
	register struct natstr *natp;
	int	bcount;
	natid	best;
	natid	cn;

	bcount = 0;
	for (cn = 0; cn < MAXNOC; cn++) {
		if ((natp = getnatp(cn)) == 0)
			break;
		ncp = natp->nat_cnam;
		for (cp=cntry; *cp == *ncp; cp++, ncp++) {
			if (*cp == 0)
				return cn;
		}
		if (cp > cntry && *cp == 0) {
			best = cn;
			bcount++;
		}
	}
	/* can only have 1 match or not successful */
	return bcount == 1 ? (int) best : -1;
}
