static char *RCSid = "$Header: empmod.c,v 1.1 89/12/14 13:26:37 jay Exp $";

/*
 * empmod.c
 *
 * Command/function mapping for empire.  Named empmod for historical
 * reasons -- empire used to be broken into seven modules
 * on the venerable pdp 11 so it could fit in 64k I/D space.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "com.h"
#include "nat.h"
#include "tm.h"
#include "file.h"

extern	int  add();
extern	int assa();
extern	int atta();
extern	int boar();
extern	int bomb();
extern	int buil();
extern	int chan();
extern	int coas();
extern	int coll();
extern	int comm();
extern	int cons();
extern	int coun();
extern	int decl();
extern	int deli();
extern	int show();
extern	int desi();
extern	int diss();
extern	int drop();
extern	int enli();
extern	int fire();
extern	int flee();
extern	int  fly();
extern	int force();
extern	int info();
extern	int ledg();
extern	int load();
extern	int look();
extern	int  map();
extern	int mine();
extern  int move();
extern	int nati();
extern	int navi();
extern  int head(), news();
extern	int nuke();
extern	int offe();
extern	int offs();
extern	int para();
extern	int path();
#ifdef TRADESHIPS
extern	int payo();
#endif /* TRADESHIPS */
extern	int powe();
extern	int rada();
extern	int  rea();
extern	int real();
extern	int reco();
extern	int repa();
extern	int rout();
extern	int sona();

extern	int  spy();
extern	int tele();
extern	int tend();
extern	int torp();
extern	int trad();
extern  int tran();
extern	int trea();
extern	int turn();
extern	int vers();
/*
 * new commands
 */
extern	int buy();
extern	int mult();
extern	int repo();
extern	int fina();
extern	int laun();
extern	int new();
extern	int shoo();
extern	int thre();
extern	int dist();
extern	int sct();
extern	int plan();
extern	int arm();
extern	int hard();
extern	int upgr();
extern	int surv();
extern	int capi();
extern	int orig();
extern	int mark();
extern	int conv();
extern  int leve();
extern	int cuto();
extern	int prod();
extern	int  wai();
extern	int carg();
extern	int terr();
extern	int sate();
extern	int give();
extern	int edit();
extern	int wipe();
extern	int dump();
extern	int expl();
extern	int reso();
extern	int scra();
extern	int rela();
extern	int brea();
extern	int upda();
extern	int hidd();
extern	int bdes();
extern	int bmap();
extern	int orde();
extern	int qorde();
extern  int sorde(); 
extern	int reje();
extern	int acce();
extern	int scut();
extern	int grin();
#ifdef	SAIL
extern	int sail();	/* Forsman's hacks */
extern	int foll();	/**/
extern	int mobq();	/**/
#endif	SAIL
#ifdef	SHIPNAMES
extern	int name();
#endif	SHIPNAMES
extern	int range();
#ifdef	DEMANDUPDATE
extern	int zdon();
#endif	/* DEMANDUPDATE */
#ifdef	FUEL
extern	int fuel();
#endif	/* FUEL */
extern	int multifire();
extern	int retr();
extern	int budg();
extern	int wire();
extern	int stop();
extern	int start();

extern	int land();
extern	int supp();
extern	int lcarg();
extern	int lload();
extern	int army();
extern	int lrange();
extern	int morale();
extern	int lretr();
extern	int landmine();
extern	int fort();
extern	int march();
extern	int llook();
extern	int mission();
extern	int lrada();
extern	int work();
extern	int ltend();
extern	int cede();
extern	int best();
extern	int newe();
extern	int starve();

extern	int setres();
extern	int setsector();
extern	int mail();

extern	int disa();
extern	int enab();

/*
 * Undeclared functions
 */
extern	int quit();
extern	int cens();
extern	int demo();
extern	int sell();
extern	int shi();
extern	int wing();
extern	int execute();
extern	int explain();
extern	int  set();

struct  comstr  player_coms[]  = {
/* command form                       cost	addr  permit */
"accept  [as-COUNTRY]",			0,	acce,	NORM,
"add <NAT> <NAME> <REP> <STATUS> <c|w|i>",0,	add,	GOD,
"announce {message}",                   0,	tele,	NORM,
"arm <PLANE> <NUKETYPE> <NUMBER>",      3,	arm,	NORM+MONEY+CAP,
"army <ARMY> <UNITS>",                  0,	army,	NORM,
"assault <to-SECT> <from-SHIP> <NUMBER> [<forts?> <ships?> <arty?> <planes?>]",3,assa,NORM+MONEY+CAP,
"attack <SECT> [<forts?> <ships?> <arty?> <planes?>]",3,atta,NORM+MONEY+CAP,
"bdes <SECTS> <type>",                  0,	bdes,	NORM,
"bestpath <SECTS> <SECTS>",             0,	best,	NORM,
"bestdistpath <SECTS> <SECTS>",         0,	best,	NORM,
"bmap <SECTS>",                         0,	bmap,	NORM,
"board <to-SHIP> <from-SHIP>",          3,	boar,	NORM+MONEY+CAP,
"bomb <bomber-PLANES> <fighter-PLANES> <pin|strat|nuke> <ap-SECT> <PATH|DESTINATION>",2,bomb,NORM+MONEY+CAP,
"break {sanctuary}",                    1,	brea,	SANCT,
"budget [<sector type|P|S|L|A|M|N|C> <PRIORITY|~>]",1,budg,NORM,
"build <s|n|b|p> <SECTS> <type|dir> <tech>",1,	buil,	NORM+MONEY+CAP,
"buy <COMM> [<NAT> <NUM> <SECT>]",      1,	buy,	GOD,
"bye {log-off}",                        0,	quit,	VIS,
"capitol <SECT>",                       0,	capi,	NORM,
"cargo <SHIPS>",                        0,	carg,	NORM,
"cede <SECTS|SHIPS> <COUNTRY>",         1,	cede,	GOD,
"census <SECTS>",                       0,	cens,	VIS,
"change <country|representative> <NAME>",0,	chan,	NORM,
"coastwatch <SECTS>",                   1,	coas,	NORM+CAP,
"collect <LOAN> <SECT>",                2,	coll,	GOD,
"commodity <SECTS>",                    0,	comm,	VIS,
"consider <loan|treaty> <LOAN/TREATY> <acc|decl|post>",1,cons,GOD,
"convert <SECTS> <NUM>",                2,	conv,	NORM+MONEY+CAP,
"country <NATS>",                       0,	coun,	NORM,
"cutoff <SECTS>",                       0,	cuto,	NORM,
"declare <all|neut|hos|war> <NAT>",     2,	decl,	NORM+CAP,
"deliver <COMM> <SECTS> <DIR> <[+|-]thresh>",1,	deli,	NORM,
"demobilize <SECTS> <NUM> <active-reserve?>",1,	demo,	NORM+MONEY+CAP,
"designate <SECTS> <type>",             1,	desi,	NORM,
"disable",                              0,	disa,	GOD,
"dissolve <really dissove?>",           0,	diss,	GOD,
"distribute <SECTS> <DISTSECT|.|h>",	1,	dist,	NORM,
"drop <cargo-PLANES> <fighter-PLANES> <ap-SECT> <PATH|DESTINATION> <COMM>",1,drop,NORM+MONEY+CAP,
"dump <SECTS>",	                        0,	dump,	NORM,
"edit <country|unit|ship|plane|nuke>",	0,	edit,	GOD,
"enable",                               0,	enab,	GOD,
"enlist <SECTS> <NUM>",                 2,	enli,	NORM+MONEY+CAP,
"execute <INPUT FILE>",                 0,	execute,VIS,
"explore <c|m> <SECT> <NUM> <PATH|DESTINATION>",1,expl,	NORM+MONEY+CAP,
"financial",                            0,	fina,	GOD,
"fire <land, ship or sect> <from-SECTS | SHIPS | UNITS> [TO-SECT | SHIP]",1,multifire,NORM+MONEY+CAP,
"fleetadd <FLEET> <SHIPS>",             0,	flee,	NORM,
"fly <cargo-PLANES> <fighter-PLANES> <ap-SECT> <PATH|DESTINATION> <COM>",2,fly,NORM+MONEY+CAP,
#ifdef	SAIL
"follow <leader> <SHIPS>",		1,	foll,	NORM+MONEY+CAP,
#endif	SAIL
"force <delay time>",  			0,	force,	GOD,
"fort <UNITS> <MOB>",                   1,	fort,	NORM,
#ifdef FUEL
"fuel <SHIPS|UNITS> <AMOUNT> [TENDER]",	1,	fuel,	NORM,
#endif /* FUEL */
"give <COMM> <SECT> <NUM>",	        0,	give,	GOD,
"grind <SECT> <NUM>",			1,	grin,	NORM+MONEY+CAP,
"harden <PLANES> <NUM>",                2,	hard,	NORM+MONEY+CAP,
"headlines [days]",                     0,	head,	VIS,
"hidden <SECTS>",	                0,	hidd,	GOD,
"info <topic>",                         0,	info,	VIS,
"land <UNITS>",				0,	land,	NORM,
"launch <PLANES>",                      3,	laun,	NORM+MONEY+CAP,
"lcargo <UNITS>",                       0,	lcarg,	NORM,
"ledger <LOANS>",                       0,	ledg,	GOD,
"level <SECTS>",                        0,	leve,	NORM,
"list of commands",                     0,	explain,VIS,
"lload <UNIT> <NUM|PLANE> <COMM|\"plane\">",1,	lload,	NORM+MONEY+CAP,
"llookout <UNITS>",                     1,	llook,	NORM+MONEY+CAP,
"lmap <SECTS|UNIT>",                    0,	map,	NORM,
"lmine <UNITS>",                        2,	landmine,NORM+MONEY+CAP,
"load <SHIPS> <NUM|UNIT|PLANE> <COMM|\"unit\"|\"plane\">",1,load,NORM+MONEY+CAP,
"lookout <SHIPS>",                      1,	look,	NORM+MONEY+CAP,
"lradar <UNITS | SECTS>",               1,	lrada,	NORM+MONEY+CAP,
"lrange <UNITS> <range>",		1,	lrange,	NORM+MONEY+CAP,
"lretreat <UNITS|ARMY> <PATH> [i|h|b|c]", 1,	lretr,	NORM+MONEY+CAP,
"ltend <tender-SHIPS> <COMM> <NUM> <UNITS>",1,	ltend,	NORM+MONEY+CAP,
"lunload <UNITS> <NUM|PLANE> <COMM|\"plane\">",1,lload,	NORM+MONEY+CAP,
"mail",					0,	mail,	VIS,
"market [COMM]",                        0,	mark,	GOD,
"map <SECTS|SHIP>",                     0,	map,	VIS,
"march <UNITS> <PATH|DESTINATION>",     1,	march,	NORM+MONEY+CAP,
"mine <SHIPS>",                         2,	mine,	NORM+MONEY+CAP,
"miss <type> <PLANES|SHIPS|UNITS> <mission type> <op sect> [<radius>]", 2,mission,NORM+MONEY+CAP,
"morale <UNITS> <retreat%>",		1,	morale,	NORM+MONEY+CAP,
"move <c|m|s|g|p|i|o|b|f|r|u> <SECT> <NUM> <PATH|DESTINATION>",1,move,NORM+CAP,
#ifdef	SAIL
"mquota <SHIPS> <value>",		2,	mobq,	NORM+MONEY+CAP,
#endif	SAIL
"mult [COUNTRY]",                       1,	mult,	NORM,
#ifdef	SHIPNAMES
"name <SHIPS> <NAME>",			0,	name,	NORM,
#endif	SHIPNAMES
"nation",                               0,	nati,	VIS,
"navigate <SHIPS> <PATH|DESTINATION>",  1,	navi,	NORM+MONEY+CAP,
"newcap <NAT>",                         0,	new,	GOD,
"neweff <SECTS>",                       0,	newe,	NORM,
"newspaper [days]",                     0,	news,	VIS,
"nuke <NUKES>",                         0,	nuke,	NORM,
"offer <loan|treaty> <NAT> [<NUM> <DAYS> <IRATE>]",1,offe,GOD,
"offset <SECT|NAT>",                    0,	offs,	GOD,
"order <SHIPS> <c|s|r|d|l> ",		1,	orde,	NORM+MONEY+CAP, 
"origin <SECT>",                        1,	orig,	NORM,
"paradrop <cargo-PLANES> <fighter-PLANES> <ap-SECT> <PATH|DESTINATION>",3,para,NORM+MONEY+CAP,
"path <SECT>",                          0,	path,	NORM,
#ifdef TRADESHIPS
"payoff <SHIPS>",                       0,	payo,	NORM,
#endif /* TRADESHIPS */
"plane <SECTS>",                        0,	plan,	NORM,
"pmap <SECTS|UNIT>",                    0,	map,	NORM,
"power [\"new\"]",                      0,	powe,	VIS,
"production <SECTS>",                   0,	prod,	NORM,
"qorder <SHIPS>",			0,	qorde,	NORM+MONEY+CAP,
#ifdef	SAIL
"qsail <SHIPS>",			0,	sail,	NORM+MONEY+CAP,
#endif	SAIL
"quit",                                 0,	quit,	VIS,
"radar <SHIPS | SECTS>",                1,	rada,	NORM+MONEY+CAP,
"range <PLANES> <range>",		1,	range,	NORM+MONEY+CAP,
"read",                                 0,	rea,	VIS,
"realm <number> [<SECTS>]",             0,	real,	NORM,
"recon <spy-PLANES> <fighter-PLANES> <ap-SECT> <PATH|DESTINATION>",3,reco,NORM+MONEY+CAP,
"retreat <SHIPS|FLEET> <PATH> [i|t|s|h|b|d|c]", 1,retr,	NORM+MONEY+CAP,
"relations  [as-COUNTRY]",		0,	rela,	VIS,
"reject <reject|accept> <announcements|mail|treaties|loans> <NAT>",2,reje,NORM,
"repay <LOAN> <NUM>",                   1,	repa,	GOD,
"report <NATS>",                        0,	repo,	VIS,
"resource <SECTS>",                     0,	reso,	NORM,
"route <COMM> <SECTS>",                 1,	rout,	NORM,
#ifdef	SAIL
"sail <SHIPS> <PATH>",			1,	sail,	NORM+MONEY+CAP,
#endif	SAIL
"satellite <SECTS>",                    1,	sate,	NORM+MONEY+CAP,
"scrap <TYPE> <SHIPS|PLANES>",          2,	scra,	NORM+MONEY+CAP,
"scuttle <TYPE> <SHIPS|PLANES>",	5,	scut,	NORM+CAP,
"sect <SECTS>",                         0,	sct,	NORM,
"sell <COMM> <SECTS> <NUM> <NUM>",      1,	sell,	GOD,
"set <TYPE> <LIST> <PRICE>",            1,	set,	GOD,
"setsector <TYPE> <SECTS> <amt>",	0,	setsector,GOD,
"setresource <TYPE> <SECTS> <AMT>",	0,	setres,	GOD,
"ship <SHIPS>",                         0,	shi,	NORM,
"shoot <SECTS> <CIVS|UWS> <NUMBER>",    3,	shoo,	NORM+MONEY+CAP,
"show <TYPE> <\"build\"|\"stats\"|\"cap\">",	0,show,	VIS,
"smap <SECTS|UNIT>",                    0,	map,	NORM,
"sonar <SHIPS>",		        1,	sona,	NORM+MONEY+CAP,
"sorder <SHIPS>",			0,	sorde,	NORM+MONEY+CAP, 
"spy <SECTS>",				1,	spy,	NORM+MONEY+CAP,
"start <SECTS>", 			1,	start,	NORM+CAP,
"starvation <SECTS>",                   0,	starve,	NORM,
"stop <SECTS>", 			1,	stop,	NORM+CAP,
"supply <LAND UNITS>",                  1,	supp,	NORM+MONEY+CAP,
"survey <COMM|VAR> <SECTS>",            0,	surv,	NORM+CAP,
"sweep <sweep-PLANES> <fighter-PLANES> <ap-SECT> <PATH|DESTINATION>",3,reco,NORM+MONEY+CAP,
"telegram <NAT>",                       0,	tele,	NORM,
"tend <tender-SHIPS> <COMM> <NUM> <dest-SHIPS>",1,tend,	NORM+MONEY+CAP,
"territory <SECTS> <NUMBER>",		0,	terr,	NORM,
"test <c|m|s|g|p|i|o|b|f|r|u> <SECT> <NUM> <PATH|DESTINATION>",1,move,NORM+CAP,
"threshold <COMM> <SECTS> <THRESH>",    1,	thre,	NORM,
"torpedo <submarine-SHIP> <target-SHIP>",3,	torp,	NORM+MONEY+CAP,
"trade",                                1,	trad,	GOD,
"transport <\"nuke\"|\"plane\"> <NUKES|PLANES> [nuketype] <PATH|DESTINATION>",1,tran,NORM+MONEY+CAP,
"treaty <TREATIES>",                    0,	trea,	NORM+MONEY+CAP,
"turn <\"on\"|\"off\"|\"mess\">",       0,	turn,	GOD,
"unit <UNITS>",                         0,	land,	NORM,
"unload <SHIPS> <NUM|UNIT|PLANE> <COMM|\"unit\"|\"plane\">",1,load,NORM+MONEY+CAP,
#ifdef	SAIL
"unsail <SHIPS>",			1,	sail,	NORM+MONEY+CAP,
#endif	SAIL
"update",                               0,	upda,	VIS,
"upgrade <SHIPS>",                      1,	upgr,	NORM+MONEY+CAP,
"version",                              0,	vers,	VIS,
"wait",                                 0,	wai,	GOD,
"wingadd <WING> <PLANES>",              1,	wing,	NORM,
"wipe <SECTS>",				1,	wipe,	NORM,
"wire <yes|no>",                        0,	rea,	VIS,
"wmail",				0,	mail,	VIS,
"work <LAND UNITS> <AMOUNT>",		1,	work,	NORM+MONEY+CAP,
#ifdef	DEMANDUPDATE
"zdone <y|n|c>",			0,	zdon,	NORM,
#endif	DEMANDUPDATE
0,					0,	0,	0,
};
