#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/para.c,v 1.7 89/08/17 22:11:25 jeffw Exp $";
#endif

/*
 * para.c
 *
 * Drop paratroops onto a sector
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "item.h"
#include "plane.h"
#include "land.h"
#include "nuke.h"
#include "xy.h"
#include "nsc.h"
#include "news.h"
#include "file.h"
#include "nat.h"
#include "path.h"
#include "treaty.h"
#include "mission.h"

#define CASUALTY_LUMP 1
static	paradrop();
static total_defense_strength();
static p_take_defender_casualty();

para()
{
	s_char	*p;
	int	mission_flags;
	int	tech;
	coord	tx, ty;
	coord	ax, ay;
	int	ap_to_target;
	s_char	flightpath[256];
	struct	nstr_item ni_bomb;
	struct	nstr_item ni_esc;
	coord	x, y;
	struct	sctstr target;
	struct	qelem bomb_list;
	struct	qelem esc_list;
	int	wantflags;
	struct	sctstr ap_sect;
	s_char	buf[1024];
#ifdef SLOW_WAR
	int	rel;
	struct natstr	*natp;
#endif /* SLOW_WAR */

	wantflags = P_P;
	if (!snxtitem(&ni_bomb, EF_PLANE, player->argp[1]))
		return RET_SYN;
	if (!snxtitem(&ni_esc, EF_PLANE, player->argp[2]))
		pr("No escorts...\n");
	if ((p = getstarg(player->argp[3], "assembly point? ", buf)) == 0 || *p == 0)
		return RET_SYN;
	if (!sarg_xy(p, &x, &y) || !getsect(x, y, &ap_sect))
		return RET_SYN;
	if (ap_sect.sct_own && ap_sect.sct_own != player->cnum) {
		pr("Assembly point not owned by you!\n");
		return RET_SYN;
	}
	ax = x;
	ay = y;
	if (getpath(flightpath, player->argp[4], ax, ay, 0,
	    0, 0, P_FLYING) == 0 || *flightpath == 0)
		return RET_SYN;
	tx = ax;
	ty = ay;
	(void) pathtoxy(flightpath, &tx, &ty, fcost);
	getsect(tx, ty, &target);
	if (target.sct_own == player->cnum) {
		/* we *could* just drop them off .. */
		pr("You already own %s\n", xyas(tx, ty, player->cnum));
		return RET_SYN;
	}
	pr("LZ is %s\n", xyas(tx, ty, player->cnum));
	ap_to_target = strlen(flightpath);
	if (*(flightpath+strlen(flightpath)-1) == 'h')
		ap_to_target--;
	pr("range to target is %d\n", ap_to_target);
	/*
	 * select planes within range
	 */
	pln_sel(&ni_bomb, &bomb_list, &ap_sect, ap_to_target,
		2, P_C|wantflags, P_M|P_O);
	pln_sel(&ni_esc, &esc_list, &ap_sect, ap_to_target,
		2, P_ESC|P_F, P_M|P_O);
	/*
	 * now arm and equip the bombers, transports, whatever.
	 * tech is stored in high 16 bits of mission_flags.
	 * yuck.
	 */
	tech=0;
	mission_flags = 0;
	mission_flags |= P_X;		/* stealth (shhh) */
	mission_flags |= P_H; /* gets turned off if not all choppers */
	mission_flags = pln_arm(&bomb_list, 'a', &ichr[I_MILIT],
		0, mission_flags,&tech);
	if (QEMPTY(&bomb_list)) {
		pr("No planes could be equipped for the mission.\n");
		return RET_FAIL;
	}
	mission_flags = pln_arm(&esc_list, 'a', &ichr[I_MILIT],
		P_ESC|P_F, mission_flags,&tech);
	ac_encounter(&bomb_list,&esc_list,ax,ay,flightpath,mission_flags,0);
#ifdef SLOW_WAR
	natp = getnatp(player->cnum);
	rel = getrel(natp,target.sct_own);
	if ((rel != AT_WAR) && (target.sct_own) && (target.sct_oldown != player->cnum)){
		pr("You're not at war with them!\n");
		return RET_FAIL;
	}
#endif /* SLOW_WAR */
	if (QEMPTY(&bomb_list)) {
		pr("No planes got through fighter defenses\n");
	} else {
		getsect(tx, ty, &target);
		if (target.sct_own && !trechk(player->cnum, target.sct_own, LANATT)) {
			pln_put(&bomb_list);
			pln_put(&esc_list);
			return RET_OK;
		}
		paradrop(&bomb_list, &target);
		putsect(&target);
	}
	pln_put(&bomb_list);
	pln_put(&esc_list);
	return RET_OK;
}

static
paradrop(list, target)
	struct	qelem *list;
	struct	sctstr *target;
{
	extern	double combat_mob;
	register struct plist *plp;
	int	a_mil;
	int	a_cas;
	int	d_mil;
	int	d_cas;
	int	success;
	double	odds;
	double	shuffle;
	struct	qelem *qp, d_list, *next;
	double	d_bonus;
	struct	lndstr land;
	struct	nstr_item ni;
	struct	llist *llp;
	int	a_total, d_total;
	int	d_bodies=0;
	double	loss_percentage;
	int	mcost;
	natid	d_own;
	int	new;

	d_own = target->sct_own;
	d_mil = getvar(V_MILIT, (s_char *)target, EF_SECTOR);
	d_bodies = d_mil;
	initque(&d_list);
	snxtitem_xy(&ni,EF_LAND,target->sct_x,target->sct_y);
	while(nxtitem(&ni,(s_char *)&land)){
		if (land.lnd_own == 0)
			continue;
		if (land.lnd_own != target->sct_own)
			continue;
		if (land.lnd_ship >= 0)
			continue;
		llp = (struct llist *)malloc(sizeof(struct llist));
		bzero((s_char *)llp,sizeof(struct llist));
		llp->state = (has_supply(&land) ? LL_OK : LL_UNSUPPLIED);
		llp->x = land.lnd_x;
		llp->y = land.lnd_y;
		llp->lcp = &lchr[land.lnd_type];
		land.lnd_mission = 0;
		putland(land.lnd_uid,&land);
		bcopy((s_char *)&land,(s_char *)&llp->land,sizeof(struct lndstr));
		insque(&llp->queue,&d_list);
		intelligence_report(player->cnum,&land,0,"Paras report enemy unit:");
		d_bodies += total_mil(&land);
	}
	
	a_mil = 0;
	a_cas = 0;
	d_cas = 0;
	success = 0;
	for (qp = list->q_forw; qp != list; qp = qp->q_forw) {
		plp = (struct plist *) qp;
		if (plp->pcp->pl_flags & (P_V|P_C))
			a_mil += plp->misc;
	}
	switch (target->sct_type) {
	case SCT_MOUNT:
	case SCT_WATER:
	case SCT_CAPIT:
	case SCT_FORTR:
	case SCT_WASTE:
		a_cas = a_mil;
		goto fail;
	default:
		d_bonus = dchr[target->sct_type].d_dstr *
			target->sct_effic / 100.0;
		if (d_bonus < 2.0)
			d_bonus = 2.0;
		break;
	}
	a_total = a_mil;
	d_total = total_defense_strength(d_mil,&d_list,d_bonus);

	if (a_total <= 0)
		odds = 0.0;
	else if (d_total <= 0)
		odds = 1.0;
	else
		odds = a_total / (d_bonus * (d_total + a_total));
	if (d_total == 0 && a_total > 0)  {
		pr("There are no defenders\n");
		success++; 
	} else
		pr("Your odds are %.2f%%\n", 100*odds);
	while (!success && a_total > 0 && d_total > 0) {
		if (chance(odds)) {
			pr("!");
			d_cas += p_take_defender_casualty(&d_mil,&d_list,d_own);
			d_total = total_defense_strength(d_mil,&d_list,d_bonus);
			if (d_total == 0)
				success++;

		} else {
			pr("@");
			a_total--;
			a_cas++;
		}
	}
fail:
	if (target->sct_own)
		wu(0, target->sct_own,
			"Country #%d lost %d air-assaulting %ssector %s\n",
			player->cnum, a_cas, success ? "(and taking) " : "",
			xyas(target->sct_x, target->sct_y, target->sct_own));
	if (success) {
		a_mil = a_total;
		pr("You have taken sector %s\n",
			xyas(target->sct_x, target->sct_y, player->cnum));
		nreport(player->cnum, N_WON_SECT, target->sct_own, 1);
		if (target->sct_type==SCT_CAPIT || target->sct_type==SCT_MOUNT)
			caploss(target, target->sct_own,
				"which is also %s's capitol!\n");
		a_mil = takeover(target, a_mil);
		target->sct_mobil = 0;
		putvar(V_MILIT, a_mil, (s_char *)target, EF_SECTOR);
	} else {
		pr("You have been defeated!\n");
		nreport(player->cnum, N_SCT_LOSE, target->sct_own, 1);
		putvar(V_MILIT, d_mil, (s_char *)target, EF_SECTOR);
	}
	if (a_cas > 0 || d_cas > 0) {
		pr("Casualties :\nYours... %d\n", a_cas);
		pr("Theirs.. %d\n", d_cas);
		shuffle = 2 * (a_cas + d_cas) * 0.015;
		pr("Papershuffling ... %.1f B.T.U\n", shuffle);
		player->btused += roundavg(shuffle);
	}

	new = target->sct_effic - (a_cas + d_cas)/10;
	new = (new < 0 ? 0 : new);
	target->sct_effic = new;

	/* Deduct mobility from all units in battle, depending on losses */
	/* Mob cost is 10 * % losses. Defenders on reserve pay 1/2 */

	loss_percentage = ((double)d_cas)/((double)d_bodies);
	mcost = ldround((combat_mob * loss_percentage),1);
	for (qp=d_list.q_forw;qp!=(&d_list);qp=qp->q_forw){
		llp = (struct llist *)qp;
		if (llp->state == LL_DEAD)
			continue;
		if (chance(loss_percentage))
			use_supply(&llp->land);
		if (land.lnd_mission == MI_RESERVE)
			llp->land.lnd_mobil -= mcost/2;
		else
			llp->land.lnd_mobil -= mcost;
		putland(llp->land.lnd_uid,&llp->land);
	}
	for(qp=d_list.q_forw;qp!=(&d_list);qp=next){
		next = qp->q_forw;
		free(qp);
	}
}

static
total_defense_strength(d_mil,d_list,defval)
int		d_mil;
struct qelem	*d_list;
double		defval;
{
	double	d_total, d_unit;
	struct	qelem *qp;
	struct	llist *llp;

	d_total = d_mil;

	/*
	 * next, add in the defense_values of all
	 * the defending non-retreating units
	 */

	for (qp = d_list->q_forw; qp != d_list; qp = qp->q_forw){
		llp = (struct llist *)qp;
		d_unit = 0.0;
		if (llp->state == LL_OK)
			d_unit = defense_val(&llp->land);
		else if (llp->state == LL_UNSUPPLIED)
			d_unit = ((double)defense_val(&llp->land)/2.0);
		d_unit *= ((127.0+((double)llp->land.lnd_harden)) / 127.0);
		d_total += d_unit;
	}

	d_total *= defval;

	return (int)d_total;
}

static
p_take_defender_casualty(d_mil,d_list,down)
int *d_mil;
struct qelem *d_list;
natid down;
{
	int	to_take = CASUALTY_LUMP;
	int	biggest_mil, cas;
	struct	qelem *qp, *biggest;
	struct	llist *llp;

	if (*d_mil)
		to_take -= (*d_mil);
		
	if (to_take >= 0)
		(*d_mil) = 0;
	else{
		(*d_mil) -= CASUALTY_LUMP;
		return CASUALTY_LUMP;
	}

	if (QEMPTY(d_list))
		return (CASUALTY_LUMP - to_take);

	/*
	 *  Need to take some casualties from defending units
	 *  Procedure: find the biggest unit remaining (in
	 *  terms of mil) and give it the casualties.
	 */
	biggest = (struct qelem *)0;
	biggest_mil = 0;
	for (qp = d_list->q_forw; qp != d_list; qp = qp->q_forw){
		llp = (struct llist *)qp;
		
		if ((llp->state == LL_RETREATED) || (llp->state == LL_DEAD))
			continue;

		if (total_mil(&llp->land) > biggest_mil){
			biggest_mil = total_mil(&llp->land);
			biggest = qp;
		}
	}
	if (biggest == (struct qelem *)0)
		return (CASUALTY_LUMP-to_take);

	llp = (struct llist *)biggest;
	llp->state = take_casualty(llp,to_take,llp->state,&cas,0,down);
	return (CASUALTY_LUMP-(to_take-cas));
}
