#ifndef lint
static char *RCSid = "$Header: hard.c,v 1.6 89/12/04 20:18:22 mr-frog Exp $";
#endif /* not lint */

/*
 * hard.c
 *
 * increases the silo protection of a given missile.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "plane.h"
#include "nuke.h"
#include "ship.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "file.h"

/*
 * harden <PLANE> <LEVEL>
 */
hard()
{
	struct	plchrstr *pcp;
	struct	plnstr pln;
	int	level;
	s_char	*p;
	int	hcm;
	int	n;
	struct	nstr_item ni;
	struct	sctstr sect;
	s_char	buf[1024];

	if (!snxtitem(&ni, EF_PLANE, player->argp[1]))
		return RET_SYN;
	if ((p = getstarg(player->argp[2], "Increase by? ", buf)) == 0 || *p == 0)
		return RET_SYN;
	level = atoi(p);
	if (level < 0)
		return RET_SYN;
	while (nxtitem(&ni, (s_char *)&pln)) {
		if (!player->owner)
			continue;
		pcp = &plchr[pln.pln_type];
		if ((pcp->pl_flags & P_M) == 0) {
			pr("%s #%d isn't a missile!\n", pcp->pl_name,
				pln.pln_uid);
			continue;
		}
		if (pln.pln_ship >= 0)	/* can't harden ssbns ... */
			continue;
		n = level;
		if (level + pln.pln_harden > 127)
			n = 127 - pln.pln_harden;
		if (n <= 0) {
			pr("%s #%d is already completely hardened!\n",
				pcp->pl_name, pln.pln_uid);
			continue;
		}
		if (!getsect(pln.pln_x, pln.pln_y, &sect))
			continue;
		if (sect.sct_own != player->cnum) {
			pr("%s #%d: you don't own %s!\n", pcp->pl_name,
				pln.pln_uid,
				xyas(pln.pln_x, pln.pln_y, player->cnum));
			continue;
		}
		hcm = getvar(V_HCM, (s_char *)&sect, EF_SECTOR);
		if (hcm == 0) {
			pr("No hcm in %s\n",
				xyas(pln.pln_x, pln.pln_y, player->cnum));
			continue;
		}
		if (hcm <= n)
			n = hcm;
		pln.pln_harden += n;
		player->dolcost += (5.0 * n);
		putplane(pln.pln_uid, &pln);
		putvar(V_HCM, hcm - n, (s_char *)&sect, EF_SECTOR);
		putsect(&sect);
		pr("%s #%d hardened to %d\n", plchr[pln.pln_type].pl_name,
			pln.pln_uid, pln.pln_harden);
	}
	return RET_OK;
}
