#ifndef lint
static char *RCSid = "$Header: move_sat.c,v 1.0 90/04/04 00:52:47 bailey Exp $";
#endif

/*
 * move_sat.c
 *
 * Move a satellite to the next point in its orbit
 *
 */

#include <math.h>
#include "misc.h"
#include "var.h"
#include "plane.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "path.h"
#include "deity.h"
#include "file.h"

#ifdef	ORBIT

#define	PI	3.14159265358979323846

move_sat(pp)
    register struct plnstr *pp;
{
    coord	x1,y1,x2,y2;
    coord	dx,dy;
    float	newtheta;

    newtheta = pp->pln_theta + .05;

    if (newtheta >= 1.0)
    {
	newtheta -= 1.0;
    };

    x1 = (coord)(2 * pp->pln_theta * WORLD_X);
    x1 = xnorm(x1);
    y1 = (coord)(sin(6 * PI * pp->pln_theta) * (WORLD_Y / 4));
    x2 = (coord)(2 * newtheta * WORLD_X);
    x2 = xnorm(x2);
    y2 = (coord)(sin(6 * PI * newtheta) * (WORLD_Y / 4));
    dx = x1 - pp->pln_x;
    dy = y1 - pp->pln_y;
    x2 -= dx;
    y2 -= dy;

    if	((x2 + y2) & 1)
    {
	x2++;
    };

    pp->pln_x = xnorm(x2);
    pp->pln_y = ynorm(y2);
    pp->pln_theta = newtheta;
    return;
}

#endif	ORBIT
