/* ************************************************************************
*   File: spells.h                                      Part of CircleMUD *
*  Usage: header file: constants and fn prototypes for spell system       *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
************************************************************************ */

#define DEFAULT_STAFF_LVL	12
#define DEFAULT_WAND_LVL	6

#define CAST_UNDEFINED	-1
enum cast {
  CAST_SPELL,
  CAST_POTION,
  CAST_WAND,
  CAST_STAFF,
  CAST_SCROLL
};

struct magic {
  BIT(MAG_DAMAGE);
  BIT(MAG_AFFECTS);
  BIT(MAG_UNAFFECTS);
  BIT(MAG_POINTS);
  BIT(MAG_ALTER_OBJS);
  BIT(MAG_GROUPS);
  BIT(MAG_MASSES);
  BIT(MAG_AREAS);
  BIT(MAG_SUMMONS);
  BIT(MAG_CREATIONS);
  BIT(MAG_MANUAL);
};

#define TYPE_UNDEFINED               -1
#define MAX_SPELLS		    130

/* PLAYER SPELLS -- Numbered from 1 to MAX_SPELLS */
enum player_spells_skills {
  SPELL_RESERVED_DBC,
  SPELL_ARMOR,
  SPELL_TELEPORT,
  SPELL_BLESS,
  SPELL_BLINDNESS,
  SPELL_BURNING_HANDS,
  SPELL_CALL_LIGHTNING,
  SPELL_CHARM,
  SPELL_CHILL_TOUCH,
  SPELL_CLONE,
  SPELL_COLOR_SPRAY,
  SPELL_CONTROL_WEATHER,
  SPELL_CREATE_FOOD,
  SPELL_CREATE_WATER,
  SPELL_CURE_BLIND,
  SPELL_CURE_CRITIC,
  SPELL_CURE_LIGHT,
  SPELL_CURSE,
  SPELL_DETECT_ALIGN,
  SPELL_DETECT_INVIS,
  SPELL_DETECT_MAGIC,
  SPELL_DETECT_POISON,
  SPELL_DISPEL_EVIL,
  SPELL_EARTHQUAKE,
  SPELL_ENCHANT_WEAPON,
  SPELL_ENERGY_DRAIN,
  SPELL_FIREBALL,
  SPELL_HARM,
  SPELL_HEAL,
  SPELL_INVISIBLE,
  SPELL_LIGHTNING_BOLT,
  SPELL_LOCATE_OBJECT,
  SPELL_MAGIC_MISSILE,
  SPELL_POISON,
  SPELL_PROT_FROM_EVIL,
  SPELL_REMOVE_CURSE,
  SPELL_SANCTUARY,
  SPELL_SHOCKING_GRASP,
  SPELL_SLEEP,
  SPELL_STRENGTH,
  SPELL_SUMMON,
  SPELL_VENTRILOQUATE,
  SPELL_WORD_OF_RECALL,
  SPELL_REMOVE_POISON,
  SPELL_SENSE_LIFE,
  SPELL_ANIMATE_DEAD,
  SPELL_DISPEL_GOOD,
  SPELL_GROUP_ARMOR,
  SPELL_GROUP_HEAL,
  SPELL_GROUP_RECALL,
  SPELL_INFRAVISION,
  SPELL_WATERWALK,
  /* Insert new spells above this line, up to MAX_SPELLS */
  SPELL_END,

  /* PLAYER SKILLS - Numbered from MAX_SPELLS+1 to MAX_SKILLS */
  SKILL_BACKSTAB = MAX_SPELLS +1,
  SKILL_BASH,
  SKILL_HIDE,
  SKILL_KICK,
  SKILL_PICK_LOCK,
  SKILL_PUNCH,
  SKILL_RESCUE,
  SKILL_SNEAK,
  SKILL_STEAL,
  SKILL_TRACK,
  /* New skills may be added above this line up to MAX_SKILLS (200) */
  SKILL_END,


  /*
   *  NON-PLAYER AND OBJECT SPELLS AND SKILLS
   *  The practice levels for the spells and skills below are _not_ recorded
   *  in the playerfile; therefore, the intended use is for spells and skills
   *  associated with objects (such as SPELL_IDENTIFY used with scrolls of
   *  identify) or non-players (such as NPC-only spells).
   */

  SPELL_IDENTIFY = MAX_SKILLS + 1,
  SPELL_FIRE_BREATH,
  SPELL_GAS_BREATH,
  SPELL_FROST_BREATH,
  SPELL_ACID_BREATH,
  SPELL_LIGHTNING_BREATH,

  /* NEW NPC/OBJECT SPELLS can be inserted above this line up to 299 */
  TOP_SPELL_DEFINE = 299,


  /* WEAPON ATTACK TYPES */

  TYPE_HIT = 300,
  TYPE_STING,
  TYPE_WHIP,
  TYPE_SLASH,
  TYPE_BITE,
  TYPE_BLUDGEON,
  TYPE_CRUSH,
  TYPE_POUND,
  TYPE_CLAW,
  TYPE_MAUL,
  TYPE_THRASH,
  TYPE_PIERCE,
  TYPE_BLAST,
  TYPE_PUNCH,
  TYPE_STAB,

  /* new attack types can be added here - up to TYPE_SUFFERING */
  TYPE_SUFFERING = 399
};



#define SAVING_PARA   0
#define SAVING_ROD    1
#define SAVING_PETRI  2
#define SAVING_BREATH 3
#define SAVING_SPELL  4


struct target_types {
  BIT(TAR_IGNORE);
  BIT(TAR_CHAR_ROOM);
  BIT(TAR_CHAR_WORLD);
  BIT(TAR_FIGHT_SELF);
  BIT(TAR_FIGHT_VICT);
  BIT(TAR_SELF_ONLY);
  BIT(TAR_NOT_SELF);
  BIT(TAR_OBJ_INV);
  BIT(TAR_OBJ_ROOM);
  BIT(TAR_OBJ_WORLD);
  BIT(TAR_OBJ_EQUIP);
};

struct spell_info_type {
   byte min_position;	/* Position for caster	 */
   byte mana_min;	/* Min amount of mana used by a spell (highest lev) */
   byte mana_max;	/* Max amount of mana used by a spell (lowest lev) */
   byte mana_change;	/* Change in mana used by spell from lev to lev */
   int spsk;            /* Is it a spell or a skill? */
  
   byte min_level[NUM_CLASSES];
   struct magic routines;
   byte violent;
   struct target_types targets;
};

/* Possible Targets:

   bit 0 : IGNORE TARGET
   bit 1 : PC/NPC in room
   bit 2 : PC/NPC in world
   bit 3 : Object held
   bit 4 : Object in inventory
   bit 5 : Object in room
   bit 6 : Object in world
   bit 7 : If fighting, and no argument, select tar_char as self
   bit 8 : If fighting, and no argument, select tar_char as victim (fighting)
   bit 9 : If no argument, select self, if argument check that it IS self.

*/

#define SPELL_TYPE_SPELL   0
#define SPELL_TYPE_POTION  1
#define SPELL_TYPE_WAND    2
#define SPELL_TYPE_STAFF   3
#define SPELL_TYPE_SCROLL  4


/* Attacktypes with grammar */

struct attack_hit_type {
   char	*singular;
   char	*plural;
};


#define ASPELL(spellname) \
void	spellname(byte level, struct char_data *ch, \
		  struct char_data *victim, struct obj_data *obj)

#define MANUAL_SPELL(spellname)	spellname(level, caster, cvict, ovict);

ASPELL(spell_create_water);
ASPELL(spell_recall);
ASPELL(spell_teleport);
ASPELL(spell_summon);
ASPELL(spell_locate_object);
ASPELL(spell_charm);
ASPELL(spell_information);
ASPELL(spell_identify);
ASPELL(spell_enchant_weapon);
ASPELL(spell_detect_poison);

/* basic magic calling functions */

int find_skill_num(char *name);

void mag_damage(int level, struct char_data *ch, struct char_data *victim,
  int spellnum, int savetype);

void mag_affects(int level, struct char_data *ch, struct char_data *victim,
  int spellnum, int savetype);

void mag_group_switch(int level, struct char_data *ch, struct char_data *tch, 
  int spellnum, int savetype);

void mag_groups(int level, struct char_data *ch, int spellnum, int savetype);

void mag_masses(int level, struct char_data *ch, int spellnum, int savetype);

void mag_areas(byte level, struct char_data *ch, int spellnum, int savetype);

void mag_summons(int level, struct char_data *ch, struct obj_data *obj,
 int spellnum, int savetype);

void mag_points(int level, struct char_data *ch, struct char_data *victim,
 int spellnum, int savetype);

void mag_unaffects(int level, struct char_data *ch, struct char_data *victim,
  int spellnum, int type);

void mag_alter_objs(int level, struct char_data *ch, struct obj_data *obj,
  int spellnum, int type);

void mag_creations(int level, struct char_data *ch, int spellnum);

int	call_magic(struct char_data *caster, struct char_data *cvict,
  struct obj_data *ovict, int spellnum, int level, int casttype);

void	mag_objectmagic(struct char_data *ch, struct obj_data *obj,
			char *argument);

int	cast_spell(struct char_data *ch, struct char_data *tch,
  struct obj_data *tobj, int spellnum);
