/* Routines for opening the serial port tty  in various raw modes */

#include <sgtty.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/errno.h>

extern int errno;
#define TRUE 1

extern void exit();

struct sgttyb tty_mode;


/* set the tty_modes */

int tty_raw_mode_out(fd)
int fd;
{    
  struct sgttyb temp_mode;
  
  if (ioctl(fd, TIOCGETP, &temp_mode) < 0) {
    perror("TIOCGETP: "); 
    return(-1);
  }
  tty_mode = temp_mode;		/* save in case we want to restore later */

  temp_mode.sg_flags |= RAW;
  temp_mode.sg_flags &= ~ECHO;
  temp_mode.sg_ospeed = B19200;
  temp_mode.sg_ispeed = B19200;

  if (ioctl(fd, TIOCSETP, &temp_mode) < 0) {
    perror("TIOCSETP: "); 
    return(-1);
  }
  return(0);

}

int read_no_hang(fd)
int fd;
{
  fd_set fdset;
  struct timeval timeout;
  char ch;

  FD_ZERO(&fdset);
  FD_SET(fd, &fdset);

  timeout.tv_sec = 0;
  timeout.tv_usec = 0;
  if (select(4, &fdset, (int *)0, (int *)0, &timeout) < 0) 
    perror("Select error");
  
  if (FD_ISSET(fd, &fdset)) {
    read(fd, &ch, 1);
    return((int) ch);
  } else return(-1);
}

int read_with_timeout(fd, secs)
     int fd;
     int secs;
{
  fd_set fdset;
  struct timeval timeout;
  char ch;

  FD_ZERO(&fdset);
  FD_SET(fd, &fdset);

  timeout.tv_sec = secs;
  timeout.tv_usec = 0;
  if (select(4, &fdset, (int *)0, (int *)0, &timeout) < 0) 
    perror("Select error in read_with_timeout");
  
  if (FD_ISSET(fd, &fdset)) {
    read(fd, &ch, 1);
    return((int) ch);
  } else return(-1);
}



int wait_for_char(rch, serial_fd)
int rch;
{ unsigned char ch;
  while (TRUE) {
    read(serial_fd, &ch, 1);
    if ((int) ch == rch) break;
  }
}


