/*
  log.c

  The file is part of the MIT Artificial Intelligence Laboratory's
  automatic fax transmission system.

  (c) Copyright 1990 by David M. Siegel
      All Rights Reserved.

  Sun Nov 4, 1990 at 11:16:34
*/

#include <stdio.h>
#include <syslog.h>
#include <varargs.h>
#include <unistd.h>
#include <time.h>
#include <errno.h>
#include "defines.h"

extern int use_syslog;

/*VARARGS*/
log(va_alist)
va_dcl
{
    va_list ap;
    char *format;
    static int init = FALSE;
    static FILE *faxlog = NULL;
    char buf[BUFSIZ];

    if (!init) {
	if (use_syslog)
	  openlog("faxspooler", LOG_PID|LOG_NOWAIT, LOG_MAIL);
	if (access("/usr/adm/faxlog", W_OK) == 0)
	  faxlog = fopen("/usr/adm/faxlog", "a");
	init = TRUE;
    }

    va_start(ap);
    format = va_arg(ap, char *);
    
    if (use_syslog) {
	vsprintf(buf, format, ap);
	syslog(LOG_NOTICE, buf);
    } else
      vfprintf(stderr, format, ap);

    if (faxlog) {
	time_t t;
	char *dp;
	time(&t);
	dp = ctime(&t);
	dp[strlen(dp)-1] = '\0';
	fprintf(faxlog, "%s: ", dp);
	vfprintf(faxlog, format, ap);
	fflush(faxlog);
    }

    va_end(ap);
}


billing_log(user, phone)
char *user;
char *phone;
{
    int valid_acct = FALSE;
    char account[BUFSIZ];
    static int init = FALSE;
    static FILE *billing_log = NULL;
    char buf[BUFSIZ];

    if (!init) {
      if ( (billing_log = fopen("/usr/adm/faxtxd", "a+")) != NULL) 
	init = TRUE;
      else perror("Can't open log file /usr/adm/faxtxd for writing");
    }
    if (init)
      {
	/* Non-local calls must be registered in the faxusers file */
	time_t t;
	char *dp;
	time(&t);
	dp = ctime(&t);
	dp[strlen(dp)-1] = '\0';

	if (get_account(user, account) < 0)
	  valid_acct = FALSE; 
	else valid_acct = TRUE;
	
	fprintf(billing_log, "%s: ", dp);
	fprintf(billing_log, "user %s sent to %s\n", user, phone);
	fflush(billing_log);
	
      }
    
  }
