h03914
s 00000/00000/00071
d D 1.3 91/02/03 02:08:12 hqm 3 2
c 
e
s 00001/00000/00070
d D 1.2 91/02/03 02:05:57 hqm 2 1
c trying out the SCCS system for the first time
e
s 00070/00000/00000
d D 1.1 91/02/03 02:03:17 hqm 1 0
c date and time created 91/02/03 02:03:17 by hqm
e
u
U
f e 0
t
T
I 1
/* Standalone fax send program stub.
 *
 * This opens the serial_port and then calls the faxsend routine to
 * send the g3 fax files.
 *
 * 
 * usage: faxsend phone-number g3-filename1 g3-filename2 ...
 *
 * This opens a connection, and then sends each g3 format file
 * successively, one document page per file. This assumes exactly 
 * 1728 pixels per line. Page length is variable. 
 *
 * The files must be in raw 1-d huffman coded g3 fax format.
 * For the fax data specs, see  CCITT recommendation T.30 (Blue Book)
 *
 *
 * EXIT CODES:
 * 0    fax sent
 * 1    can't synchronize with modem
 * 2    NO DIALTONE
 * 3    NO CARRIER
 * 4    ERROR 	  
 * 6    NO_DIALTONE    
 * 7    BUSY
 * 8    NO_ANSWER
 *
 * Henry Minsky 11/02/90
 * hqm@ai.mit.edu
 *
I 2
 * Trying the SCCS system out. 2/3/91
E 2
 */

#include <stdio.h>
#include <fcntl.h>
#include <strings.h>

extern void exit();

#include "../include/conf.h"

extern int faxsend();
extern int tty_raw_mode_out();

main(argc, argv)
int argc;
char *argv[];
{
  int serial_fd;
  char *dialstring;

  if (argc < 3) {
    fprintf(stderr, 
	    "usage: sendfax phone-number g3-file1 g3-file2 ...\n");
    exit(1);
  }

  dialstring = argv[1];

  serial_fd = open(SERIAL_PORT, O_RDWR);
  if (serial_fd < 0)
    {perror("sendfax couldn't open serial line "); exit(1);}
  
  if (tty_raw_mode_out(serial_fd) < 0) {
    fprintf(stderr, "couldn't put device in raw mode\n");
    exit(1); 
  }

  exit(faxsend(dialstring, argc-2, &argv[2], serial_fd));


}
E 1
