/* Standalone fax receive program stub.
 *
 * This opens the serial_port and then calls the faxrecive routine to
 * answer phone and receive the g3 fax files into the current directory.
 * 
 * This program creates sequential files for each document page received, 
 * each file has the name basefilename.g3.0,  basefilename.g3.1, ...
 * 
 * usage: faxsend basefilename
 *
 * EXIT CODES:
 * 0    FAXES RECEVIED OK
 * 1    CAN'T SYNCHRONIZE WITH MODEM
 * 2    NO DIALTONE
 * 3    NO CARRIER
 * 4    ERROR 	  
 * 6    NO_DIALTONE    
 * 7    BUSY
 * 8    NO_ANSWER
 *
 * Henry Minsky 11/02/90
 * hqm@ai.mit.edu
 *
 */

#include <stdio.h>
#include <fcntl.h>
#include <strings.h>

extern void exit();

#include "../include/conf.h"

extern int faxreceive();
extern int tty_raw_mode_out();

main(argc, argv)
int argc;
char *argv[];
{
  int serial_fd;

  if (argc != 2) {
    fprintf(stderr, 
	    "usage: faxreceive basefilename\n");
    exit(1);
  }

  serial_fd = open(SERIAL_PORT, O_RDWR);
  if (serial_fd < 0)
    {perror("faxreceive couldn't open serial line "); exit(1);}
  
  if (tty_raw_mode_out(serial_fd) < 0) {
    fprintf(stderr, "couldn't put device in raw mode\n");
    exit(1); 
  }
  
  faxreceive(argv[1], serial_fd);

  close(serial_fd);
  
  exit(0);
}
