/*
  faxmail.c

  The file is part of the MIT Artificial Intelligence Laboratory's
  Netfax automatic fax transmission system.

  This software is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
  to anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer
  to the General Public License for full details.

  Everyone is granted permission to copy, modify and redistribute
  Netfax, but only under the conditions described in the Netfax
  General Public License.  A copy of this license is supposed to have been
  given to you along with Netfax so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.

  (c) Copyright 1990 by Henry Minsky and David M. Siegel.
      All rights reserved.

  Sun Nov 4, 1990 at 11:16:34
*/

#include <stdio.h>
#include <strings.h>
#include <pwd.h>
#include "../include/conf.h"


#define TRUE 1
#define FALSE 0

#define ENSCRIPT "/usr/local/bin/enscript"
#define FONT     "Courier-Bold12"

main(argc,argv)
int argc;
char *argv[];
{
    char buf[BUFSIZ];
    int in_header = TRUE;
    int got_from = FALSE;
    int got_faxphone = FALSE;
    int got_faxrecipient = FALSE;
    int got_faxreturn = FALSE;
    char from[BUFSIZ];
    char faxphone[BUFSIZ];
    char faxrecipient[BUFSIZ];
    char faxreturn[BUFSIZ];
    char *filename;
    FILE *fp;
    char tmpfnam[BUFSIZ];
    char cmd[BUFSIZ];
    struct passwd *pwd;

    int c;
    int errflg = FALSE;
    extern char *optarg;
    extern int optind;

    umask(0);
    
    sprintf(tmpfnam, "%s/mail-XXXXXX", SPOOLDIR);

    while ((c = getopt(argc, argv, "")) != -1)
      switch (c) {
	case '?':
	  errflg = TRUE;;
	  break;
      }

    if (errflg) {
	(void)fprintf(stderr, "usage: %s", argv[0]);
	exit(1);
    }

    while (fgets(buf, sizeof(buf), stdin) != NULL) {

	if (in_header) {

	    /* did we get the end of the header */
	    if (strlen(buf) == 1) {
		if (!(got_faxphone && got_from)) {
		    fprintf(stderr, "header parse error\n");
		    exit(1);
		}
		in_header = FALSE;
		filename = (char *)mktemp(tmpfnam);
		sprintf(cmd, "%s -f%s -p%s.ps", ENSCRIPT, FONT, filename);
		if ((fp = popen(cmd, "w")) == NULL) {
		    perror("popen enscript");
		    exit(1);
		}
	    } else {
		char *ptr = index(buf, ':');

		if (ptr == NULL)
		  continue;

		*ptr = '\0';
		
		if (!got_faxphone) {
		    if (strcasecmp(buf, "faxphone") == 0) {
			strcpy(faxphone, ptr+2);
			faxphone[strlen(faxphone)-1] = '\0';
			got_faxphone = TRUE;
		    }
		}

		if (!got_faxrecipient) {
		    if (strcasecmp(buf, "faxrecipient") == 0) {
			strcpy(faxrecipient, ptr+2);
			faxrecipient[strlen(faxrecipient)-1] = '\0';
			got_faxrecipient = TRUE;
		    }
		}

		if (!got_faxreturn) {
		    if (strcasecmp(buf, "faxreturn") == 0) {
			strcpy(faxreturn, ptr+2);
			faxreturn[strlen(faxreturn)-1] = '\0';
			got_faxreturn = TRUE;
		    
		    }
		}

		if (!got_from) {
		    if (strcasecmp(buf, "from") == 0) {
			char *at;
			strcpy(from, ptr+2);
			got_from = TRUE;

			at = index(from, '@');
			if (at != NULL) {
			    char *space = index(at+1, ' ');
			    if (space != NULL)
			      *space = '\0';
/*			    if (strcmp(at+1, "ai.mit.edu") != 0) {
				fprintf(stderr, "access denied: %s\n", from);
				exit(1);

			    }
*/
			}
			*at = '\0';
		    }
		}
	    }
	} else
	  fputs(buf, fp);
    }

    pclose(fp);

    /*
      Write out queue file:
    */
/*
    security? nah.

    if ((pwd = getpwnam(from)) == NULL) {
	fprintf(stderr, "can't figure out who you are!\n");
	exit(1);
    }
*/
    sprintf(cmd, "%s.qf", filename);
    if ((fp = fopen(cmd, "w")) == NULL) {
	fprintf(stderr, "can't open queue file\n");
	exit(1);
    }

    fprintf(fp, "USER: %s\n", from);
    fprintf(fp, "SENDER: %s\n", from);
    if (got_faxrecipient)
      fprintf(fp, "RECIPIENT: %s\n", faxrecipient);
    if (got_faxreturn)
      fprintf(fp, "RETURNFAX: %s\n", faxreturn);
    fprintf(fp, "PHONE: %s\n", faxphone);
    fclose(fp);

    exit(0);
}
