/*
 coversheet.c

  The file is part of the MIT Artificial Intelligence Laboratory's
  automatic fax transmission system.

  (c) Copyright 1990 by Henry Minsky

 Generates a cover sheet bitmap file with name basename.ppm.0 from a
 postscript file. Takes as args the sender name
 recipient name, return phone number, cover.ps file, and base file name 

*/

#include <stdio.h>
#include <unistd.h>
#include <errno.h>

#include "defines.h"

#define TRUE 1
#define FALSE 0

main(argc,argv)
int argc;
char *argv[];
{
    char buf[BUFSIZ];
    char cmd[BUFSIZ];
    char *recipient;
    char *sender;
    char *returnfaxnum;
    char *pages;
    char filename[128];
    char *coverpsfilename;
    char *basename;
    FILE *fp;

    int c;
    int errflg = FALSE;
    extern char *optarg;
    extern int optind;

    umask(0);
      
    if (argc != 7) {
	fprintf(stderr, "usage: %s recipient sender returnfaxnum pages psfile basename\n", argv[0]);
	exit(1);
    }

    recipient = argv[1];
    sender = argv[2];
    returnfaxnum = argv[3];
    pages = argv[4];
    coverpsfilename = argv[5];
    basename = argv[6];

    if (chdir(LIBDIR) < 0) {
	printf(stderr, "coversheet can't change to lib directory: %s\n", LIBDIR);
	exit(2);
    }

    sprintf(filename, "%s.ppm.0", basename);
    /* Invoke ghostscript with the correct args to write a ppm file */

    if (access(coverpsfilename, R_OK) == 0) {
	if ((fp = popen("gs -dNODISPLAY pstocoverppm.ps", "w")) == NULL) {
	    printf(stderr, "can't open gs\n");
	    exit(1);
	}
	fprintf(fp, "() ppmsetppmdir\n");
	fprintf(fp, "/recipient (%s) def\n", recipient);
	fprintf(fp, "/sender (%s) def\n", sender);
	fprintf(fp, "/returnfaxnum (%s) def\n", returnfaxnum);
	fprintf(fp, "/pages (%s) def\n", pages);

	fprintf(fp, "ppmdict begin /OutFileName (%s) def end\n", filename);
	fprintf(fp, "(%s) ppm1run quit\n", coverpsfilename);
	pclose(fp);
	unlink(buf);
      }
    else { printf(stderr, "Couldn't open coversheet .ps file %s\n", 
		  coverpsfilename); 
	   exit(1); 
	 }
    exit(0);
  }
