/* Main driver for impost program to pretty print files.
   Prints comments in italics, and reserved words in bold for
   C and clu programs.  */

/* Andrew Heybey (atheybey@ptt.lcs.mit.edu)
   15-JAN-1987
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <time.h>
#include <ctype.h>

int max_lines;
int starting;
int type;
char name[256], date[50];

/* Variables from lex.yy.c */
extern int linenum;
extern int pagenum, masterpagenum;
extern FILE *yyin;

/* Defaults go here--
   Also check out how it prints multiple line comments */
#define HFONT "Times-BoldItalic"	/* Header font */
#define HFONTSIZE 12
#define BFONT "Courier"			/* Body font */
#define BFONTSIZE 10
#define CFONT "Courier-Oblique"		/* Comment font */
#define CFONTSIZE 10
#define RFONT "Courier-Bold"		/* Reserved word font */
#define RFONTSIZE 10

/* Default margins, in points */
#define LEFTMARGIN 72
#define TOPMARGIN 36
#define BOTTOMMARGIN 36

#include "filetypes.h"

char *days[] = {
  "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
};

char *months[] = {
  "Jan", "Feb", "Mar", "Apr", "May", "Jun",
  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};


char *rindex();

char *
strcpy_until_num(s1, s2)
     char *s1, *s2;
{
  for (; *s2; s2++)  {
    if (isdigit(*s2))
      break;
    *s1++ = *s2;
  }
  *s1 = '\0';
  return(s2);
}
	

main(argc, argv)
     int argc;
     char *argv[];
{
  FILE *infp, *fp;
  char *dot;
  struct tm *tbuf;
  time_t timeval;
  struct stat statbuf;
  char hfont[50], cfont[50], bfont[50], rfont[50];
  char *s;
  int hfontsize, cfontsize, bfontsize, rfontsize;
  int lmargin, tmargin, bmargin, linespace;
  int do_header, from_stdin = 0;
  int i;
  int forced_type = 0, size, new_name = 0;

  /* Always use stdout for the moment */
  fp = stdout;

  /* Initialize defaults */
  strcpy(hfont, HFONT);  hfontsize = HFONTSIZE;
  strcpy(bfont, BFONT);  bfontsize = BFONTSIZE;
  strcpy(cfont, CFONT);  cfontsize = CFONTSIZE;
  strcpy(rfont, RFONT);  rfontsize = RFONTSIZE;
  lmargin = LEFTMARGIN;
  tmargin = TOPMARGIN;
  bmargin = BOTTOMMARGIN;
  *name = '\0';
  do_header = 1;

  /* Process options */
  for (i = 1; i < argc && *argv[i] == '-'; i++)  {
    if (strncmp(argv[i], "-fb", 3) == 0)  {
      s = strcpy_until_num(bfont, argv[i] + 3);
      if (*s)
	bfontsize = atoi(s);
      continue;
    }
    if (strncmp(argv[i], "-fh", 3) == 0)  {
      s = strcpy_until_num(hfont, argv[i] + 3);
      if (*s)
	hfontsize = atoi(s);
      continue;
    }
    if (strncmp(argv[i], "-fr", 3) == 0)  {
      s = strcpy_until_num(rfont, argv[i] + 3);
      if (*s)
	rfontsize = atoi(s);
      continue;
    }
    if (strncmp(argv[i], "-fc", 3) == 0)  {
      s = strcpy_until_num(cfont, argv[i] + 3);
      if (*s)
	cfontsize = atoi(s);
      continue;
    }
    if (strncmp(argv[i], "-fa", 3) == 0)  {
      s = strcpy_until_num(bfont, argv[i] + 3);
      bfontsize = atoi(s);
      strcpy(cfont, bfont);
      cfontsize = bfontsize;
      strcpy(rfont, bfont);
      rfontsize = bfontsize;
      continue;
    }
    if (strncmp(argv[i], "-sz", 3) == 0)  {
      size = atoi(argv[i] + 3);
      if (size > 0)
	bfontsize = rfontsize = cfontsize = size;
      continue;
    }
    if (strncmp(argv[i], "-lm", 3) == 0)  {
      lmargin = atoi(argv[i] + 3);
      continue;
    }
    if (strncmp(argv[i], "-tm", 3) == 0)  {
      tmargin = atoi(argv[i] + 3);
      continue;
    }
    if (strncmp(argv[i], "-bm", 3) == 0)  {
      bmargin = atoi(argv[i] + 3);
      continue;
    }
    if (strcmp(argv[i], "-clu") == 0)  {
      forced_type = CLU_FILE_TYPE;
      continue;
    }
    if (strcmp(argv[i], "-c") == 0)  {
      forced_type = C_FILE_TYPE;
      continue;
    }
    if (strcmp(argv[i], "-arg") == 0)  {
      forced_type = ARGUS_FILE_TYPE;
      continue;
    }
    if (strcmp(argv[i], "-text") == 0)  {
      forced_type = PLAIN_FILE_TYPE;
      continue;
    }
    if (strcmp(argv[i], "-lisp") == 0)  {
      forced_type = LISP_FILE_TYPE;
      continue;
    }
    if (strcmp(argv[i], "-c++") == 0)  {
      forced_type = CXX_FILE_TYPE;
      continue;
    }
    if (strncmp(argv[i], "-h", 2) == 0)  {
      if (*(argv[i] + 2))  {
	new_name = 1;
	strcpy(name, argv[i]+2);
      }
      else
	do_header = 0;
      continue;
    }
    if (strlen(argv[i]) == 1)	/* Allow "-" option so can have file */
      break;			/* names that start with '-' */

    fprintf(stderr, "%s: unknown option: %s; aborting\n", argv[0], argv[i]);
    exit(1);
  }      

  /* Calculate stuff */
  linespace = bfontsize + 1;
  if (do_header)
    max_lines = (11 * 72 - (tmargin + bmargin) - 11) / linespace;
  else
    max_lines = (11 * 72 - (tmargin + bmargin)) / linespace;

  
  /* Write out prologue to PS file */
  fprintf(fp, "%%!PS-Adobe-\n");
  fprintf(fp, "%%%%DocumentFonts: %s %s %s %s\n", hfont, bfont, cfont, rfont);
  fprintf(fp, "%%%%Creator: psify\n");
  fprintf(fp, "%%%%Pages: (atend)\n");
  fprintf(fp, "%%%%EndComments\n");
  fprintf(fp, "\n");
  
  fprintf(fp, "/HF /%s findfont %d scalefont def\n", hfont, hfontsize);
  fprintf(fp, "/BF /%s findfont %d scalefont def\n", bfont, bfontsize);
  fprintf(fp, "/CF /%s findfont %d scalefont def\n", cfont, cfontsize);
  fprintf(fp, "/RF /%s findfont %d scalefont def\n", rfont, rfontsize);
  fprintf(fp, "/headfont {HF setfont} def\n");
  fprintf(fp, "/normfont {BF setfont} def\n");
  fprintf(fp, "/commentfont {CF setfont} def\n");
  fprintf(fp, "/reservefont {RF setfont} def\n");
  
  fprintf(fp, "/inch {72 mul} def\n");
  fprintf(fp, "/toppos %d def\n", 11*72 - tmargin);
  fprintf(fp, "/leftmar %d def\n", lmargin);
  fprintf(fp, "/linespace %d def\n", linespace);
  fprintf(fp, "normfont\n");
  fprintf(fp, "/tabsize (        ) stringwidth pop def\n");
  fprintf(fp, "/newline {currentpoint linespace sub exch pop");
  fprintf(fp, " leftmar exch moveto} def\n");
  fprintf(fp, "/dotab {currentpoint exch leftmar sub round cvi\n");
  fprintf(fp, "  tabsize round cvi idiv\n");
  fprintf(fp, "  2 index add tabsize mul leftmar add exch moveto pop} def\n");

  if (do_header)  {
    fprintf(fp, "/makeheader {\n");
    fprintf(fp, "  gsave headfont 0.5 inch toppos moveto show\n");
    fprintf(fp, "  dup stringwidth pop 8.5 inch exch sub 2 div\n");
    fprintf(fp, "  toppos moveto show\n");
    fprintf(fp, "  3 string cvs\n");
    fprintf(fp, "  dup stringwidth pop 8 inch exch sub dup toppos\n");
    fprintf(fp, "  moveto exch show\n");
    fprintf(fp, "  (Page ) dup stringwidth pop\n");
    fprintf(fp, "  2 index exch sub\n");
    fprintf(fp, "  toppos moveto show pop\n");
    fprintf(fp, "  newpath 0.5 inch toppos 7 sub moveto\n");
    fprintf(fp, "  7.5 inch 0 rlineto stroke\n");
    fprintf(fp, "  grestore leftmar toppos 11 sub linespace sub moveto\n");
    fprintf(fp, "} def\n");
  }
  else  {
    fprintf(fp, "/makeheader {");
    fprintf(fp, " pop pop pop leftmar toppos linespace sub moveto } def\n");
  }
  fprintf(fp, "%%%%EndProlog\n\n");

  if (i == argc)
    from_stdin = 1;

  masterpagenum = 0;

  /* Print all of the files. */
  for (; i < argc || from_stdin; i++)  {
    if (from_stdin)  {
      /* Input coming from stdin */
      infp = stdin;
      timeval = time(0);
      if (!new_name)
	strcpy(name, "stdin");
    }
    else  {
      if (!(infp = fopen(argv[i], "r")))  {
	fprintf(stderr, "%s: File open failed: %s\n", argv[0], argv[i]);
	continue;
      }
      if (!new_name)  {
	s = rindex(argv[i], '/');
	if (s)
	  strcpy(name, s+1);
	else
	  strcpy(name, argv[i]);
      }
      stat(argv[i], &statbuf);
      timeval = statbuf.st_mtime;
    }

    tbuf = localtime(&timeval);
    sprintf(date, "%s, %s %d, %d %02d:%02d:%02d", days[tbuf->tm_wday],
	    months[tbuf->tm_mon], tbuf->tm_mday, tbuf->tm_year + 1900,
	    tbuf->tm_hour, tbuf->tm_min, tbuf->tm_sec);
    yyin = infp;

    /** Decide which lex routine to use */
    if (forced_type)
      type = forced_type;
    else  {
      if (from_stdin)
	type = PLAIN_FILE_TYPE;
      else  {
	/* Look at the file name to get the type */
	dot = rindex(argv[i], '.');
	type = PLAIN_FILE_TYPE;
	if (dot)  {
	  if (strcmp(dot, ".clu") == 0)
	    type = CLU_FILE_TYPE;
	  else if (strcmp(dot, ".c") == 0 || strcmp(dot, ".h") == 0)
	    type = C_FILE_TYPE;
	  else if (strcmp(dot, ".arg") == 0)
	    type = ARGUS_FILE_TYPE;
	  else if (strcmp(dot, ".lisp") == 0 || strcmp(dot, ".lsp") == 0)
	    type = LISP_FILE_TYPE;
	  else if (strcmp(dot, ".C") == 0   || strcmp(dot, ".cc") == 0  ||
		   strcmp(dot, ".c++") == 0 || strcmp(dot, ".cpp") == 0 ||
		   strcmp(dot, ".cxx") == 0 || strcmp(dot, ".hpp") == 0 ||
		   strcmp(dot, ".hxx") == 0 || strcmp(dot, ".h++") == 0)
	    type = CXX_FILE_TYPE;
	}
      }
    }

    /* lex that baby.
       The lex file uses the type variable in order to do the right
       thing for each type of file. */
    starting = 1;
    yylex();

    if (infp != stdin)
      fclose(infp);

    if (from_stdin)
      break;
  }

  fprintf(fp, "\n%%%%Trailer\n");
  fprintf(fp, "%%%%Pages: %d\n", masterpagenum);

  if (fp != stdout)
    fclose(fp);
}
