/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  show.c						   */
/*        FUNKTIONEN  show(), more(), richtext(), quoted_printable()	   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  08.06.1992					   */
/***************************************************************************/

#include <stdio.h>
#include <string.h>

#include "mbox.h"


static int show_more;
static FILE *page;
static char show_tmp[STRING];
static int seite;


extern char headinfo[STRING];

static int morechen;


/* Globals fuer RTF (Richtext Format): */

static int RTFcomment; 
static int RTFcenter;
static int RTFrightflush;
static int RTFheading;

static char ENCODING[STRING];

static int QPkeys;

char *richtext();
char *quoted_printable();


/***************************************************************************/
/*      FUNKTION  show()				        	   */
/*  BESCHREIBUNG  Zeigt den Inhalt einer Datei an.		 	   */
/*     PARAMETER  fname    = Dateiname                                     */
/*		  maxlines = mehr Zeilen auf keinen Fall ausgeben          */
/*		  mode     = '> 99'  Ueberschrift einrechnen	           */
/*			       '= 99'  Reset (alle Parameter von "show")   */
/*			       '=  0'  Kontinuierlich ausgeben             */
/*     RUECKGABE  -1  =  Datei nicht gefunden                              */
/***************************************************************************/

#define LLL 80

int show(fname, maxlines, mode)
char fname[];
int maxlines;
int mode;
{
  FILE *fp;

  char s[LONGSTRING];
  char o[LONGSTRING];
  char t[STRING];
  char CONTENT[STRING];
  int c;
  int ml;
  int ret_status = 0;
  int maxi = MAX_SCR_LINES;
  int swing = 0;
  int sl, ok;
 
  int HEADER_lines = 0;
  int HEADER_path = 0;
  int HEADER_double = 0;

  int FACE = 0;


  if (mode > 99) {		/* HEADLINE */
	mode -= 100;
	maxi -= 2;
	swing = 2;
	morechen = 1;
	seite = 1;
  }
  if (mode == 99) {		/* RESET */
	show_more = 0;
	seite = 1;
	return 0;
  }
  fp = fopen(fname, "r");
  if (fp == NULL) {
	return -1;
  }
  ml = 0;
  morechen = 0;

  CONTENT[0] = '\0';
  ENCODING[0] = '\0';
 
  RTFcomment    = 0;
  RTFcenter     = 0;
  RTFrightflush = 0; 
  RTFheading    = 0;

  QPkeys 	= 0;

  sprintf(show_tmp, "%s/show%d", TMP, getpid());
  page = fopen(show_tmp, "w");

  if (mode != 2)
	show_more = 0;
  else
	morechen = show_more;

  if (show_more > maxi) show_more = 0;


  while ((ml < maxlines) && (fgets(s, LONGSTRING, fp) != NULL)) {

	if(SHORT_HEADER){
		if((strcomp("Path: ", s) == 0) || (strcomp("Newsgroups: ", s) == 0)){
			HEADER_path++;
			continue;
		}

		if((HEADER_path != 0) && (HEADER_lines == 0)){

			if(strcomp("From: ", s) == 0){
				printf("%s %s", GBL01_MSG, strcopy(s, 6, strlen(s)));
				fprintf(fp, "%s %s", GBL01_MSG, strcopy(s, 6, strlen(s)));
				morechen++;
			}
			if(strcomp("Subject: ", s) == 0){
				printf("%s %s", GBL03_MSG, strcopy(s, 9, strlen(s)));
				fprintf(fp, "%s %s", GBL03_MSG, strcopy(s, 9, strlen(s)));
				morechen++;
			}		
			if(strcomp("Date: ", s) == 0){
				printf("%s %s\n", GBL02_MSG, strcopy(s, 6, strlen(s)));
				fprintf(fp, "%s %s\n", GBL02_MSG, strcopy(s, 6, strlen(s)));
				morechen++;
			}
			if(strlen(s) < 3){
				HEADER_lines++;
				morechen++;
			}
			continue;
 		}	
	}
	else{
		if(HEADER_lines == 0){
			sprintf(t, "%s %s", GBL01_MSG, X_MAIL_DEMON);
			if(strcomp(t, s) == 0){
				do{
					fgets(s, 250, fp);
				}while(strcomp("From", s) != 0);
				HEADER_double++;
				ansi("md");
			}
			if((strcomp("Path:", s) == 0) || (strcomp("Newsgroups:", s) == 0) || (strcomp(GBL01_MSG, s) == 0)){
				ansi("md");
				HEADER_double++;
			}	
			if(strlen(s) < 3){
				HEADER_lines++;
				HEADER_double = 0;
				ansi("me");
			}			
		}
	}

	if(strcomp("Content-Type:", s) == 0){
		strcpy(CONTENT, (char *) strcopy(s, 14, 80));
		if(strcomp("text/richtext", CONTENT) != 0) /* RTF etc. */
			 CONTENT[0] = '\0';
	}
	if(strcomp("Content-Transfer-Encoding:", s) == 0){
		strcpy(ENCODING, (char *) strcopy(s, 27, 80));
				
	}
	if(strcomp("Content-", s) == 0){
		if((HEADER_lines != 0) || (ml < 2)) s[0] = '\0'; /* :-)) */
	}
        if(strcomp("X-Face:", s) == 0){
		if(FACE == 0){
			FACE++;
		}
	}
	
	sl = length(s);
	while(sl > LLL){
		strcpy(o, (char *) s);
		sl = LLL; ok = 0;
		while((sl > 0) && (ok == 0)){
			if(s[sl] < 48){
				ok = sl;
			}
			sl--;
		}
		s[ok] = '\0';
		morechen++;
#ifdef _MULTIMEDIA
		if(strcomp("Quoted-Printable", ENCODING) == 0){
			strcpy(s, (char *) quoted_printable(s));
		}
		if(CONTENT[0] == '\0'){
			printf("%s\n", s);
		}
		else{
			strcpy(s, (char *) richtext(s));
			fprintf(page, "%s", s);
		}
#else
		printf("%s\n", s);
		fprintf(page, "%s\n", s);
#endif
		strcpy(s, (char *)bigcopy(o, ok, length(o)));
		sl = length(s);
		if(ok == 0){
			sl = LLL;
			printf("[SysBug \"show.c\"]");
		}
		if(s[0] == '\n') s[0] = '\0';
	}
	if(s[strlen(s)] == '\n') s[strlen(s)] == '\0'; 
#ifdef _MULTIMEDIA
	if(strcomp("Quoted-Printable", ENCODING) == 0){
		strcpy(s, (char *) quoted_printable(s));
	}
	if(CONTENT[0] == '\0'){
		printf("%s", s);
	}
	else{
		strcpy(s, (char *) richtext(s));
	}
#else
	printf("%s", s);
#endif
	fputs(s, page);
	ml++;
	morechen++;
	if ((morechen >= maxi) && (mode > 0)) {
		morechen = 0;
		maxi += swing;
		swing = 0;
		fclose(page);
		ret_status = more();
		if (ret_status != 0) {
			ml = maxlines + 9999;
		}
		else {
			page = fopen(show_tmp, "w");
			if(HEADER_double != 0){
				ansi( "md" );
			}
		}
	}
  }
  fclose(fp);

  show_more = morechen;

  if (page != NULL) fclose(page);
  unlink(show_tmp);

  if(FACE != 0){
	faces( fname );
  }

  return (int) ret_status;
}



/***************************************************************************/
/*      FUNKTION  more()						   */
/*  BESCHREIBUNG  Erfragen ob weitergelesen werden soll, oder nicht.       */
/*     PARAMETER  keine  	                                           */
/*     RUECKGABE  0  =  weiterlesen                                        */
/*		 -1  =  abbrechen				           */
/***************************************************************************/

int more()
{
  char s[255];
  char c;
  int ok = 0;

FIRST_TRY:

  ansi("mr");
  printf("                                                                               ");
  printf("%c[%s] (?) > ", CR, SHO04_MSG);
  ansi("me");

SECOND_TRY:

  c = getint();

  if (c == '?') {
	ansi("mr");
	clearline();
	printf("%c%s > ", CR, SHO05_MSG);
	ansi("me");
	goto SECOND_TRY;
  }
  if (c > 96) c -= 32;

  if ((c == DEL) ||
      (c == CTRL_D) ||
      (c == CTRL_X) ||
      (c == SHO06_MSG) ||
      (c == SHO07_MSG))
	ok = -1;

  if ((c == SHO08_MSG) || (c == SHO09_MSG)) ok = 1;

  if (c == SHO10_MSG) {
	ansi("cl");
	ansi("mr");
	printf("                                                                               ");
	printf("%c%s\n", CR, SHO11_MSG);
	ansi("me");	
	page = fopen(show_tmp, "r");
	if (page != NULL) {
		while (fgets(s, 250, page) != NULL) {
			printf("%s", s);
		}
		fclose(page);
	}
	goto FIRST_TRY;
  }
 
  if(ok != 1){	
	  if (USER.more == 3) {
		clearline();
	  }
	  else {
		if(USER.more != 0){
			ansi("cl");
			seite++;
			sprintf(s, "%s^-  [%s %d]", headinfo, SHO12_MSG, seite);
			headline(s);
		}
		else printf("\n\n");
	  }
  }
  else{	
	clearline();
  }

  return (int) ok;
}



/***************************************************************************/
/*      FUNKTION  richtext()						   */
/*  BESCHREIBUNG  RTF ... die Zukunft kommt bestimmt :-)))		   */
/*     PARAMETER  Zeile im RT-Format                                       */
/*     RUECKGABE  Zeile im ANSI-Format					   */
/***************************************************************************/

char *richtext( s )
char s[];
{
  char rt[STRING];
  char line[LONGSTRING];
  char space[LONGSTRING];
  int i = 0, j;
  int l = 0;
  int not;
  int keys = 0;

  while(s[i] != '\0'){
	if(s[i] != '<'){
		if(RTFcomment == 0){
			/* RTF-Konform:
			if(s[i] == '\n')
				line[l] = ' ';
			else
				line[l] = s[i];
			NICHT RTF-Konform: */

			line[l] = s[i];
			l++;
			keys++;
		}
	}
	else{
		line[l] = '\0';
		not = 0;
		i++;
		j = i;
		while((s[j] != '>') && (s[j] != '\0')){
			if(s[j] == '/'){
				i++;
				not++;
			}
			j++;
		}
		strcpy(rt, (char *) strcopy(s, i, (j-1)));

		if(not == 0){
			if(strcomp("Bold",       rt) == 0) 
				strcat( line, (char *) termansi( "md" ));
			if(strcomp("Italic",     rt) == 0) 
				strcat( line, (char *) termansi( "mr" ));
			if(strcomp("Bigger",     rt) == 0) 
				strcat( line, (char *) termansi( "md" ));
			if(strcomp("Underline",  rt) == 0) 
				strcat( line, (char *) termansi( "mr" ));
			if(strcomp("Paragraph",  rt) == 0){
				strcat( line, "\n\n");
				morechen += 2;
			}
			if(strcomp("Comment",    rt) == 0)
				RTFcomment++;
			if(strcomp("Center",     rt) == 0)
				RTFcenter++;
			if(strcomp("FlushRight", rt) == 0)
				RTFrightflush++;
			if(strcomp("Heading",   rt) == 0){
				RTFheading++;
				strcat( line, (char *) termansi( "md" ));
			}
		}
		else{
			if(strcomp("Bold",       rt) == 0) 
				strcat( line, (char *) termansi( "me" ));
			if(strcomp("Italic",     rt) == 0) 
				strcat( line, (char *) termansi( "me" ));
			if(strcomp("Bigger",     rt) == 0) 
				strcat( line, (char *) termansi( "me" ));
			if(strcomp("Underline",  rt) == 0) 
				strcat( line, (char *) termansi( "me" ));
			if(strcomp("Paragraph",  rt) == 0){
				strcat( line, "\n\n");
				morechen += 2;
			}
			if(strcomp("Comment",    rt) == 0)
				RTFcomment = 0;
			if(strcomp("Center",     rt) == 0)
				RTFcenter = 9999;
			if(strcomp("FlushRight", rt) == 0)
				RTFrightflush = 9999;
			if(strcomp("Heading",   rt) == 0){
				RTFheading = 9999;
				strcat( line, (char *) termansi( "me" ));
			}
		}

		if(strcomp("LT", rt) == 0) 
			strcat( line, (char *) "<" );

		/* NICHT RTF-Konform:
		if(strcomp("NL", rt) == 0){ 
			strcat( line, (char *)  "\n" );
			morechen++;
		}
		*/

		if(strcomp("NP", rt) == 0) 
			strcat( line, (char *) "\f" );
		if(RTFcomment == 0){
			l = strlen(line);
		}
		i = j;
	}
	i++;
  }
  line[l] = '\0';
  strcpy(space, (char *) "                                                                              ");	

  if((RTFcenter != 0) || (RTFheading != 0)){
	i = (79 - keys) / 2; 
	if(i <  0) i = 0;
	if(i > 79) i = 0;
	space[i] = '\0';
	strcat(space, (char *) line);
	strcpy(line, (char *) space);
  }
  if(RTFrightflush != 0){
	i = 79 - keys;
	space[i] = '\0';
	strcat(space, (char *) line);
	strcpy(line, (char *) space);
  }
  
  printf("%s", line);

  if(RTFcenter     == 9999) RTFcenter = 0;
  if(RTFrightflush == 9999) RTFrightflush = 0;
  if(RTFheading    == 9999) RTFheading = 0;

  return (char *) line;
}




/***************************************************************************/
/*      FUNKTION  quoted_printable()					   */
/*  BESCHREIBUNG  Transfer-Encoding: Regel #1 bis #5			   */
/*     PARAMETER  Zeile im RT-Format                                       */
/*     RUECKGABE  Decodierte Zeile					   */
/***************************************************************************/

char *quoted_printable( s )
char s[];
{
  char line[LONGSTRING];
  char t[STRING];
  int i = 0, l = 0, p = 0;

  while(s[i] != '\0'){
	if(s[i] == '='){
		if(s[(i+1)] == '\n'){
			i++;
		}
		else{
			/*
			sprintf(t, "0x%s", strcopy(s, (i+1), (i+2)));
			line[l] = atoi(t);
			l++;
			*/
			i += 2;
		}
	}
	else{
		line[l] = s[i];
		l++;
		QPkeys++;
		if(s[i] == '\n') QPkeys = 0;
	}

	if(QPkeys >= 75){
		p = l;
		while((line[p] != ' ') && (p > 0)){
			p--;
		}
		line[p] = '\n';
		QPkeys = 0;
	}
	i++;
  }
  line[l] = '\0';

  return (char *) line;
}
