/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  portinfo.c					   */
/*        FUNKTIONEN  port(), show_level(), userliste(), finger()	   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  11.06.1992					   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <utmp.h>
#include <time.h>

#include <string.h>

#include "mbox.h"




/***************************************************************************/
/*      FUNKTION  port()						   */
/*  BESCHREIBUNG  Anzeigen was die Mbox- und die SH-User z. Zt. anstellen. */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void port(arg)
char arg[];
{
  FILE *fp;
  FILE *ff;
  FILE *pp;
  int fd;
  char s[STRING];
  char t[STRING];
  char ks[STRING];
  char ls[STRING];
  char tmp[STRING];
  char ex[255];
  char terms[MAX_TERMINALS][STRING];
  int termc = 0;
  int a, b, k, l;
  struct utmp US;
  struct tm *tmt;
  long ltime;
  

  if(arg[0] != '-'){
	headline( POR01_MSG );
  }
  else printf("\n\n");

  printf("%s\n", POR02_MSG);
  printf("===============================================================================\n");

  printf("%s ", POR03_MSG);

  maybe_locked(WHO, "r");
  fp = fopen(WHO, "r");
  if (fp == NULL) {
	nerror("portinfo.c", 56, "port", "Datei-Lesefehler", WHO);
  }
  while (fgets(s, 80, fp) != NULL) {
	printf(".");
	if(s[0] > 32){
		strcpy(t, (char *) strcopy(s, 9, 37));
		sprintf(terms[termc], "%s  ", t);
		strcpy(t, (char *) strcopy(s, 37, 80));
		strcat(terms[termc], t);
		strcat(terms[termc], "                 ");
		terms[termc][56] = '\0';
		sprintf(t, "%s", (char *) strcopy(s, 37, 49));

		sprintf(s, "%s/etc/%s.", HOME, (char *) stripped(t));
		ff = fopen(s, "r");
		if (ff == NULL) {
			continue;
		}
		fgets(s, 80, ff);
		s[23] = '\0';
		fclose(ff);
		strcat(terms[termc], s);
		strcat(terms[termc], "\n");
		termc++;
	}
  }
  fclose(fp);

  sprintf(tmp, "%s/%dps", TMP, getpid());
  sprintf(s, "ps -a > %s", tmp);
  system( s );

#ifdef _SYS7
  maybe_locked(UTMP, "r");
  fd = open(UTMP, O_RDONLY);
#else
  maybe_locked(UTMP_FILE, "r");
  fd = open(UTMP_FILE, O_RDONLY);
#endif

  if (fd == -1) {

#ifdef _SYS7
	nerror("portinfo.c", 83, "port", "Datei-Lesefehler", UTMP);
#else
	nerror("portinfo.c", 83, "port", "Datei-Lesefehler", UTMP_FILE);
#endif

  }
  while (read(fd, &US, sizeof(US)) == sizeof(US)) {

	printf(".");
	t[0] = '\0';
	strcat(t, "[$] -\n");

	if (US.ut_type == USER_PROCESS) {
		terms[termc][0] = '\0';
		sprintf(ex, "%.8s [SH-Account]                                                  ",
			US.ut_user);
		ex[33] = '\0';
		strcat(terms[termc], ex);

		sprintf(ex, "%8.8s   ",
			US.ut_line);
		strcat(terms[termc], ex);

		ltime = US.ut_time;
		tmt = localtime(&ltime);
		sprintf(ex, "%02.2d:%02.2d   ",
			tmt->tm_hour, tmt->tm_min);
		strcat(terms[termc], ex);

		l = atoi(strcopy(US.ut_line, 3, 6));

		pp = fopen(tmp, "r");
		if (pp == NULL) {
			nerror("portinfo.c", 113, "port", tmp, "???");
		}
		while (fgets(s, 80, pp) != NULL) {
			k = atoi((char *) strcopy(s, 8, 10));
			if ((k == l) && (s[17] != '-')) {
				t[0] = '\0';
				strcat(t, "[$] ");
				strcat(t, (char *) strcopy(s, 17, 40));
				s[0] = '\0';
				strcat(s, t);
				t[0] = '\0';
				strcat(t, (char *) stripped(s));
				t[27] = '\0';
				strcat(t, "\n");
			}
		}
		fclose(pp);

		strcat(terms[termc], t);
		termc++;
	}
  }
  close(fd);

  unlink(tmp);

  printf("%c", CR);

  for (a = 0; a < termc; a++) {
	for (b = 0; b < termc; b++) {
		sprintf(ks, "%s", (char *) strcopy(terms[a], 34, 40));
		sprintf(ls, "%s", (char *) strcopy(terms[b], 34, 40));
		if((strcomp(ks, ls) == 0) && (a != b)){
			if (terms[a][53] == '$') terms[a][0] = '*';
			if (terms[b][53] == '$') terms[b][0] = '*';
		}
		sprintf(s, "%d", ks); k = atoi(s);
		sprintf(s, "%d", ls); l = atoi(s);
		if (k < l) {
			s[0] = '\0';
			strcat(s, terms[a]);
			terms[a][0] = '\0';
			strcat(terms[a], terms[b]);
			terms[b][0] = '\0';
			strcat(terms[b], s);
		}
	}
  }


  for (a = 0; a < termc; a++) {
	if (terms[a][0] != '*'){
		if(terms[a][53] != '$') ansi( "md" );
		printf("%s", terms[a]);
		if(terms[a][53] != '$') ansi( "me" );
	}
  }

  printf("\n");
}





/***************************************************************************/
/*      FUNKTION  show_level()						   */
/*  BESCHREIBUNG  Zuweisung der Userlevel anzeigen.			   */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void show_level()
{
  headline( POR04_MSG );
  printf("\n");

  printf("%s\n", POR05_MSG);
  printf("-----------------------------------------\n");
  printf("%s (%d)\n", POR06_MSG, GUEST_LEV);
  printf("%s (%d)\n", POR07_MSG, WRITE_IN_LEV);
  printf("%s (%d)\n", POR08_MSG, MAILOUT_LEV);
  printf("%s (%d)\n", POR09_MSG, WRITE_EX_LEV);
  printf("%s (%d)\n", POR10_MSG, WRITE_INTERNAT);
  printf("%s (%d)\n", POR11_MSG, PD_D_LEV);
  printf("%s (%d)\n", POR12_MSG, PD_U_LEV);
  printf("%s (%d)\n", POR13_MSG, EXE_LEV);
  printf("%s (%d)\n", POR14_MSG, ADMIN_LEV);

  printf("\n%s (%d), %s !\n\n", POR15_MSG, USER.level, USER.name);

}



/***************************************************************************/
/*      FUNKTION  userliste()						   */
/*  BESCHREIBUNG  Verschieden Formen der Userliste ausgeben.		   */
/*     PARAMETER  arg  =  ''   =  nur Username und ID                      */
/*			  '*'  =  Name, letzter Anruf etc.                 */
/*			  '#'  =  Name, Up- / Downloads			   */
/*			  '%'  =  Gebuehren-Stand			   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void userliste(arg)
char arg[];
{
  FILE *fp;
  int fd;
  struct userdaten LOOSER;
  char s[STRING];
  char u[(STRING*2)];
  char tmp[STRING];
  char t[STRING];
  int i = 0, l, z;
  int mode = 0;
  int totalusr = 0;
  int totalact = 0;
  int totalgas = 0;

  char c;

  if (arg[0] == '*') mode = 1;
  if ((arg[0] == '#') && (USER.level >= ADMIN_LEV)) mode = 2;
  if ((arg[0] == '%') && (USER.level >= ADMIN_LEV)) mode = 3;
  if ((arg[0] > 47) && (mode == 0)){
	finger(arg);
	return;
  }
 
  headline( POR15aMSG );

  show(UDBASE, 99, 99); /* RESET */

  if (mode == 1) {
	printf("%s\n", POR16_MSG);	
	printf("===============================================================================\n");
	printf("%s", POR17_MSG);
  }
  if (mode == 2) {
	printf("%s\n", POR18_MSG);	
	printf("===============================================================================\n");
	printf("%s", POR17_MSG);
  }
  if (mode == 3) {
        printf("%s\n", POR18aMSG);	
	printf("===============================================================================\n");
	printf("%s", POR17_MSG);
  }

  sprintf(tmp, "%s/%d", TMP, getpid());
  fp = fopen(tmp, "w");
  if (fp == NULL) {
	nerror("portinfo.c", 231, "userliste", "Datei-Schreibfehler", tmp);
  }
  maybe_locked(UDBASE, "r");
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("admin.c", 254, "userliste", "Datei-Lesefehler", UDBASE);
  }
  while (read(fd, &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) {
	if (mode == 0) {
		sprintf(u, "%s", LOOSER.name);
		sprintf(s, " (%d) ", LOOSER.id);		
		u[26 - strlen(s)] = '\0';
		strcat(u, s); strcat(u, "                                ");	
 		u[26] = '\0';
		fprintf(fp, "%s", u);
		i++;
		if (i == 3) {
			i = 0;
			fprintf(fp, "\n");
		}
	}
	if (mode == 1) {
		sprintf(s, "%s", "   ");
		if ((LOOSER.elapsed / 60) > 2) {
			if (LOOSER.wohnort[0] < 48) {
				if (strcomp(GUEST, LOOSER.name) != 0)
					sprintf(s, "%s", "<?>");
			}
		}
		else {
			sprintf(s, "%s", "{-}");
		}
		fprintf(fp, "%-30.30s  %10s %s%6.d   %6.ld\"  %5.d%10.10s\n",
			LOOSER.name, LOOSER.lastlog, s, LOOSER.seq, (LOOSER.elapsed / 60), LOOSER.level, LOOSER.sh_name);

	}
	if (mode == 2) {
		fprintf(fp, "%-30.30s  %8.d kB  %10.d kB %8.d\"\n",
			LOOSER.name, LOOSER.upratio, LOOSER.downratio, (LOOSER.elapsed / 60));
	}
        if (mode == 3) {
		if(LOOSER.level >= WRITE_INTERNAT){
			if(LOOSER.account[0] == '\0') strcpy(LOOSER.account, "00.00.0000");
			strcpy(s, LOOSER.account);
			s[10] = '\0';
			c = ' ';
			strcpy(t, (char *) strcopy(LOOSER.account, 11, 16));
			z = atoi(t);			
			fprintf(fp, "%-30.30s  %5.d   %c %s   [%3d.%02d DM]\n",  
				LOOSER.name, LOOSER.id, c, s, fix(z), flt(z));
		}
        }
	totalusr++;
	sprintf(s, "%s", (char *) mydate( 0 )); 
	if((strcomp(s, LOOSER.lastlog) < 3) && (LOOSER.seq > 10)) totalact++;
	if(strcomp(GUEST, LOOSER.name) == 0) totalgas = LOOSER.seq;
  }
  close(fd);

  fclose(fp);

  if (mode != 0) {
	printf("%c", CR);
	sprintf(s, "sort -d -o %s %s", tmp, tmp);
	system(s);
	show(tmp, 9999, USER.more + 100);
	if (mode == 1) {
		printf("\n%s\n%s", POR19_MSG, POR20_MSG);
	}
  }
  else{
	show(tmp, 9999, USER.more);
  }
  if(mode == 0){
	printf("\n\n%s %d %s %d %s", POR21_MSG, totalusr, POR22_MSG, totalact, POR23_MSG); 
	printf("\n%s %d %s", POR24_MSG, totalgas, POR25_MSG);
  }
  printf("\n");
  unlink(tmp);
}




/***************************************************************************/
/*      FUNKTION  finger()						   */
/*  BESCHREIBUNG  Informationen ueber einen Teilnehmer anzeigen.	   */
/*     PARAMETER  arg  =  User-Name/User-Id des Teilnehmers                */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void finger(arg)
char arg[];
{
  int fd;
  struct userdaten DUMMY, LOOSER;
  char s[STRING];
  char t[STRING];
  long ll = -1L;
  size_t dummy = sizeof(DUMMY);
  char c;
  char ex[LONGSTRING];
  int i, ok, a, b;
  int uid = -1;
  char name[STRING];
  char domain[STRING];	  


  FILE *fp;

  
  if ((arg[0] > 47) && (arg[0] < 58)) {
	uid = atoi(arg);
  }
  else{
	a = 0; b = 0;
	i = 0;
	while(arg[i] != '\0'){	
		if(arg[i] == '!') a = i;
		if(arg[i] == '@') b = i;
		i++;
	}
	if((a != 0) && (b == 0)){
		if(a != 0){
			strcpy(name, (char *) strcopy(arg, (a+1), length(arg)));
			strcpy(domain, (char *) strcopy(arg, 0, (a-1)));
		}
		else{
			strcpy(name, (char *) strcopy(arg, 0, (b-1)));
			strcpy(domain, (char *) strcopy(arg, (b+1), length(arg)));
		}
		strcpy(t, USER.name);
		i = 0;
		while(t[i] != '\0'){
			if(t[i] == ' ') t[i] = '.';
			i++;
		}
		chdir( "/" );
		sprintf(s, "%s %s!%s!\"finger %s\" \\| mail %s@%s", UUX, SMARTHOST, domain, name, t, UUCPID);
		/*
		printf("\n\n%s\n\n", s);
		*/
		system( s );
		chdir( HOME );
		printf("\n\n%s \"%s\",\n%s \"%s\" %s.", POR25aMSG, name, POR25bMSG, domain, POR25cMSG);
		ansi( "md" );
		printf("\n%s\n", POR26_MSG);
		ansi( "me" );
		return;
	}
	else{
		if(b != 0){
			ansi( "md" );
			printf(" <- %s\n\n", POR26aMSG);
			ansi( "me" );
			return;
		}
	}
  }

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("admin.c", 324, "aendern", "Datei-Lesefehler", UDBASE);
  }
  while (read(fd, &DUMMY, dummy) == dummy) {
	if (uid == DUMMY.id) {
		ll = lseek(fd, 0L, SEEK_CUR) - dummy;
	} 
	else{
		if ((strcomp(arg, DUMMY.name) == 0) ||
		    (strcomp(arg, DUMMY.nick) == 0) ||
		    (strcomp(arg, DUMMY.sh_name) == 0)) {
			ll = lseek(fd, 0L, SEEK_CUR) - dummy;
		}
	}
  }
  lseek(fd, ll, SEEK_SET);
  read(fd, &LOOSER, sizeof(LOOSER));
  close(fd);
  mbunlock(UDBASE);

  if (ll == -1L) {
	ansi( "md" );
	printf(" <- %s\n\n", POR27_MSG);
	ansi( "me" );
	return;
  }

  sprintf(s, " %s: %s ", POR28_MSG, arg);
  headline( s );

  ansi( "md" );
  printf("\n%s ", POR29_MSG);
  ansi( "me" );
  printf("%d\n", LOOSER.id);

  ansi( "md" );
  printf("%s ", POR30_MSG);
  ansi( "me");
  printf("%s\n", LOOSER.name);

  if(LOOSER.sh_name[0] != '\0'){
	ansi( "md" );
	printf("%s ", POR31_MSG);
	ansi( "me" );
	printf("%s\n", LOOSER.sh_name);
  }

  if(LOOSER.nick[0] != '\0'){
	ansi( "md" );
  	printf("%s ", POR32_MSG);
	ansi( "me" );
	printf("%s\n", LOOSER.nick);
  }

  ansi( "md" );
  printf("%s ", POR33_MSG);
  ansi( "me" );
  strcpy(s, LOOSER.name);
  i = 0;
  while(s[i] != '\0'){
	if(s[i] == ' ') s[i] = '.';
	i++;
  }
  if(LOOSER.level >= WRITE_INTERNAT)
	printf("%s@%s\n", s, UUCPID2);
  else
	printf("%s@%s\n", s, UUCPID1);

  printf("\n"); ok = 0;

  if(USER.level >= WRITE_EX_LEV){
	if(LOOSER.wohnort[0] != '\0'){
		ok++;
		ansi( "md" );
		printf("%s ", POR34_MSG);
		ansi( "me" );
		printf("%s\n", LOOSER.wohnort);
	}
  }

  if(USER.level >= ADMIN_LEV){
	if(LOOSER.strasse[0] != '\0'){
		ok++;
		ansi( "md" );
		printf("%s ", POR35_MSG);
		ansi( "me" );
		printf("%s\n", LOOSER.strasse);
	}
	if(LOOSER.telefon1[0] != '\0'){
		ok++;
		ansi( "md" ); 
		printf("%s ", POR36_MSG);
		ansi( "me" );
		printf("%s", LOOSER.telefon1);

		if(LOOSER.telefon2[0] != '\0'){
			printf(" // %s\n", LOOSER.telefon2);
		}
		else{
			printf("\n");
		}
	}

	if(ok != 0) printf("\n"); 
	ok = 0;

	if(LOOSER.geburtsdatum[0] != '\0'){
		ok++;
		ansi( "md" );
		printf("%s ", POR37_MSG);
		ansi( "me" );
		printf("%s\n", LOOSER.geburtsdatum);
	}
  }

  if(ok != 0) printf("\n");

  if(USER.level >= WRITE_EX_LEV){
	ansi( "md" );
	printf("%s ", POR38_MSG);
	ansi( "me" );
	printf("%d\n", LOOSER.seq);
  	ansi( "md" );
	printf("%s ", POR39_MSG);
	ansi( "me" );
	printf("%s // %s\n", LOOSER.lastlog, (char *) timereconv(LOOSER.lasttime));
  }

  ansi( "md" );
  printf("%s ", POR45_MSG);
  ansi( "me" );
 
  b = 0;
  sprintf(s, "%s/usr/%d/INDEX", HOME, LOOSER.id);  
	
  fp = fopen(s, "r");
  if (fp == NULL) {
	nerror("intro.c", 291, "intro", "Datei-Lesefehler", s);
  }
  while (fgets(ex, 200, fp) != NULL){
	if(ex[0] < 65) b++;
  }
  fclose(fp);
  printf("%d\n", b-1);

  if(USER.level >= ADMIN_LEV){
	ansi( "md" );
	printf("%s ", POR40_MSG);
	ansi( "me" );
	printf("%d:%02.2d", (LOOSER.elapsed/3600), (LOOSER.elapsed - (LOOSER.elapsed/3600 * 3600))/360);
	printf(" %s\n", POR41_MSG);
        ansi( "md" );
        printf("%s ", POR41aMSG);
        ansi( "me" );
        printf("%s\n", LOOSER.account);
	ansi( "md" );
	printf("%s ", POR42_MSG);
	ansi( "me" );
	printf("%ld %s\n", LOOSER.upratio, POR43_MSG);
	ansi( "md" );
	printf("%s ", POR44_MSG);
	ansi( "me" );
	printf("%ld %s\n", LOOSER.downratio, POR43_MSG);
  }

  printf("\n");
}

