/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  nerror.c						   */
/*        FUNKTIONEN  nerror						   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  16.11.1991					   */
/***************************************************************************/

#include <stdio.h>
#include <setjmp.h>

#include "mbox.h"


extern jmp_buf jmpenv;


/***************************************************************************/
/*      FUNKTION  nerror()						   */
/*  BESCHREIBUNG  Zeigt Systemfehler (Dateien koennen nicht gefunden o.    */
/*		  geoeffnet werden, etc.) an. Anschliessend wird die       */
/*		  Befehlseingabe aufgerufen.                               */
/*			                                                   */
/*		  ACHTUNG: Nach "nerror()" laeuft die MBox zwar weiter,    */
/*		  aber beim Terminieren wird ein "core" ausgegeben.        */
/*     PARAMETER  file     = Datei in der der Fehler aufgetreten ist	   */
/*		  line     = Zeile in der Datei                            */
/*		  function = Funktion in der Datei                         */
/*		  descr    = Fehlerbeschreibung	                           */
/*		  er       = Datei/Variable                                */
/*     RUECKGABE  keine 						   */
/***************************************************************************/

void nerror(file, line, function, descr, er)
char file[];
int line;
char function[], descr[], er[];
{
  char s[80];

  ansi("md");
  printf("%c%s ", CR, NER01_MSG);
  ansi("me");

  printf("%s (%s) - %s \"%s\"\n", function, file, descr, er);

  sprintf(s, "[%s] %s, %d\n***** %s, %s, %s ... %s !!!",
	NER02_MSG, file, line, function, descr, er, NER03_MSG);

  control(s, 99);
  control(s, 3);

  longjmp(jmpenv, 1);
}

