/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  mail.c						   */
/*        FUNKTIONEN  fetch_receipy(), brief()				   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  03.06.1992					   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>

#include "mbox.h"

static int fetch_local;
static char fetch_subj[STRING];


/***************************************************************************/
/*      FUNKTION  fetch_receipy()					   */
/*  BESCHREIBUNG  Im REPLY-Modus wird die Adresse des Empfaengers aus      */
/*	          dessen Mail gefiltert.                                   */
/*     PARAMETER  REP  =  Datei mit der Mail des zukuenftigen Empfaengers  */
/*     RUECKGABE  Adresse des Empfaengers                                  */
/***************************************************************************/

char *fetch_reciepy(REP)
char REP[];
{
  FILE *fp;
  char s[STRING];
  char t[STRING];
  char f[STRING];
  int ok = 0, i;
  int beg = 0;
  int bang = 0, at = 0, strange = 0, stranger = 0;

  fetch_local = 0;
  fetch_subj[0] = '\0';

  fp = fopen(REP, "r");
  if (fp == NULL) {
	nerror("mail.c", 31, "fetch_reciepy", "Datei_Lesefehler", REP);
  }
  while (fgets(f, 80, fp) != NULL) {
	if (strcomp("From: ", f) == 0) {
		beg = 6;
		ok = 1;
		strcpy(s, f);
	}
	if (strcomp("From ", f) == 0) { /* local mail */
		beg = 5; 
		ok = 1;
		strcpy(s, f);
	}
	if (strcomp("Reply-To: ", f) == 0) {
		beg = 10;
		ok = 1;
		strcpy(s, f);
	}
	if (strcomp("Subject: ", s) == 0) {
		strcpy(fetch_subj, (char *) strcopy(s, 9, 79));
	}
  }
  fclose(fp);

  if (ok == 0) {
	return (char *) "OOPS";
  }
  i = beg;
  ok = 0;

  while (s[i] != '\0') {
	if (s[i] == '(') ok = i - 2;
	if (s[i] == '<') strange = i + 1;
	if (s[i] == '>') stranger = i - 1;
	i++;
  }
  if (ok == 0) ok = i;
  strcpy(t, (char *) strcopy(s, beg, ok));

  if ((strange != 0) && (stranger != 0)) {
	strcpy(t, (char *) strcopy(s, strange, stranger));
	return (char *) t;
  }
  i = 0;
  while (t[i] != '\0') {
	if (t[i] == '@') at = i;
	if (t[i] == '!') bang = i;
	i++;
  }

  if (at != 0) {
	strcpy(s, (char *) strcopy(t, (at + 1), length(t)));
	if (strcomp(UUCPSITE, s) == 0) {	/* local user */
		fetch_local = 1;
		strcpy(s, (char *) strcopy(t, 0, (at - 1)));
		i = 0;
		while (s[i] != '\0') {
			if (s[i] == '.') s[i] = ' ';
			i++;
		}
		return (char *) s;
	}
  }

  if (beg == 5) {  /* local mail */
	i = 0;
	while((t[i] != '\0') && (t[i] != ' ')) i++;
	t[i] = '\0';
  }

  return (char *) t;
}






/***************************************************************************/
/*      FUNKTION  brief()						   */
/*  BESCHREIBUNG  Eine persoenliche Nachricht wird verschickt. Je nach     */
/*		  Empfaenger-Adresse und Parameter wird die Post ins       */
/*		  MBox-interne Mailsystem geschickt, oder an MAIL          */
/*		  weitergleitet. Die Adresse des Empfaengers wird ent-     */
/*		  weder als Parameter uebergeben, oder aus einer Datei     */
/*		  gefiltert, auf die geantwortet werden soll (REPLY-Mode). */
/*     PARAMETER  arg  =  "~REPLY~"    =  REPLY-Modus aktivieren           */
/*			  Es wird nicht unterschieden zwischen REPLY auf   */
/*			  pers. Mail oder REPLY auf einen NEWS-Artikel.    */
/*			  Die Datei mit der zu beantwortenden MSG liefert  */
/*			  die Routine "lesen()".                           */
/*		  arg  =  "Empfaenger" =  verwertbare Adresse fuer das     */
/*			  interen Mail-System oder MAIL.                   */
/*     RUECKGABE   -1  =  Abbruch                                          */
/***************************************************************************/

int brief(arg)
char arg[];
{
  FILE *fp;
  FILE *ff;
  FILE *ft;
  int fd;
  int i, j;
  int ok;
  struct userdaten LOOSER;

  struct tm *timeptr;
  time_t timer;

  int receiver;
  int mail_id;
  int EX_PM = 0;
  int REPLY = 0;
  int lines = 0;
  int WEITERLEITEN = 0;
  int HOLD = 0;
  int UMLEITUNG = 0;

  char s[STRING];
  char t[STRING];
  char TEP[STRING];
  char REP[STRING];
  char f[STRING];
  char subject[STRING];
  char from[STRING];
  char rec_char[STRING];
  char ex[LONGSTRING];
  char user[STRING];
  char mesg_id[STRING];
  char refs[STRING];
  char date[STRING];
  char c;
  char protokoll;
  char lf;
  char pubdir[STRING];
  char dummy[STRING];
  char username[STRING];
  char reply[STRING];
  char priority[STRING];
  char action[STRING];
  char cc[STRING];
  char bcc[STRING];
  char encrypted[STRING];
  char comments[STRING];
  char keywords[STRING];
  char fortune[STRING];
  char content[STRING];

  char YOUR_SITE[STRING];

  int BINFILE;
  int news_reply = 0;

  struct stat fst;


  i = 0;
  ok = 0;

  mesg_id[0] = '\0';

  if (arg[0] == '\0') {
	ansi("md");
	printf(" %s\n", MAL03_MSG);
	ansi("me");
	return -1;
  }
  EX_PM = 0;


  i = 0;
  strcpy(t, USER.name);
  while (t[i] != '\0') {
	if (t[i] == ' ') t[i] = '.';
	i++;
  }
  strcpy(username, t);
  action[0] = '\0';
  priority[0] = '\0';
  encrypted[0] = '\0';
  keywords[0] = '\0';
  comments[0] = '\0';
  cc[0] = '\0';
  bcc[0] = '\0';
  fortune[0] = '\0';
  content[0] = '\0';

  i = 0;
  while (arg[i] != '\0') {
	if ((arg[i] == '!') || (arg[i] == '@') || (arg[i] == '%')) EX_PM++;
	i++;
  }

  if ((EX_PM > 0) && (USER.level < MAILOUT_LEV)) {
	ansi("md");
	printf("\n\n%s (%d) %s\n", MAL04_MSG, MAILOUT_LEV, MAL05_MSG);
	ansi("me");
	return -1;
  }

  if(arg[length(arg) -1] == '?'){
	arg[length(arg) -1] = '$';
	HOLD++;
  }

  if(arg[length(arg) -1] == '$'){
	WEITERLEITEN++;
	arg[length(arg) -1] = '\0';
	sprintf(TEP, "%s/usr/%d/.lastletter", HOME, USER.id);
	sprintf(t, "%s/usr/%d/.lastsubject", HOME, USER.id);
	fp = fopen( t, "r" );
	if(fp == NULL) {
		return -1; 
	}
	fgets(s, 80, fp);
	fclose(fp);
	if(HOLD == 0){
		sprintf(subject, "%s %s", MAL06_MSG, s);
		UMLEITUNG++;
	}else
		sprintf(subject, "%s", s);
  }

  user[0] = '\0';
  strcat(user, arg);

  if(WEITERLEITEN != 0) goto TRY_AGAIN;

  if (strcomp("~REPLY~", arg) == 0) {
	REPLY++;
	sprintf(REP, "%s/%dRep", TMP, getpid());
	sprintf(TEP, "%s/%dTep", TMP, getpid());
	fp = fopen(REP, "r");
	if (fp == NULL) {
		nerror("mail.c", 278, "brief", "Datei-Lesefehler", REP);
	}
	fgets(s, 80, fp	);			/* HEADER: Autor */

	sprintf(dummy, "%s %s", GBL01_MSG, X_MAIL_DEMON);

	if ((strcomp(GBL01_MSG, s) == 0) && (strcomp(dummy, s) != 0)) {
		strcpy(user, (char *) strcopy(s, (1+strlen(GBL01_MSG)), 80));

		fgets(s, 80, fp);		/* HEADER: Datum */
		fgets(s, 80, fp);		/* HEADER: Betreff */

		strcpy(t, (char *) strcopy(s, (1+strlen(GBL03_MSG)), 80));
		subject[0]= '\0';
		if (strcomp("Re: ", t) != 0) {
			strcpy(subject, "Re: ");
		}
		strcat(subject, (char *) stripped(t));

		fgets(s, 80, fp);	/* HEADER: Leer */
		fgets(s, 80, fp);	/* HEADER: Leer */
	}
	else {		/* UUCP-Header (!MBox) */

		sprintf(subject, MAL07_MSG);
		refs[0] = '\0';
		mesg_id[0] = '\0';

		ok = -1;

		while ((ok < 1) && (fgets(s, 80, fp) != NULL)) {
			if (strcomp("Lines: ", s)      == 0) ok = 1;
			if (strcomp("Date: ",  s)      == 0) {
				strcpy(date, (char *) strcopy(s, 6, 80));
			}
			if (strcomp("Newsgroups: ", s) == 0) news_reply++;
			if (strcomp("Subject: ", s)    == 0) {
				subject[0] = '\0';
				strcpy(t, (char *) strcopy(s, 9, 80));
				if (strcomp("Re: ", t) != 0) {
					sprintf(subject, "%s", "Re: ");
				}
				strcat(subject, (char *) stripped(t));
			}
			if (strcomp("Message-Id: ", s) == 0) {
				strcpy(mesg_id, (char *) strcopy(s, 12, 80));
			}
			if (strcomp("From: ", s) == 0) {
				strcpy(from, (char *) strcopy(s, 6, 80));
				ok = 0;
			}
			if (strcomp("From ", s) == 0) {
				strcpy(from, (char *) strcopy(s, 5, 80));
				ok = 0;
			}
			if (strcomp("References: ", s) == 0) {
				strcpy(refs, (char *) strcopy(s, 12, 80));
			}
			if (strcomp("Comments: ", s) == 0) {
				strcpy(comments, (char *) strcopy(s, 10, 80));
				strcpy(comments, (char *) stripped(comments));	
			}
			if (strcomp("Keywords: ", s) == 0) {
				strcpy(keywords, (char *) strcopy(s, 10, 80));
				strcpy(keywords, (char *) stripped(keywords));
			}
			if (strcomp("Content-Type: ", s) == 0) {
				strcpy(content, (char *) strcopy(s, 14, 80));
				strcpy(content, (char *) stripped(content));
			}

			if ((strlen(s) < 5) && (ok == 0)) ok = 1;
		}
	}

	ff = fopen(TEP, "w");
	while (fgets(s, 80, fp) != NULL) {
		if(s[0] != '\n') fputs("> ", ff);
		fputs(s, ff);
	}
	fputs("", ff);
	fclose(ff);
	fclose(fp);
  }

  TRY_AGAIN:

  if((WEITERLEITEN != 0) && (EX_PM != 0)){
	sprintf(rec_char, "%s", user);
	if(checkdomaintype( rec_char ) != 0) return -1;
	goto ONCE_MORE;
  }

  receiver = 0;

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("mail.c", 216, "brief", "Datei-Lesefehler", UDBASE);
  }
  lseek(fd, 0L, SEEK_SET);
  while ((read(fd, &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) && (receiver == 0)) {
	if ((strcomp(user, LOOSER.name) == 0) ||
	    (strcomp(LOOSER.name, user) == 0) ||
	    (strcomp(user, LOOSER.nick) == 0) ||
	    (strcomp(user, LOOSER.sh_name) == 0)) {
		receiver = LOOSER.id;
		strcpy(rec_char, LOOSER.name);
	}
  }
  close(fd);
  mbunlock(UDBASE);


  if ((receiver == 0) && (EX_PM == 0)) {

	if (REPLY != 0) {
		strcpy(user, fetch_reciepy(REP));
		if (fetch_local == 1) goto TRY_AGAIN;
		strcpy(rec_char, (char *) stripped(user));
		if (strcomp(user, "OOPS") == 0) {
			ansi("md");
			printf("\n\n%s\n", MAL08_MSG);
			ansi("me ");
			unlink(TEP);
			unlink(REP); /* ??? */
			return -1;
		}
		EX_PM = 1;
		c = MAL13_MSG;
		goto REPLY_MARK;
	}
	else {
		ansi("md");
		strcpy(rec_char, (char *) stripped(user));
		printf("\n\n%s \"%s\" %s\n", MAL09_MSG, user, MAL10_MSG);
		ansi("me");
		if(WEITERLEITEN == 0) unlink(TEP);
		unlink(REP);
		return -1;
	}
  }

  if(WEITERLEITEN != 0) goto ONCE_MORE;

  unlink(REP);

  if (EX_PM == 0) {
	ansi("md");
	sprintf(s, "%s/usr/%d/.hello", HOME, receiver);
	printf("\n\n");
	show(s, 22, 0);
	ansi("me");
  }
  else {
	strcpy(rec_char, arg);
  }

  if(checkdomaintype( rec_char ) != 0) return -1;

  if (REPLY != 0) {
	c = MAL13_MSG;
	goto REPLY_MARK;
  }
  printf("\n\n");
  ansi("mr");
  printf("[%s \"%s\"] %s, ? > ", MAL11_MSG, rec_char, MAL12_MSG);
  ansi("me");
  printf("%c%c", MAL13_MSG, BS);

  do {
	c = getint();
	if (c >= 97) c -= 32;
	if (c == '?') {
		clearline();
		ansi("mr");
		printf("%c%s > ", CR, MAL16_MSG);
		ansi("me");
	}
	if (c == ENTER) c = MAL13_MSG;
	if ((c != MAL13_MSG) && (c != MAL14_MSG) && (c != MAL15_MSG)) c = 0;
  } while (c == 0);

  printf("%c", c);

  if (c == MAL15_MSG) {		/* VERWERFEN */
	unlink(REP);
	unlink(TEP);
	printf("\n");
	return -1;
  }
  sprintf(TEP, "%s/M%d", TMP, getpid());
  sprintf(pubdir, "%s/dir%d", TMP, getpid());

  if (c == MAL14_MSG) {		/* UPLOAD */
	clearline();
	ansi("mr");
	printf("%c%s, ? > ", CR, MAL17_MSG);
	ansi("me");

	do {
		protokoll = getint();
		if (protokoll >= 97) protokoll -= 32;
		if (protokoll == '?') {
			clearline();
			ansi("mr");
			printf("%c%s > ", CR, MAL17aMSG);
			ansi("me");
		}
		if ((protokoll != MAL18_MSG) && (protokoll != MAL18_MSG) &&
		    (protokoll != MAL20_MSG) && (protokoll != MAL21_MSG))
			protokoll = 0;
	} while (protokoll == 0);

	printf("%c", protokoll);

  }
  printf("\n\n%c", CR);
  ansi("mr");
  printf("%s ", MAL22_MSG);
  ansi("me");
  printf(" %s (%s)\n%c", USER.name, USER.nick, CR);
  ansi("mr");
  printf("%s ", MAL23_MSG);
  ansi("me");
  printf(" %s\n%c", rec_char, CR);
  ansi("mr");
  printf("%s ", MAL24_MSG);
  ansi("me");
  printf(" ");
  strcpy(subject, (char *) getline(50, 11, '.', ""));
  printf("\n");
  ansi("mr");
  printf("%s ", MAL23aMSG);
  ansi("me");
  printf(" ");
  strcpy(cc, (char *) getline(50, 11, '.', ""));


  REPLY_MARK:

  if(checkdomaintype( rec_char ) != 0) return -1;

  if (c == MAL13_MSG) {
	sprintf(s, "%s %s", EDDY, TEP);
	noctrlx();
	system(s);
	ctrlx();
	protokoll = '*';
  }
  else {			/* UPLOAD */

	printf("\n\n");
	printf("%s\n\n", MAL25_MSG); 
	ansi("md");
	printf("%s", MAL26_MSG);
	ansi("me");
          
	unlink( TEP );
	
	switch (protokoll) {
	    case MAL18_MSG:
			fp = fopen(TEP, "w");
			if (fp == NULL) {
				nerror("mail.c", 268, "brief", "DSF", TEP);
			}
			c = 0;
			lf = CR;

			fputc(LF, fp);

			while ((c != CTRL_X) && (c != CTRL_D)) {
				c = getint();
				if ((c == CR) && (lf == CR)) fputc(LF, fp);
				if (c == CR) lf = CR;
				if (c == LF) lf = LF;
				if ((c != CTRL_X) && (c != CTRL_D) && (c != CR)) {
					fputc(c, fp);
				}
			}
			fclose(fp);
			break;

	    case MAL19_MSG:
			printf("\n");
			sprintf(s, "exec %s -bc TimeTravelAgency", RX);
			break;
	    case MAL20_MSG:
			printf("\n");
			sprintf(s, "exec %s -b", RB);
			break;
	    case MAL21_MSG:
			printf("\n");
			sprintf(s, "exec %s -b", RZ);
			break;
	}
	if (protokoll != MAL18_MSG){
		mkdir( pubdir, 0777 );
		chdir( pubdir );

		system( s );

		chdir( HOME );
		sprintf(s, "mv %s/* %s", pubdir, TEP);
		system( s );
		sprintf(s, "rm -r %s", pubdir);
		system( s );
	}
	sync();
	stat(TEP, &fst);
	if (fst.st_size < 3L) {
		printf("\n\n%s\n", MAL27_MSG);
		control(MAL28_MSG, 3);
		unlink(REP);	/* ??? */
		unlink(TEP);
		return -1;
	}	
	if (prf(TEP) == 1) {
		printf("\n\n");
		ansi( "md" );
		printf("%s", MAL25_MSG);		
		ansi( "me" );
		unlink(REP); 	/* ??? */
		unlink(TEP);
		return -1;
		BINFILE++;
	}
	else{
		mkix(TEP);
	}
  }

  sprintf(reply, "%s <%s@%s>", USER.name, username, UUCPID);


  ONCE_MORE:

  if((HOLD != 0) || ((WEITERLEITEN != 0) && (IS_BUFFERED != 0))) goto HOLD_MARK;

  printf("\n\n");
  ansi("mr");
  printf("[%s \"%s\"] %s, ? > ", MAL11_MSG, rec_char, MAL28aMSG);
  ansi("me");
  printf("%c%c", MAL29_MSG, BS);

  do {
	c = getint();
	if (c >= 97) c -= 32;
	if (c == '?') {
		clearline();
		ansi("mr");
		printf("%c%s > ", CR, MAL32_MSG);
		ansi("me");
	}
	if (c == ENTER) c = MAL29_MSG;
	if ((c != MAL29_MSG) && (c != MAL30_MSG) && (c != MAL31_MSG) && (c != MAL31aMSG)) c = 0;
  } while (c == 0);

  printf("%c", c);

  if (c == MAL31_MSG) {		/* WEITERSCHREIBEN */
	sprintf(s, "%s %s", EDDY, TEP);
	noctrlx();
	system(s);
	ctrlx();
	goto ONCE_MORE;
  }
  if (c == MAL30_MSG) {		/* VERWERFEN */
	printf("\n");
	unlink(TEP);
	unlink(REP);
	return -1;
  }
  if (c == MAL31aMSG) {		/* HEADER */
	headline( MAL32aMSG );
	printf("\n");

	time(&timer);

	ansi( "md" );
	printf("From: ");
	ansi( "me" );
	printf("%s <%s@%s>\n", USER.name, username, UUCPID);

	ansi( "md" );
	printf("Reply-To: ");
	ansi( "me" );
	if(USER.level > GUEST_LEV){
		strcpy(reply, (char *) getline(80, 1001, 32, reply));
		printf("\n");
	}
	else printf("%s\n", reply);


	i = 0; j = 0;			/* Empfaenger: Realname */
	while(from[i] != '\0'){
		if(from[i] == '<'){
			strcpy(s, (char *) strcopy(from, 0, (i-1)));
			j = i;
		}
		if(from[i] == '(') j = i+1;
		if(from[i] == ')') strcpy(s, (char *) strcopy(from, j, (i-1)));
		i++;
	}
	if(j == 0) strcpy(s, from);
		
	if(mesg_id[0] != '\0'){
		ansi( "md" );
		printf("In-Reply-To: ");
		ansi( "me" );
		printf("%s; ", (char *) stripped(mesg_id)); 
		printf("from \"%s\" at %s", (char *) stripped(s), date);

		if(refs[0] != '\0') 
			sprintf(s, "%s ", stripped(refs));
		else
			s[0] = '\0';
		strcat(s, mesg_id);
		ansi( "md" );
		printf("References: ");
		ansi( "me" );
		printf("%s", s);
	}

	ansi( "md" );
	printf("To: ");
	ansi( "me" );
	if(USER.level > GUEST_LEV){
		strcpy(rec_char, (char *) getline(80, 1001, 32, rec_char));
		printf("\n");
	}
	else printf("%s\n", rec_char);

	ansi( "md" );
	printf("Cc: ");
	ansi( "me" );
	if(USER.level > GUEST_LEV){
		strcpy(cc, (char *) getline(80, 1001, 32, cc));
		printf("\n");
	}
	else printf("%s\n", cc);

	ansi( "md" );
	printf("Bcc: ");
	ansi( "me" );
	if(USER.level > GUEST_LEV){
		strcpy(bcc, (char *) getline(80, 1001, 32, bcc));
		printf("\n");
	}
	else printf("%s\n", bcc);


	ansi( "md" );
	printf("Subject: ");
	ansi( "me" );
	if(USER.level > GUEST_LEV){
		strcpy(subject, (char *) getline(80, 1001, 32, subject));
		printf("\n");
	}
	else printf("%s\n", subject);

	ansi( "md" );
	printf("Keywords: ");
	ansi( "me" );
	if(USER.level > GUEST_LEV){
		strcpy(keywords, (char *) getline(80, 1001, 32, keywords));
		printf("\n");
	}
	else printf("%s\n", keywords);

	ansi( "md" );
	printf("Comments: ");
	ansi( "me" );
	if(USER.level > GUEST_LEV){
		strcpy(comments, (char *) getline(80, 1001, 32, comments));
		printf("\n");
	}
	else printf("%s\n", comments);

	ansi( "md" );
	printf("Encrypted: ");
	ansi( "me" );
	if(USER.level > GUEST_LEV){
		strcpy(encrypted, (char *) getline(80, 1001, 32, encrypted));
		printf("\n");
	}
	else printf("%s\n", encrypted);

#ifdef _MULTIMEDIA
	ansi( "md" );
	printf("Mime-Version: ");
	ansi( "me" );
	printf("%s\n", MIME_VERSION);

	if(USER.level >= WRITE_INTERNAT){
		strcpy(content, (char *) "text/plain; charset=us-ascii");
		ansi( "md" ); 
		printf("Content-Type: ");
		ansi( "me" );
		strcpy(content, (char *) getline(80, 1001, 32, content));
		printf("\n");
	}
#endif

	ansi( "md" );
	printf("X-Mailer: ");
	ansi( "me" );
	printf("%s %s %s\n", VERSION, PATCHLEVEL, AUTOR);	

	ansi( "md" );
	printf("Priority: ");
	ansi( "me" );
	if(USER.level > GUEST_LEV){
		strcpy(priority, (char *) getline(80, 1001, 32, priority));
		printf("\n");
	}
	else printf("%s\n", priority);

	ansi( "md" );
	printf("Action: ");
	ansi( "me" );
	if(USER.level > GUEST_LEV){
		strcpy(action, (char *) getline(80, 1001, 32, action));
		printf("\n");
	}
	else printf("%s\n", action);

	ansi( "md" );
	printf("X-Fortune: ");
	ansi( "me" );
	if(USER.level > GUEST_LEV){
		strcpy(fortune, (char *) getline(80, 1001, 32, fortune));
		printf("\n");
	}
	else printf("%s\n", fortune);


	ansi( "md" );
	printf("Message-Id: ");
	ansi( "me" );
   	printf("<%x.%d@%s>\n", timer, USER.id, UUCPID);

	goto ONCE_MORE;
  }


  HOLD_MARK:
 

  if(UMLEITUNG == 0){
	if(WEITERLEITEN == 0){
		sprintf(s, "cp %s %s/usr/%d/.lastletter > /dev/null", TEP, HOME, USER.id);
		system( s );     
	}
	sprintf(s, "%s/usr/%d/.lastsubject", HOME, USER.id);
	fp = fopen( s, "w" );
	if(fp == NULL){
		nerror("mail.c", 500, "brief", "Datei-Schreibfehler", s);
	}
	fprintf(fp, "%s", subject);
	fclose(fp);
  }


  if (EX_PM == 0) {
	sprintf(s, "%s/usr/%d/seq", HOME, receiver);
	maybe_locked(s, "r");
	fp = fopen(s, "r");
	if (fp == NULL) {
		nerror("mail.c", 431, "brief", "Datei-Lesefehler", s);
	}
	fscanf(fp, "%d", &mail_id);
	fclose(fp);
	fp = fopen(s, "w");
	fprintf(fp, "%d\n", (mail_id + 1));
	fclose(fp);

	sprintf(s, "%s/usr/%d/%d", HOME, receiver, mail_id);
  }
  else {
	umask(0000);
	sprintf(s, "%s/%d.expm", TMP, getpid());
  }


  fp = fopen(s, "w");

  if (EX_PM == 0) {
	sprintf(s, "%s %s (%s)\n", GBL01_MSG, USER.name, USER.nick);
	fputs(s, fp);

	time(&timer);
	timeptr = localtime(&timer);
	strcpy(t, asctime(timeptr));

	sprintf(s, "%s %s", GBL02_MSG, t);
	fputs(s, fp);

	sprintf(s, "%s %s\n\n", GBL03_MSG, subject);
	fputs(s, fp);

	lines = 5;
   }
   else {
	lines = 4;
  }

  ff = fopen(TEP, "r");
  if (ff == 0) {
	printf("\n\n");
	ansi("md");
	printf("%s\n", MAL33_MSG);
	ansi("me");
	control(MAL34_MSG, 3);
	return;
  }


  if(EX_PM != 0){

	time(&timer);

	i = 0; j = 0;			/* Empfaenger: Realname */
	while(from[i] != '\0'){
		if(from[i] == '<'){
			strcpy(s, (char *) strcopy(from, 0, (i-1)));
			j = i;
		}
		if(from[i] == '(') j = i+1;
		if(from[i] == ')') strcpy(s, (char *) strcopy(from, j, (i-1)));
		i++;
	}
	if(j == 0) strcpy(s, from);

	fprintf(fp, "From: %s@%s (%s)\n", username, UUCPID, USER.name); 
	if(reply[0] != '\0')
		fprintf(fp, "Reply-To: %s\n", reply);
	fprintf(fp, "Organization: %s\n", ORGANIZATION);
	if(mesg_id[0] != '\0'){
		fprintf(fp, "In-Reply-To: %s; ", (char *) stripped(mesg_id)); 
		fprintf(fp, "from \"%s\" at %s", (char *) stripped(s), date);
		if(refs[0] != '\0') 
			sprintf(s, "%s ", stripped(refs));
		else
			s[0] = '\0';
		strcat(s, mesg_id);
		fprintf(fp, "References: %s", s);
	}
        fprintf(fp, "To: %s\n", rec_char);
	if(cc[0] != '\0')
		fprintf(fp, "Cc: %s\n", cc);

	sprintf(s, "%s/usr/%d/.face", HOME, USER.id); /* X-Face ??? */
	ft = fopen( s, "r" );
	if(ft != NULL){
		while(fgets(s, 70, ft) != NULL){
			fprintf(fp, "X-Face: %s\n", (char *) stripped(s));
		}
		fclose(ft);
	}

	if(subject[0] != '\0')
		fprintf(fp, "Subject: %s\n", subject);
	if(keywords[0] != '\0')
		fprintf(fp, "Keywords: %s\n", keywords);
	if(comments[0] != '\0')
		fprintf(fp, "Comments: %s\n", comments);
	if(encrypted[0] != '\0')
		fprintf(fp, "Encrypted: %s\n", encrypted);

#ifdef _MULTIMEDIA
	fprintf(fp, "Mime-Version: %s\n", MIME_VERSION);
#endif

	if(content[0] != '\0')
		fprintf(fp, "Content-Type: %s\n", content);
	fprintf(fp, "X-Mailer: %s %s %s\n", VERSION, PATCHLEVEL, AUTOR);	
	if(priority[0] != '\0')
		fprintf(fp, "Priority: %s\n", priority);
	if(action[0] != '\0')
		fprintf(fp, "Action: %s\n", action);
	if(fortune[0] != '\0')
		fprintf(fp, "X-Fortune: %s\n", fortune);
   	fprintf(fp, "Message-Id: <%x.%d@%s>\n", timer, USER.id, UUCPID);
 	fputs("\n", fp);
  }

  while (fgets(s, 80, ff) != 0) {
	fputs(s, fp);
	lines++;
  }
  fclose(ff);

  if(UMLEITUNG == 0){
	  sprintf(s, "%s/usr/%d/.signature", HOME, USER.id);
	  ff = fopen(s, "r");
	  if (ff != NULL) {
		while (fgets(s, 80, ff) != 0) {
			fputs(s, fp);
			lines++;
		}
		fclose(ff);
	  }
  }

  if(WEITERLEITEN == 0) unlink(TEP);
  fclose(fp);

  if (EX_PM == 0) {
	sprintf(s, "%s/usr/%d/INDEX", HOME, receiver);
	maybe_locked(s, "r"); 
	fp = fopen(s, "a");
	if (fp == NULL) {
		nerror("mail.c", 527, "brief", "Datei-Ergaenzungsfehler", s);
	}
	sprintf(s, "%d              ", mail_id);
	s[6] = '\0';
	if(HOLD != 0){
		s[5] = '>';
	}
	fputs(s, fp);

	sprintf(ex, "%s                                ", subject);
	ex[26] = '\0';
	fputs(ex, fp);

	sprintf(ex, "  %s                                        ", USER.name);
	ex[22] = '\0';
	fputs(ex, fp);

	strcpy(s, (char *) mydate(1));
	strcpy(t, (char *) mytime(1));
	sprintf(ex, "  %s  %s         ", s, t);
	ex[19] = '\0';
	fputs(ex, fp);

	sprintf(s, "%-6.d\n", lines);
	fputs(s, fp);

	fclose(fp);

  }
  else {
	sprintf(s, " X-Mail via UUCP (%s) ", rec_char);
	headline(s);
	printf("\n%s", MAL35_MSG);
	sprintf(s, "%s/%d.expm", TMP, getpid());
	sprintf(t, "/bin/sh ./etc/rmail.sh %s %s", s, rec_char);
	system(t);
	unlink(s);
	unlink(f);
	umask(0007);
	printf(" %s\n", MAL36_MSG);
  }

  unlink(REP);
  if(UMLEITUNG == 0) unlink(TEP);

  sprintf(s, "%s \"%s\" %s", MAL11_MSG, rec_char, MAL37_MSG);
  control(s, 3);

  printf("\n");

  if((cc[0] != '\0') || (bcc[0] != '\0')){
	carboncopy(cc, bcc);
  }

  return 0;
}




