/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  lesen2.c						   */
/*        FUNKTIONEN  anzeigen(), lesen2(), inhalt2(), loeschen2()	   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  20.11.1991					   */
/***************************************************************************/

#include <stdio.h>

#include "mbox.h"


extern char headinfo[STRING];

/***************************************************************************/
/*      FUNKTION  anzeigen()						   */
/*  BESCHREIBUNG  Artikel selektieren und anzeigen.			   */
/*     PARAMETER  art  =  Artikel(-Nummer)                                 */
/*		  von  =  Artikel-Nummer (Minimum)                         */
/*		  bis  =  Artikel-Nummer (Maximum)                         */
/*     RUECKGABE  siehe "show()"					   */
/***************************************************************************/

int anzeigen(art, von, bis)
int art, von, bis;
{
  char entry[STRING];
  char s[STRING];
  int mr;
  int ok;

 
  if (strcomp(BRETT, "PM") != 0) {
	sprintf(entry, "%s/%d", BRETT, art);
  }
  else {
	sprintf(entry, "%s/usr/%d/%d", HOME, USER.id, art);
  }

  mr = 0;
  if ((USER.more == 1) || (USER.more == 3)) mr = 2;

  sprintf(s, "%d", art);

  if (((art >= von) && (art <= bis)) ||
      ((art >= bis) && (art <= von))) {

	ok = pruefe(s);	

	if(ok == 0){
		if(USER.more != 0){
			sprintf(headinfo, " %s %d (%s) ", LE201_MSG, art, NG);
			headline( headinfo );
		}
		else{
			ansi("md");
			printf("%s %d\n", LE202_MSG, art);
			ansi("me");
		}
		show( "?", 99, 99 );
		ok = show(entry, 9999, mr);
		if(ok != -1){
			if(USER.more != 0) more();
		}
		else return ok;
	}
  }
  return ok;
}



/***************************************************************************/
/*      FUNKTION  lesen2() 						   */
/*  BESCHREIBUNG  Artikel selektieren (je nach Parameter) und anzeigen.    */
/*     PARAMETER  arg  =  Selektions-Schluessel                            */
/*		  mode =  DUMMY (!)                                        */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void lesen2(arg, mode)
char arg[];
char mode;
{
  FILE *fp;
  char ex[255];
  char s[STRING];
  char entry[STRING];
  int a = 56, b = 63;
  int i, d, e;
  int von, bis;
  int ALLE;
  int PM = 0;
  int art[MAX_PER_NG];
  int artp;
  int k, l;
  int LR = 0;


  i = 0;
  k = -1;
  l = -1;
  while (arg[i] != '\0') {
	if (arg[i] == '-') k = i;
	if (arg[i] == '*') l = i;
	i++;
  }

  if ((arg[0] != '\0') && (k == -1) && (l == -1)) {
	ansi("md");
	printf(" %s\n", LE203_MSG);
	ansi("me");
	return;
  }

  von = 1;
  bis = 32000;

  if (l != -1) {
	ALLE = 1;
  }
  if (k != -1) {
	strcpy(s, (char *) strcopy(arg, 0, (k - 1)));
	von = atoi(s);
	strcpy(s, (char *) strcopy(arg, (k + 1), length(arg)));
	bis = atoi(s);

	if (von == 0) von = 1;
	if (bis == 0) bis = 32000;
	ALLE = 1;
  }
  if ((k == -1) && (l == -1)) {
	ALLE = 0;
  }
  if ((von == 1) && (bis == 32000)) LR++;

  if ((USER.leserichtung != 1) && (LR != 0)) {
	i = von;
	von = bis;
	bis = i;
  }
  if (strcomp(BRETT, "PM") != 0) {
	PM = 0;
  }
  else {
	PM = 1;
  }

  d = a + 10;
  e = a + 14;

  maybe_locked(INHALT, "r");
  fp = fopen(INHALT, "r");
  if (fp == NULL) {
	nerror("lesen2.c", 104, "lesen2", "Datei-Lesefehler", INHALT);
  }
  artp = -1;

  while (fgets(ex, 250, fp) != NULL) {
	if (ALLE == 1) {
		artp++;
		art[artp] = atoi(ex);
	}
	else {
		strcpy(s, (char *) strcopy(ex, a, b));
		if (LASTLOG < dateconv(s)) {
			artp++;
			art[artp] = atoi(ex);
		}
		if (LASTLOG == dateconv(s)) {
			strcpy(s, (char *) strcopy(ex, d, e));
			if (LASTTIME <= timeconv(s)) {
				artp++;
				art[artp] = atoi(ex);
			}
		}
	}
	if(artp >= MAX_PER_NG){
		nerror("lesen2.c", 188, "lesen2", "Zuviele", "Artikel");
	}
  }
  fclose(fp);



  if (artp == -1) {
	ansi("md");
	printf(" %s", LE204_MSG);
	ansi("me");
	printf("\n");
	return;
  }
  ansi("cl");

  if (strcomp(BRETT, "PM") != 0) {
	i = von;
	von = bis;
	bis = i;
  }

  show("?", 0, 99);

  if (von > bis) {
	for (i = artp; i >= 0; i--) {
		if (anzeigen(art[i], von, bis) == -1) return;
	}
  }
  else {
	for (i = 0; i <= artp; i++) {
		if (anzeigen(art[i], von, bis) == -1) return;
	}
  }

  return;
}




/***************************************************************************/
/*      FUNKTION  inhalt2() 						   */
/*  BESCHREIBUNG  Inhalt selektieren (je nach Parameter) und anzeigen. 	   */
/*     PARAMETER  arg  =  Selektions-Schluessel                            */
/*		  mode =  DUMMY (!)                                        */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void inhalt2(arg, mode)
char arg[];
char mode;
{
  FILE *fp;
  FILE *ff;
  char ex[LONGSTRING];
  char s[STRING];
  char tmp[STRING];
  int a = 56, b = 63;
  int e, d, i;
  int von, bis;
  int k, l;
  int plus, minus;
  int PM;
  int ALLE;
  int LR = 0;


  i = 0;
  k = -1;
  l = -1;
  while (arg[i] != '\0') {
	if (arg[i] == '-') k = i;
	if (arg[i] == '*') l = i;
	i++;
  }

  von = 1;
  bis = 32000;

  if ((arg[0] != '\0') && (k == -1) && (l == -1)) {
	strcpy(s, (char *) strcopy(arg, 0, length(arg)));
	von = atoi(s);	
	bis = von;
	ALLE = 1;
  }

  if (l != -1) {
	ALLE = 1;
  }
  if (k != -1) {
	strcpy(s, (char *) strcopy(arg, 0, (k - 1)));
	von = atoi(s);
	strcpy(s, (char *) strcopy(arg, (k + 1), length(arg)));
	bis = atoi(s);

	if (von == 0) von = 1;
	if (bis == 0) bis = 32000;
	ALLE = 1;
  }

  fp = fopen(INHALT, "r");
  if (fp == NULL) {
	brett( "~" );
	return;
  }
  sprintf(tmp, "%s/I.%d", TMP, getpid());
  ff = fopen(tmp, "w");

  sprintf(ex, " %s (%s) ", LE205_MSG, NG);
  ex[80] = '\0';
  headline(ex);

  fgets(ex, 250, fp);	/* alte Ueberschrift ausblenden */
  fgets(ex, 250, fp);   /* dito */

  if(strcomp(PDNG, NG) == 0){
	printf("%s\n", GBL08_MSG); 
  }
  else{
	printf("%s\n", GBL05_MSG);
  }
  printf("===============================================================================\n", ff);
  

  PM = 1;
  if (strcomp(BRETT, "PM") != 0) {
	i = von;
	von = bis;
	bis = i;
	PM = 0;
  }
  plus = 0;
  minus = 0;

  d = a + 10;
  e = a + 14;

  if (((von == 1) && (bis == 32000)) || ((von == 32000) && (bis == 1))) LR++;

  if ((USER.leserichtung != 1) && (LR != 0)) {
	i = von;
	von = bis;
	bis = i;
  }
  if (von > bis) {
	while (fgets(ex, 250, fp) != NULL) {
		i = atoi(ex);
		if(i != 0) minus++;
		if (ALLE == 1) {
			if ((i >= bis) && (i <= von)) {
				fputs(ex, ff);
				plus++;
			}
		} else {
			strcpy(s, (char *) strcopy(ex, a, b));
			if (LASTLOG < dateconv(s)) {
				fputs(ex, ff);
				plus++;
			}
			if (LASTLOG == dateconv(s)) {
				strcpy(s, (char *) strcopy(ex, d, e));
				if (LASTTIME <= timeconv(s)) {
					fputs(ex, ff);
					plus++;
				}
			}
		}
	}
	fclose(ff);

	if (PM == 1)
		sprintf(s, "sort -nr -o %s %s", tmp, tmp);
	else
		sprintf(s, "sort -n -o %s %s", tmp, tmp);
	system(s);
  }
  else {
	while (fgets(ex, 250, fp) != 0) {
		i = atoi(ex);
		if(i != 0) minus++;
		if (ALLE == 1) {
			if ((i >= von) && (i <= bis)) {
				fputs(ex, ff);
				plus++;
			}
		} 
		else {
			strcpy(s, (char *) strcopy(ex, a, b));
			if (LASTLOG < (long) dateconv(s)) {
				fputs(ex, ff);
				plus++;
			}
			if (LASTLOG == (long) dateconv(s)) {
				strcpy(s, (char *) strcopy(ex, d, e));
				if (LASTTIME <= (long) timeconv(s)) {
					fputs(ex, ff);
					plus++;
				}
			}
		}
	}
	fclose(ff);
  }
  fclose(fp);

  if (plus != 0) show(tmp, 9999, USER.more + 100);

  unlink(tmp);

  if (plus == 0) {
	ansi("md");
	printf("%s", LE206_MSG);
	ansi("me");
	if ((minus - plus) > 0)
		printf("\n%s %d %s", LE207_MSG, minus, LE208_MSG);
	else
		printf("\n%s", LE209_MSG);
  }
  else if ((plus < 19) || (plus > 21)) {
	if ((minus - plus) > 0)
		printf("\n%s %d %s", LE210_MSG, (minus - plus), LE211_MSG);
	else
		printf("\n%s", LE212_MSG);
  }
  printf("\n");

  return;
}



/***************************************************************************/
/*      FUNKTION  loeschen2() 						   */
/*  BESCHREIBUNG  Persoenliche Post selektieren (je nach Parameter) und    */
/*                loeschen.						   */
/*     PARAMETER  arg  =  Selektions-Schluessel                            */
/*		  mode =  DUMMY (!)                                        */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void loeschen2(arg, mode)
char arg[];
char mode;
{
  FILE *fp;
  FILE *ff;
  char ex[255];
  char s[STRING];
  char tmp[STRING];
  int a, b, i;
  int von, bis;
  int k;
  int plus;
  int PM;


  if(USER.level == GUEST_LEV){
	return;
  }

  i = 0;
  k = -1;
  while (arg[i] != '\0') {
	if (arg[i] == '-') k = i;
	i++;
  }

  if ((arg[0] != '\0') && (k == -1)) {
	ansi("md");
	printf(" %s\n", LE213_MSG);
	ansi("me");
	return;
  }
  von = 1;
  bis = 32000;

  if (k != -1) {
	strcpy(s, (char *) strcopy(arg, 0, (k - 1)));
	von = atoi(s);
	strcpy(s, (char *) strcopy(arg, (k + 1), length(arg)));
	bis = atoi(s);

	if (von == 0) von = 1;
	if (bis == 0) bis = 32000;
  }
  if (strcomp(BRETT, "PM") != 0) {
	a = 60;
	b = 69;
  } else {
	a = 58;
	b = 65;
  }

  maybe_locked(INHALT, "r");

  sprintf(tmp, "%s/%d.l2", TMP, getpid());
  sprintf(s, "cp %s %s > /dev/null", INHALT, tmp);
  system(s);

  fp = fopen(tmp, "r");
  if (fp == NULL) {
	nerror("lesen2.c", 217, "loeschen2", "Datei-Lesefehler", tmp);
  }
  fgets(ex, 250, fp);
  fgets(ex, 250, fp);

  PM = 1;
  if (strcomp(BRETT, "PM") != 0) {
	i = von;
	von = bis;
	bis = i;
	PM = 0;
  }
  plus = 0;

  if (von > bis) {
	while (fgets(ex, 250, fp) != NULL) {
		i = atoi(ex);
		if ((i >= bis) && (i <= von)) {
			sprintf(s, "%d", i);
			loeschen(s);
			plus++;
		}
	}
  }
  else {
	while (fgets(ex, 250, fp) != NULL) {
		i = atoi(ex);
		if ((i >= von) && (i <= bis)) {
			sprintf(s, "%d", i);
			loeschen(s);
			plus++;
		}
	}
  }
  fclose(fp);

  if (plus == 0) {
	ansi("md");
	printf("%s\n", LE214_MSG);
	ansi("me");
	return;
  }
 
  unlink(tmp);

  return;
}
