/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  lesen.c						   */
/*        FUNKTIONEN  lesen(), ansage(), unterschrift()			   */
/*		      getsite(), checkdomaintype()			   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  04.01.1992					   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <utmp.h>
#include <time.h>


#include "mbox.h"


extern char headinfo[STRING];


/***************************************************************************/
/*      FUNKTION  lesen()						   */
/*  BESCHREIBUNG  Zeigt einen Artikel o. eine persoenliche Mail an. Bietet */
/*		  dann versch. Optionen zum Weiterlesen o. Beantworten an. */
/*     PARAMETER  arg  =  Nummer des Artikels/der Mail                     */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void lesen(arg)
char arg[];
{
  FILE *fp;
  char s[LSTRING];
  char entry[STRING];
  char no[10];
  char c;
  int i;
  int ok;
  int MIN, MAX;
  int pr;

  struct stat fst;

  sprintf(no, "%s", arg);

  maybe_locked(INHALT, "r");
  fp = fopen(INHALT, "r");
  if (fp == NULL) {
	nerror("misc.c", 558, "lesen", "Datei-Lesefehler", INHALT);
  }
  while ((fgets(s, LSTRING, fp) != NULL) && (s[2] != '='));
  fgets(s, LSTRING, fp);
  MIN = atoi(s);
  while (fgets(s, LSTRING, fp) != NULL) {
	MAX = atoi(s);
  }
  fclose(fp);

  if (MAX < MIN) {
	i = MIN;
	MIN = MAX;
	MAX = i;
  }
  NEXT_MSG:

  if ((no[0] < '1') || (no[0] > '9')) {
	ansi("md");
	printf(" %s\n", MIS41_MSG);
	ansi("me");
	return;
  }
  if (pruefe(no) != 0) goto NEXT_NEXT;

  printf("\n\n");
  ansi("cl");

  if (strcomp(BRETT, "PM") != 0) {
        sprintf(entry, "%s/%s", BRETT, no); 
	if(USER.terminal == 4){
		ansi("md");
		printf("%s %s\n", MIS42_MSG, no);
		ansi("me");
	}
	else{
		sprintf(headinfo, " %s %s (%s) ", MIS43_MSG, no, NG);
		headline( headinfo );
	}
	ok = show(entry, 9999, USER.more);
  }
  else {
	sprintf(entry, "%s/usr/%d/%s", HOME, USER.id, no);
	if(USER.terminal == 4){
		ansi("md");
		printf("%s %s\n", MIS44_MSG, no);
		ansi("me");
	}
	else{
		sprintf(headinfo, " %s (%s) ", MIS45_MSG, no);
		headline( headinfo );
	}
	ok = show(entry, 9999, USER.more);
  }

  if(ok == -1) return;

  c = LF;

  NEXT_NEXT:

  printf("\n");
  ansi("mr");
  printf("[Mesg. %s] %s, ? > ", no, MIS46_MSG);
  ansi("me");
  printf("%c%c", MIS51_MSG, BS);

  do {
	c = getint();
	if (c == MIS50_MSG) c = '*';
	if (c >= 97) c -= 32;
	if (c == ENTER) c = MIS51_MSG;
	if (c == '?') {
		clearline();
		ansi("mr");
		printf("%c%s > ", CR, MIS53_MSG);
		ansi("me");
	}
	if ((c != MIS47_MSG) && (c != MIS48_MSG) && (c != MIS49_MSG) && (c != MIS50_MSG) && (c != MIS51_MSG) && (c != MIS52_MSG) && (c != '*'))
		c = 0;
  } while (c == 0);

  printf("%c", c);

  if (c == MIS50_MSG) {		/* LOESCHEN */
	clearline();
	ansi("mr");
	printf("%s [%c, %c] > ", MIS54_MSG, GBL06_MSG, GBL07_MSG);
	ansi("me");
	if (yesno() == GBL06_MSG) {
		loeschen(no);
	}
	printf("\n");
	c = MIS51_MSG;
  }
  if (c == '*') {		/* LOESCHEN (sofort) */
	loeschen(no);
	printf("\n");
	c = MIS51_MSG;
  }
  if (c == MIS51_MSG) {		/* NAECHSTE */
	ok = 0;
	do {
		i = atoi(no);
		i++;
		sprintf(no, "%d", i);
		pr = pruefe(no);
		if (pr == 0) ok = 1;
		if (pr == 1) goto NEXT_NEXT;
		if (i > MAX) {
			printf("\n\n%s\n", MIS55_MSG);
			return;
		}
	} while (ok == 0);
	if (ok == 1) goto NEXT_MSG;
	goto NEXT_NEXT;
  }
  if (c == MIS52_MSG) {		/* VORHERIGE */
	ok = 0;
	do {
		i = atoi(no);
		i--;
		sprintf(no, "%d", i);
		pr = pruefe(no);
		if (pr == 0) ok = 1;
		if (pr == 1) goto NEXT_NEXT;
		if (i < MIN) {
			printf("\n\n%s\n", MIS56_MSG);
			return;
		}
	} while (ok == 0);
	if (ok == 1) goto NEXT_MSG;
	goto NEXT_NEXT;
  }
  if (c == MIS49_MSG) goto NEXT_MSG;	/* WIEDERHOLEN */


  if (c == MIS48_MSG) {			/* BEANTWORTEN */
	headline( MIS57_MSG );
	printf("\n%s", MIS58_MSG);
	sprintf(s, "cp %s %s/%dRep > /dev/null", entry, TMP, getpid());
	system(s);

	if (strcomp(BRETT, "PM") == 0) {
		brief("~REPLY~");
		sprintf(s, "%s?", USER.name);
		brief(s);
		sprintf(s, "%s/usr/%d/INDEX", HOME, USER.id);
		stat(s, &fst);
		IDX_SIZE = (int) fst.st_size;
	}
	else {
		printf("\n\n");
		ansi("mr");
		printf("%s, ? > ", MIS59_MSG);
		ansi("me");

		do {
			c = getint();
			if (c >= 97) c -= 32;
			if (c == '?') {
				clearline();
				ansi("mr");
				printf("%c%s > ", CR, MIS60_MSG);
				ansi("me");
			}
			if ((c != MIS61_MSG) && (c != MIS62_MSG)) c = 0;
		} while (c == 0);

		printf("%c", c);

		if (c == MIS62_MSG) {
			schreiben("");
		}
		if (c == MIS61_MSG) {
			brief("~REPLY~");
			if(strcomp(GUEST, USER.name) != 0){
				sprintf(s, "%s?", USER.name);
				brief(s);
				sprintf(s, "%s/usr/%d/INDEX", HOME, USER.id);
				stat(s, &fst);
			        IDX_SIZE = (long) fst.st_size;
			}
		}
	}
	goto NEXT_NEXT;
  }
  printf("\n");
  return;
}



/***************************************************************************/
/*      FUNKTION  ansage()						   */
/*  BESCHREIBUNG  Der Ansage-Text wird angezeigt und kann geandert werden. */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void ansage()
{
  FILE *ff;
  char s[STRING];
  char t[STRING];
  char TEP[STRING];
  char c;


  printf("\n\n%s\n\n", MAL38_MSG);

  sprintf(TEP, "%s/usr/%d/.hello", HOME, USER.id);
  ff = fopen(TEP, "r");
  if (ff != NULL) {
	ansi("md");
	while (fgets(s, 80, ff) != NULL) {
		printf("%s", s);
	}
	fclose(ff);
	ansi("me");
	printf("\n\n");
  }
  ansi("mr");
  printf("%c%s [%c, %c] > ", CR, MAL39_MSG, GBL06_MSG, GBL07_MSG);
  ansi("me");

  c = yesno();

  if (c == GBL06_MSG) {
	sprintf(t, "%s %s", EDDY, TEP);
	system(t);
  }
  printf("\n");
}




/***************************************************************************/
/*      FUNKTION  unterschrift						   */
/*  BESCHREIBUNG  Die Unterschrift (.signature) wird angezeigt und kann    */
/*		  geandert werden.                                         */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void unterschrift()
{
  FILE *ff;
  char s[STRING];
  char t[STRING];
  char TEP[STRING];
  char c;


  printf("\n\n%s\n\n", MAL40_MSG);

  sprintf(TEP, "%s/usr/%d/.signature", HOME, USER.id);
  ff = fopen(TEP, "r");
  if (ff != NULL) {
	ansi("md");
	while (fgets(s, 80, ff) != NULL) {
		printf("%s", s);
	}
	fclose(ff);
	ansi("me");
	printf("\n\n");
  }
  ansi("mr");
  printf("%c%s [%c, %c] > ", CR, MAL41_MSG, GBL06_MSG, GBL07_MSG);
  ansi("me");

  c = yesno();

  if (c == GBL06_MSG) {
	sprintf(t, "%s %s", EDDY, TEP);
	system(t);
  }
  printf("\n");
}




/***************************************************************************/
/*      FUNKTION  getsite()						   */
/*  BESCHREIBUNG  Findet den Empfaenger SITE in der Adresse		   */
/*     PARAMETER  Adresse                                                  */
/*     RUECKGABE  Empfaenger SITE                                          */
/***************************************************************************/

char *getsite(arg)
char arg[];
{
  int i = 0, a = 0, b = 0, c = 0;
  char s[STRING];

  while(arg[i] != '\0'){
	if(arg[i] == '!') a = i - 1;
	if(arg[i] == '@') b = i + 1;
	if(arg[i] == '.'){
		if((b != 0) && (c == 0)) c = i -1;
	}
	i++;
  }

  if((a == 0) && (b == 0)) strcat(s, UUCPSITE);
  if(a != 0) strcpy(s, (char *) strcopy(arg, 0, a));
  if(b != 0) strcpy(s, (char *) strcopy(arg, b, c));

  return (char *) s;
}




/***************************************************************************/
/*      FUNKTION  checkdomaintype()					   */
/*  BESCHREIBUNG  Internationale MAIL ???			 	   */
/*     PARAMETER  Adresse                                                  */
/*     RUECKGABE   0 = ok                                                  */
/*                -1 = Level zu gering					   */
/***************************************************************************/

int checkdomaintype(arg)
char arg[];
{
  int i = 0, l, a, e = 0, f = 0, g = 0, international = 0;
  char s[STRING];

  if(USER.level >= WRITE_INTERNAT) return 0;

  while(arg[i] != '\0'){
	if(arg[i] == '!') e++;
	if(arg[i] == '@') g++;
	i++;
  }
  s[0] = '\0';

  if((e == 0) && (g == 0)) return 0;

  if(e > 1) international++;

  if(e == 0){

	l = strlen( (char *) arg);

	a = strlen( (char *) NAT_DOMAIN1 );
	strcpy(s, (char *) strcopy(arg, (l-a), l));
	if(strcomp(s, NAT_DOMAIN1) == 0) f++;

	a = strlen( (char *) NAT_DOMAIN2 );
	strcpy(s, (char *) strcopy(arg, (l-a), l));
	if(strcomp(s, NAT_DOMAIN2) == 0) f++;

	a = strlen( (char *) NAT_DOMAIN3 );
	strcpy(s, (char *) strcopy(arg, (l-a), l));
	if(strcomp(s, NAT_DOMAIN3) == 0) f++;  	

	if(f == 0) international++;
  }  

  if(international != 0){
	ansi("md");
	printf("\n\n%s (%d) %s\n", MAL01_MSG, WRITE_INTERNAT, MAL02_MSG);
	ansi("me");
	return -1;	
  }

  return 0;
}




