/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  ctrlx.c						   */
/*        FUNKTIONEN  ctrlx(), noctrlx()				   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  16.11.1991					   */
/***************************************************************************/

#ifdef _SYS7	/* UNIX System 7  (MINIX, COHERENT, ...) */

#include  <sgtty.h>
static struct tchars newtc, oldtc;

#else		/* UNIX System V  (UNIX, XENIX, ESIX, ...) */

#include  <sys/termio.h> 
static struct termio newtc, oldtc;

#endif




/***************************************************************************/
/*      FUNKTION  ctrlx()						   */
/*  BESCHREIBUNG  Das QUIT-Zeichen wird auf (int) 24 gesetzt - das ent-	   */
/*		  spricht einem CTRL-X. Wird nun CTRL-X gedrueckt, loest   */
/*		  UNIX das Signal SIGABRT aus ...                          */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

void ctrlx()
{

#ifdef _SYS7

  ioctl(0, TIOCGETC, (struct sgttyb *) &oldtc);
  newtc = oldtc;
  newtc.t_quitc = 24;
  ioctl(0, TIOCSETC, (struct sgttyb *) &newtc);

#else

  ioctl(0, TCGETA, (struct termio *) &oldtc);
  newtc = oldtc;
  newtc.c_cc[VQUIT] = 24;
  ioctl(0, TCSETA, (struct termio *) &newtc);

#endif

}


/***************************************************************************/
/*      FUNKTION  noctrlx()						   */
/*  BESCHREIBUNG  Das QUIT-Zeichen wird "restauriert" ...		   */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

void noctrlx()
{

#ifdef _SYS7

  ioctl(0, TIOCSETC, (struct sgttyb *) &oldtc);

#else

  ioctl(0, TCSETA, (struct termio *) &oldtc);

#endif

}
