/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  control.c						   */
/*        FUNKTIONEN  control(), whodo()				   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  24.11.1991					   */
/***************************************************************************/

#include <stdio.h>

#include "mbox.h"



/***************************************************************************/
/*      FUNKTION  control()						   */
/*  BESCHREIBUNG  Fuehrt ein "Logbuch" in zwei versch. Dateien/auf zwei    */
/*		  versch. Geraeten (CONSOLE & CPRN).                       */
/*     PARAMETER  text  =  Ansage-Text                                     */
/*		  mode  =  '< 99'  =  Ausgabe auf CONSOLE                  */
/*		  mode  =  '= 99'  =  Ausgabe auf CPRN                     */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

FILE *contfp = NULL;

void control(text, mode)
char text[];
int mode;
{
  if (mode < 99) {

#ifdef _MINIX
	if(tty() >= FIRST_EX_TTY){
#endif
		contfp = fopen(CONSOLE_REDIRECT, "a");
		if (contfp == NULL) {
			printf("\n\n%s [%s]\n\n", CTL01_MSG, CONSOLE_REDIRECT);
			exit(-1);
		}
#ifdef _DATESTAMP
		fprintf(contfp, "%s %s <%s>  %s\n", mydate(1), mytime(1), ttyna(), text);
#else
		fprintf(contfp, "MBOX: (%s:) %s\n", ttyna(), text);
#endif
		fflush(contfp);
		fclose(contfp);
#ifdef _MINIX
	}
#endif

  }
  if (mode == 99) {
	contfp = fopen(CPRN, "a");
	if (contfp == NULL) {
		printf("\n\n%s [%s]\n\n", CTL01_MSG, CPRN);
		exit(-1);
	}
	fprintf(contfp, "\n%s  -  %s\n", mydate(1), mytime(1));
	fprintf(contfp, "MBOX: (%s:) %s\n", ttyna(), text);
	fflush(contfp);
	fclose(contfp);
  }
}



/***************************************************************************/
/*      FUNKTION  whodo()						   */
/*  BESCHREIBUNG  Erstellt eine Datei fuer die "portinfo()"-Routine.       */
/*     PARAMETER  text = Ansage-Text (aktiver Befehl etc.)                 */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void whodo(text)
char text[];
{
  FILE *fp;
  char s[STRING];

  s[0] = '\0'; strcat(s, HOME); strcat(s, "/etc/");
  strcat(s, (char *) ttyna()); strcat(s, ".");

  fp = fopen(s, "w");
  if (fp == NULL) {
	nerror("control.c", 44, "whodo", "Datei-Schreibfehler", s);
  }
  fputs(text, fp);
  fclose(fp);
}
